/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.context;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.view.menu.ActionMenuItemView;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.animation.IconicsAnimationExtensionsKt;
import com.mikepenz.iconics.context.IconicsAttrsApplier;
import com.mikepenz.iconics.core.R;
import com.mikepenz.iconics.utils.IconicsExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0003\u00a8\u0006\f"}, d2={"Lcom/mikepenz/iconics/context/IconicsFactory;", "", "()V", "onViewCreated", "Landroid/view/View;", "view", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "onViewCreatedInternal", "", "iconics-core"})
public final class IconicsFactory {
    public static final IconicsFactory INSTANCE;

    @JvmStatic
    @Nullable
    public static final View onViewCreated(@Nullable View view, @NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        if (view != null && Intrinsics.areEqual((Object)view.getTag(R.id.iconics_tag_id), (Object)true) ^ true) {
            IconicsFactory.onViewCreatedInternal(view, context, attrs);
            view.setTag(R.id.iconics_tag_id, (Object)true);
        }
        return view;
    }

    @JvmStatic
    @SuppressLint(value={"RestrictedApi"})
    private static final void onViewCreatedInternal(View view, Context context, AttributeSet attrs) {
        block5: {
            View view2;
            block7: {
                block6: {
                    block4: {
                        if (attrs == null) {
                            return;
                        }
                        view2 = view;
                        if (!(view2 instanceof ActionMenuItemView)) break block4;
                        IconicsDrawable iconicsDrawable2 = IconicsAttrsApplier.getIconicsDrawable(context, attrs);
                        if (iconicsDrawable2 == null) break block5;
                        IconicsDrawable iconicsDrawable3 = iconicsDrawable2;
                        boolean bl = false;
                        boolean bl2 = false;
                        IconicsDrawable it = iconicsDrawable3;
                        boolean bl3 = false;
                        try {
                            ((ActionMenuItemView)view).setIcon((Drawable)IconicsAnimationExtensionsKt.tryToEnableIconicsAnimation(view, it));
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Exception ex) {
                            Integer n = Log.e((String)"IconicsFactory", (String)"Could not apply the icon as the `ActionMenuItemView` is not ready.");
                        }
                        break block5;
                    }
                    if (!(view2 instanceof EditText)) break block6;
                    IconicsExtensionsKt.buildIconics$default((TextView)view, null, 1, null);
                    break block5;
                }
                if (!(view2 instanceof TextView)) break block7;
                IconicsExtensionsKt.buildIconics$default((TextView)view, null, 1, null);
                ((TextView)view).addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(@NotNull CharSequence cs, int i, int i1, int i2) {
                        Intrinsics.checkParameterIsNotNull((Object)cs, (String)"cs");
                    }

                    public void onTextChanged(@NotNull CharSequence cs, int i, int i1, int i2) {
                        Intrinsics.checkParameterIsNotNull((Object)cs, (String)"cs");
                    }

                    public void afterTextChanged(@NotNull Editable editable) {
                        Intrinsics.checkParameterIsNotNull((Object)editable, (String)"editable");
                        Iconics.styleEditable(editable);
                    }
                });
                break block5;
            }
            if (!(view2 instanceof ImageView)) break block5;
            IconicsDrawable iconicsDrawable4 = IconicsAttrsApplier.getIconicsDrawable(context, attrs);
            if (iconicsDrawable4 != null) {
                IconicsDrawable iconicsDrawable5 = iconicsDrawable4;
                boolean bl = false;
                boolean bl4 = false;
                IconicsDrawable it = iconicsDrawable5;
                boolean bl5 = false;
                ((ImageView)view).setImageDrawable((Drawable)IconicsAnimationExtensionsKt.tryToEnableIconicsAnimation(view, it));
            }
        }
    }

    private IconicsFactory() {
    }

    static {
        IconicsFactory iconicsFactory;
        INSTANCE = iconicsFactory = new IconicsFactory();
    }
}

