/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.context;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleableRes;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.IconicsColor;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.IconicsSize;
import com.mikepenz.iconics.animation.IconicsAnimatedDrawable;
import com.mikepenz.iconics.animation.IconicsAnimationProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u00bf\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\u0007\u0012\b\b\u0003\u0010\t\u001a\u00020\u0007\u0012\b\b\u0003\u0010\n\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0003\u0010\f\u001a\u00020\u0007\u0012\b\b\u0003\u0010\r\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u000e\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u000f\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u0010\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u0011\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u0012\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u0013\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u0014\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u0015\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u0016\u001a\u00020\u0007\u0012\b\b\u0003\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aJ\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u001aJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010 \u001a\u00020\u001a*\u0004\u0018\u00010\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001d\u0010!\u001a\u0004\u0018\u00010\u0007*\u00020\u00052\b\b\u0001\u0010\"\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/mikepenz/iconics/context/IconicsAttrsExtractor;", "", "context", "Landroid/content/Context;", "typedArray", "Landroid/content/res/TypedArray;", "iconId", "", "sizeId", "colorsId", "paddingId", "offsetXId", "offsetYId", "contourColorId", "contourWidthId", "backgroundColorId", "cornerRadiusId", "backgroundContourColorId", "backgroundContourWidthId", "shadowRadiusId", "shadowDxId", "shadowDyId", "shadowColorId", "animationsId", "(Landroid/content/Context;Landroid/content/res/TypedArray;IIIIIIIIIIIIIIIII)V", "extract", "Lcom/mikepenz/iconics/IconicsDrawable;", "icon", "extractOffsets", "", "extractNonNull", "extractWithOffsets", "createIfNeeds", "getDimensionPixelSize", "index", "(Landroid/content/res/TypedArray;I)Ljava/lang/Integer;", "Companion", "iconics-core"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class IconicsAttrsExtractor {
    private final Context context;
    private final TypedArray typedArray;
    private int iconId;
    private int sizeId;
    private int colorsId;
    private int paddingId;
    private int offsetXId;
    private int offsetYId;
    private int contourColorId;
    private int contourWidthId;
    private int backgroundColorId;
    private int cornerRadiusId;
    private int backgroundContourColorId;
    private int backgroundContourWidthId;
    private int shadowRadiusId;
    private int shadowDxId;
    private int shadowDyId;
    private int shadowColorId;
    private int animationsId;
    private static final int DEF_COLOR = Integer.MIN_VALUE;
    private static final int DEF_SIZE = -1;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final IconicsDrawable extractNonNull() {
        return this.createIfNeeds(this.extract(null, false), this.context);
    }

    @Nullable
    public final IconicsDrawable extract(@Nullable IconicsDrawable icon) {
        return this.extract(icon, false);
    }

    @Nullable
    public final IconicsDrawable extract() {
        return this.extract(null, false);
    }

    @Nullable
    public final IconicsDrawable extractWithOffsets() {
        return this.extract(null, true);
    }

    /*
     * WARNING - void declaration
     */
    private final IconicsDrawable extract(IconicsDrawable icon, boolean extractOffsets) {
        IconicsDrawable iconicsDrawable = icon;
        IconicsDrawable processedIcon = iconicsDrawable != null ? iconicsDrawable.clone() : null;
        String i = this.typedArray.getString(this.iconId);
        Object object = i;
        boolean bl = false;
        boolean bl2 = false;
        if (!(object == null || object.length() == 0)) {
            processedIcon = this.createIfNeeds(processedIcon, this.context).icon(i);
        }
        ColorStateList colorStateList = this.typedArray.getColorStateList(this.colorsId);
        if (colorStateList != null) {
            object = colorStateList;
            bl = false;
            bl2 = false;
            CharSequence it = object;
            boolean bl3 = false;
            IconicsDrawable iconicsDrawable2 = this.createIfNeeds(processedIcon, this.context);
            CharSequence charSequence = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"it");
            processedIcon = iconicsDrawable2.color(IconicsColor.Companion.colorList((ColorStateList)charSequence));
        }
        Integer n = this.getDimensionPixelSize(this.typedArray, this.sizeId);
        if (n != null) {
            object = n;
            bl = false;
            bl2 = false;
            int it = ((Number)object).intValue();
            boolean bl4 = false;
            processedIcon = this.createIfNeeds(processedIcon, this.context).size(IconicsSize.Companion.px(it));
        }
        Integer n2 = this.getDimensionPixelSize(this.typedArray, this.paddingId);
        if (n2 != null) {
            object = n2;
            bl = false;
            bl2 = false;
            int it = ((Number)object).intValue();
            boolean bl5 = false;
            processedIcon = this.createIfNeeds(processedIcon, this.context).padding(IconicsSize.Companion.px(it));
        }
        if (extractOffsets) {
            Integer n3 = this.getDimensionPixelSize(this.typedArray, this.offsetYId);
            if (n3 != null) {
                object = n3;
                bl = false;
                bl2 = false;
                int it = ((Number)object).intValue();
                boolean bl6 = false;
                processedIcon = this.createIfNeeds(processedIcon, this.context).iconOffsetY(IconicsSize.Companion.px(it));
            }
            Integer n4 = this.getDimensionPixelSize(this.typedArray, this.offsetXId);
            if (n4 != null) {
                object = n4;
                bl = false;
                bl2 = false;
                int it = ((Number)object).intValue();
                boolean bl7 = false;
                processedIcon = this.createIfNeeds(processedIcon, this.context).iconOffsetX(IconicsSize.Companion.px(it));
            }
        }
        ColorStateList colorStateList2 = this.typedArray.getColorStateList(this.contourColorId);
        if (colorStateList2 != null) {
            object = colorStateList2;
            bl = false;
            bl2 = false;
            Object it = object;
            boolean bl8 = false;
            IconicsDrawable iconicsDrawable3 = this.createIfNeeds(processedIcon, this.context);
            Object object2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
            processedIcon = iconicsDrawable3.contourColor(IconicsColor.Companion.colorList((ColorStateList)object2));
        }
        Integer n5 = this.getDimensionPixelSize(this.typedArray, this.contourWidthId);
        if (n5 != null) {
            object = n5;
            bl = false;
            bl2 = false;
            int it = ((Number)object).intValue();
            boolean bl9 = false;
            processedIcon = this.createIfNeeds(processedIcon, this.context).contourWidth(IconicsSize.Companion.px(it));
        }
        ColorStateList colorStateList3 = this.typedArray.getColorStateList(this.backgroundColorId);
        if (colorStateList3 != null) {
            object = colorStateList3;
            bl = false;
            bl2 = false;
            Object it = object;
            boolean bl10 = false;
            IconicsDrawable iconicsDrawable4 = this.createIfNeeds(processedIcon, this.context);
            Object object3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
            processedIcon = iconicsDrawable4.backgroundColor(IconicsColor.Companion.colorList((ColorStateList)object3));
        }
        Integer n6 = this.getDimensionPixelSize(this.typedArray, this.cornerRadiusId);
        if (n6 != null) {
            object = n6;
            bl = false;
            bl2 = false;
            int it = ((Number)object).intValue();
            boolean bl11 = false;
            processedIcon = this.createIfNeeds(processedIcon, this.context).roundedCorners(IconicsSize.Companion.px(it));
        }
        ColorStateList colorStateList4 = this.typedArray.getColorStateList(this.backgroundContourColorId);
        if (colorStateList4 != null) {
            object = colorStateList4;
            bl = false;
            bl2 = false;
            Object it = object;
            boolean bl12 = false;
            IconicsDrawable iconicsDrawable5 = this.createIfNeeds(processedIcon, this.context);
            Object object4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"it");
            processedIcon = iconicsDrawable5.backgroundContourColor(IconicsColor.Companion.colorList((ColorStateList)object4));
        }
        Integer n7 = this.getDimensionPixelSize(this.typedArray, this.backgroundContourWidthId);
        if (n7 != null) {
            object = n7;
            bl = false;
            bl2 = false;
            int it = ((Number)object).intValue();
            boolean bl13 = false;
            processedIcon = this.createIfNeeds(processedIcon, this.context).backgroundContourWidth(IconicsSize.Companion.px(it));
        }
        Integer shadowRadius = this.getDimensionPixelSize(this.typedArray, this.shadowRadiusId);
        Integer shadowDx = this.getDimensionPixelSize(this.typedArray, this.shadowDxId);
        Integer shadowDy = this.getDimensionPixelSize(this.typedArray, this.shadowDyId);
        int shadowColor = this.typedArray.getColor(this.shadowColorId, Integer.MIN_VALUE);
        if (shadowRadius != null && shadowDx != null && shadowDy != null && shadowColor != Integer.MIN_VALUE) {
            processedIcon = this.createIfNeeds(processedIcon, this.context).shadow(IconicsSize.Companion.px(shadowRadius), IconicsSize.Companion.px(shadowDx), IconicsSize.Companion.px(shadowDy), IconicsColor.Companion.colorInt(shadowColor));
        }
        String animations = this.typedArray.getString(this.animationsId);
        CharSequence charSequence = animations;
        boolean bl14 = false;
        boolean bl15 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            void $this$toTypedArray$iv;
            void $this$mapNotNullTo$iv$iv;
            List list;
            CharSequence charSequence2 = animations;
            String string = "\\|";
            int n8 = 0;
            string = new Regex(string);
            n8 = 0;
            boolean bl16 = false;
            List $this$dropLastWhile$iv = string.split(charSequence2, n8);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl17 = false;
                    CharSequence charSequence3 = it;
                    boolean bl18 = false;
                    if (charSequence3.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterator$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IconicsAnimationProcessor iconicsAnimationProcessor;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl19 = false;
                String it = (String)element$iv$iv;
                boolean bl20 = false;
                if (Iconics.findProcessor(it) == null) continue;
                boolean bl21 = false;
                boolean bl22 = false;
                IconicsAnimationProcessor it$iv$iv = iconicsAnimationProcessor;
                boolean bl23 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List processors = (List)destination$iv$iv;
            $this$mapNotNull$iv = processors;
            IconicsAnimatedDrawable iconicsAnimatedDrawable = this.createIfNeeds(processedIcon, this.context).toAnimatedDrawable();
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            IconicsAnimationProcessor[] iconicsAnimationProcessorArray = thisCollection$iv.toArray(new IconicsAnimationProcessor[0]);
            if (iconicsAnimationProcessorArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            IconicsAnimationProcessor[] iconicsAnimationProcessorArray2 = iconicsAnimationProcessorArray;
            processedIcon = iconicsAnimatedDrawable.processors(Arrays.copyOf(iconicsAnimationProcessorArray2, iconicsAnimationProcessorArray2.length));
        }
        return processedIcon;
    }

    private final Integer getDimensionPixelSize(@NotNull TypedArray $this$getDimensionPixelSize, @StyleableRes int index) {
        Integer n = $this$getDimensionPixelSize.getDimensionPixelSize(index, -1);
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        return it != -1 ? n : null;
    }

    private final IconicsDrawable createIfNeeds(@Nullable IconicsDrawable $this$createIfNeeds, Context context) {
        IconicsDrawable iconicsDrawable = $this$createIfNeeds;
        if (iconicsDrawable == null) {
            iconicsDrawable = new IconicsDrawable(context);
        }
        return iconicsDrawable;
    }

    public IconicsAttrsExtractor(@NotNull Context context, @NotNull TypedArray typedArray, @StyleableRes int iconId, @StyleableRes int sizeId, @StyleableRes int colorsId, @StyleableRes int paddingId, @StyleableRes int offsetXId, @StyleableRes int offsetYId, @StyleableRes int contourColorId, @StyleableRes int contourWidthId, @StyleableRes int backgroundColorId, @StyleableRes int cornerRadiusId, @StyleableRes int backgroundContourColorId, @StyleableRes int backgroundContourWidthId, @StyleableRes int shadowRadiusId, @StyleableRes int shadowDxId, @StyleableRes int shadowDyId, @StyleableRes int shadowColorId, @StyleableRes int animationsId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)typedArray, (String)"typedArray");
        this.context = context;
        this.typedArray = typedArray;
        this.iconId = iconId;
        this.sizeId = sizeId;
        this.colorsId = colorsId;
        this.paddingId = paddingId;
        this.offsetXId = offsetXId;
        this.offsetYId = offsetYId;
        this.contourColorId = contourColorId;
        this.contourWidthId = contourWidthId;
        this.backgroundColorId = backgroundColorId;
        this.cornerRadiusId = cornerRadiusId;
        this.backgroundContourColorId = backgroundContourColorId;
        this.backgroundContourWidthId = backgroundContourWidthId;
        this.shadowRadiusId = shadowRadiusId;
        this.shadowDxId = shadowDxId;
        this.shadowDyId = shadowDyId;
        this.shadowColorId = shadowColorId;
        this.animationsId = animationsId;
    }

    public /* synthetic */ IconicsAttrsExtractor(Context context, TypedArray typedArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n18 & 4) != 0) {
            n = 0;
        }
        if ((n18 & 8) != 0) {
            n2 = 0;
        }
        if ((n18 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n18 & 0x20) != 0) {
            n4 = 0;
        }
        if ((n18 & 0x40) != 0) {
            n5 = 0;
        }
        if ((n18 & 0x80) != 0) {
            n6 = 0;
        }
        if ((n18 & 0x100) != 0) {
            n7 = 0;
        }
        if ((n18 & 0x200) != 0) {
            n8 = 0;
        }
        if ((n18 & 0x400) != 0) {
            n9 = 0;
        }
        if ((n18 & 0x800) != 0) {
            n10 = 0;
        }
        if ((n18 & 0x1000) != 0) {
            n11 = 0;
        }
        if ((n18 & 0x2000) != 0) {
            n12 = 0;
        }
        if ((n18 & 0x4000) != 0) {
            n13 = 0;
        }
        if ((n18 & 0x8000) != 0) {
            n14 = 0;
        }
        if ((n18 & 0x10000) != 0) {
            n15 = 0;
        }
        if ((n18 & 0x20000) != 0) {
            n16 = 0;
        }
        if ((n18 & 0x40000) != 0) {
            n17 = 0;
        }
        this(context, typedArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/mikepenz/iconics/context/IconicsAttrsExtractor$Companion;", "", "()V", "DEF_COLOR", "", "DEF_SIZE", "iconics-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

