/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.context;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.iconics.context.IconicsFactory;
import com.mikepenz.iconics.context.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;

class InternalLayoutInflater
extends LayoutInflater {
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit."};
    private final IconicsFactory mIconicsFactory = new IconicsFactory();
    private boolean mSetPrivateFactory = false;
    private Field mConstructorArgs = null;

    protected InternalLayoutInflater(Context context) {
        super(context);
        this.setUpLayoutFactories(false);
    }

    protected InternalLayoutInflater(LayoutInflater original, Context newContext, boolean cloned) {
        super(original, newContext);
        this.setUpLayoutFactories(cloned);
    }

    public LayoutInflater cloneInContext(Context newContext) {
        return new InternalLayoutInflater(this, newContext, true);
    }

    protected View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        View view = null;
        for (String prefix : sClassPrefixList) {
            try {
                view = this.createView(name, prefix, attrs);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (view == null) {
            view = super.onCreateView(name, attrs);
        }
        return this.mIconicsFactory.onViewCreated(view, view.getContext(), attrs);
    }

    protected View onCreateView(View parent, String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.mIconicsFactory.onViewCreated(super.onCreateView(parent, name, attrs), this.getContext(), attrs);
    }

    public View inflate(XmlPullParser parser, ViewGroup root, boolean attachToRoot) {
        this.setPrivateFactoryInternal();
        return super.inflate(parser, root, attachToRoot);
    }

    private void setUpLayoutFactories(boolean cloned) {
        if (cloned) {
            return;
        }
        if (this.getFactory2() != null && !(this.getFactory2() instanceof WrapperFactory2)) {
            this.setFactory2(this.getFactory2());
        }
    }

    public void setFactory(LayoutInflater.Factory factory) {
        if (!(factory instanceof WrapperFactory)) {
            super.setFactory((LayoutInflater.Factory)new WrapperFactory(factory, this, this.mIconicsFactory));
        } else {
            super.setFactory(factory);
        }
    }

    @TargetApi(value=11)
    public void setFactory2(LayoutInflater.Factory2 factory2) {
        if (!(factory2 instanceof WrapperFactory2)) {
            super.setFactory2((LayoutInflater.Factory2)new WrapperFactory2(factory2, this.mIconicsFactory));
        } else {
            super.setFactory2(factory2);
        }
    }

    private void setPrivateFactoryInternal() {
        if (this.mSetPrivateFactory) {
            return;
        }
        if (!(this.getContext() instanceof LayoutInflater.Factory2)) {
            this.mSetPrivateFactory = true;
            return;
        }
        Method setPrivateFactoryMethod = ReflectionUtils.getMethod(LayoutInflater.class, "setPrivateFactory");
        if (setPrivateFactoryMethod != null) {
            ReflectionUtils.invokeMethod((Object)this, setPrivateFactoryMethod, new PrivateWrapperFactory2((LayoutInflater.Factory2)this.getContext(), this, this.mIconicsFactory));
        }
        this.mSetPrivateFactory = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View createCustomViewInternal(View parent, View view, String name, Context viewContext, AttributeSet attrs) {
        boolean customViewCreation = true;
        if (!customViewCreation) {
            return view;
        }
        if (view == null && name.indexOf(46) > -1) {
            if (this.mConstructorArgs == null) {
                this.mConstructorArgs = ReflectionUtils.getField(LayoutInflater.class, "mConstructorArgs");
            }
            Object[] mConstructorArgsArr = (Object[])ReflectionUtils.getValue(this.mConstructorArgs, (Object)this);
            Object lastContext = mConstructorArgsArr[0];
            mConstructorArgsArr[0] = viewContext;
            ReflectionUtils.setValue(this.mConstructorArgs, (Object)this, mConstructorArgsArr);
            try {
                view = this.createView(name, null, attrs);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            finally {
                mConstructorArgsArr[0] = lastContext;
                ReflectionUtils.setValue(this.mConstructorArgs, (Object)this, mConstructorArgsArr);
            }
        }
        return view;
    }

    @TargetApi(value=11)
    private static class PrivateWrapperFactory2
    extends WrapperFactory2 {
        private final InternalLayoutInflater mInflater;

        public PrivateWrapperFactory2(LayoutInflater.Factory2 factory2, InternalLayoutInflater inflater, IconicsFactory iconicsFactory) {
            super(factory2, iconicsFactory);
            this.mInflater = inflater;
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return this.mIconicsFactory.onViewCreated(this.mInflater.createCustomViewInternal(parent, this.mFactory2.onCreateView(parent, name, context, attrs), name, context, attrs), context, attrs);
        }
    }

    @TargetApi(value=11)
    private static class WrapperFactory2
    implements LayoutInflater.Factory2 {
        protected final LayoutInflater.Factory2 mFactory2;
        protected final IconicsFactory mIconicsFactory;

        public WrapperFactory2(LayoutInflater.Factory2 factory2, IconicsFactory iconicsFactory) {
            this.mFactory2 = factory2;
            this.mIconicsFactory = iconicsFactory;
        }

        public View onCreateView(String name, Context context, AttributeSet attrs) {
            return this.mIconicsFactory.onViewCreated(this.mFactory2.onCreateView(name, context, attrs), context, attrs);
        }

        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return this.mIconicsFactory.onViewCreated(this.mFactory2.onCreateView(parent, name, context, attrs), context, attrs);
        }
    }

    private static class WrapperFactory
    implements LayoutInflater.Factory {
        private final LayoutInflater.Factory mFactory;
        private final InternalLayoutInflater mInflater;
        private final IconicsFactory mIconicsFactory;

        public WrapperFactory(LayoutInflater.Factory factory, InternalLayoutInflater inflater, IconicsFactory iconicsFactory) {
            this.mFactory = factory;
            this.mInflater = inflater;
            this.mIconicsFactory = iconicsFactory;
        }

        public View onCreateView(String name, Context context, AttributeSet attrs) {
            return this.mIconicsFactory.onViewCreated(this.mFactory.onCreateView(name, context, attrs), context, attrs);
        }
    }
}

