/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextPaint;
import android.view.animation.LinearInterpolator;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Consumer;
import com.mikepenz.iconics.IconicsBrush;
import com.mikepenz.iconics.animation.IconicsAnimatedDrawable;
import com.mikepenz.iconics.animation.IconicsAnimationListener;
import com.mikepenz.iconics.animation.IconicsAnimationPauseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class IconicsAnimationProcessor {
    @NonNull
    private static final TimeInterpolator sDefaultInterpolator = new LinearInterpolator();
    @NonNull
    private final ValueAnimator mAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 100.0f});
    @Nullable
    private IconicsAnimatedDrawable mDrawable;
    private boolean mIsStartRequested = false;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;
    @NonNull
    protected TimeInterpolator mInterpolator = sDefaultInterpolator;
    protected long mDuration = 300L;
    protected int mRepeatCount = -1;
    protected int mRepeatMode = 1;
    protected boolean mIsStartImmediately = true;
    @Nullable
    private List<IconicsAnimationListener> mListeners = null;
    @Nullable
    private List<IconicsAnimationPauseListener> mPauseListeners = null;
    private final Animator.AnimatorListener mProxyListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation, boolean isReverse) {
            this.forEachListeners((Consumer<IconicsAnimationListener>)((Consumer)l -> l.onAnimationStart(IconicsAnimationProcessor.this, isReverse)));
        }

        public void onAnimationEnd(Animator animation, boolean isReverse) {
            this.forEachListeners((Consumer<IconicsAnimationListener>)((Consumer)l -> l.onAnimationEnd(IconicsAnimationProcessor.this, isReverse)));
        }

        public void onAnimationStart(Animator animation) {
            this.forEachListeners((Consumer<IconicsAnimationListener>)((Consumer)l -> l.onAnimationStart(IconicsAnimationProcessor.this)));
        }

        public void onAnimationEnd(Animator animation) {
            this.forEachListeners((Consumer<IconicsAnimationListener>)((Consumer)l -> l.onAnimationEnd(IconicsAnimationProcessor.this)));
        }

        public void onAnimationCancel(Animator animation) {
            this.forEachListeners((Consumer<IconicsAnimationListener>)((Consumer)l -> l.onAnimationCancel(IconicsAnimationProcessor.this)));
        }

        public void onAnimationRepeat(Animator animation) {
            this.forEachListeners((Consumer<IconicsAnimationListener>)((Consumer)l -> l.onAnimationRepeat(IconicsAnimationProcessor.this)));
        }

        private void forEachListeners(Consumer<IconicsAnimationListener> consumer) {
            if (IconicsAnimationProcessor.this.mListeners == null) {
                return;
            }
            for (IconicsAnimationListener l : IconicsAnimationProcessor.this.mListeners) {
                consumer.accept((Object)l);
            }
        }
    };
    @RequiresApi(value=19)
    private final Animator.AnimatorPauseListener mProxyPauseListener = new Animator.AnimatorPauseListener(){

        public void onAnimationPause(Animator animation) {
            this.forEachListeners((Consumer<IconicsAnimationPauseListener>)((Consumer)l -> l.onAnimationPause(IconicsAnimationProcessor.this)));
        }

        public void onAnimationResume(Animator animation) {
            this.forEachListeners((Consumer<IconicsAnimationPauseListener>)((Consumer)l -> l.onAnimationResume(IconicsAnimationProcessor.this)));
        }

        private void forEachListeners(Consumer<IconicsAnimationPauseListener> consumer) {
            if (IconicsAnimationProcessor.this.mPauseListeners == null) {
                return;
            }
            for (IconicsAnimationPauseListener l : IconicsAnimationProcessor.this.mPauseListeners) {
                consumer.accept((Object)l);
            }
        }
    };

    @NonNull
    public abstract String animationTag();

    @NonNull
    public IconicsAnimationProcessor duration(long duration, @NonNull TimeUnit timeUnit) {
        this.mDuration = timeUnit.toMillis(duration);
        return this;
    }

    @NonNull
    public IconicsAnimationProcessor repeatMode(int value) {
        this.mRepeatMode = value;
        return this;
    }

    @NonNull
    public IconicsAnimationProcessor repeatCount(int repeatCount) {
        this.mRepeatCount = repeatCount;
        return this;
    }

    @NonNull
    public IconicsAnimationProcessor interpolator(@NonNull TimeInterpolator interpolator) {
        this.mInterpolator = interpolator != null ? interpolator : sDefaultInterpolator;
        return this;
    }

    @NonNull
    public IconicsAnimationProcessor startImmediately(boolean startImmediately) {
        this.mIsStartImmediately = startImmediately;
        return this;
    }

    @NonNull
    public IconicsAnimationProcessor start() {
        this.mAnimator.setInterpolator(this.mInterpolator);
        this.mAnimator.setDuration(this.mDuration);
        this.mAnimator.setRepeatCount(this.mRepeatCount);
        this.mAnimator.setRepeatMode(this.mRepeatMode);
        if (this.mDrawable != null) {
            this.mIsStartRequested = false;
            this.mAnimator.start();
        } else {
            this.mIsStartRequested = true;
        }
        return this;
    }

    @NonNull
    public IconicsAnimationProcessor addListener(@NonNull IconicsAnimationListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<IconicsAnimationListener>();
            this.mAnimator.addListener(this.mProxyListener);
        }
        this.mListeners.add(listener);
        return this;
    }

    public void removeListener(@NonNull IconicsAnimationListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
            this.mAnimator.removeListener(this.mProxyListener);
        }
    }

    @RequiresApi(value=19)
    @NonNull
    public IconicsAnimationProcessor addPauseListener(@NonNull IconicsAnimationPauseListener listener) {
        if (this.mPauseListeners == null) {
            this.mPauseListeners = new ArrayList<IconicsAnimationPauseListener>();
            this.mAnimator.addPauseListener(this.mProxyPauseListener);
        }
        this.mPauseListeners.add(listener);
        return this;
    }

    @RequiresApi(value=19)
    public void removePauseListener(@NonNull IconicsAnimationPauseListener listener) {
        if (this.mPauseListeners == null) {
            return;
        }
        this.mPauseListeners.remove(listener);
        if (this.mPauseListeners.size() == 0) {
            this.mPauseListeners = null;
            this.mAnimator.removePauseListener(this.mProxyPauseListener);
        }
    }

    public void removeAllListeners() {
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
            this.mAnimator.removeListener(this.mProxyListener);
        }
        if (Build.VERSION.SDK_INT >= 19 && this.mPauseListeners != null) {
            this.mPauseListeners.clear();
            this.mPauseListeners = null;
            this.mAnimator.removePauseListener(this.mProxyPauseListener);
        }
    }

    public void cancel() {
        this.mAnimator.cancel();
    }

    public void end() {
        this.mAnimator.end();
    }

    public boolean isStarted() {
        return this.mAnimator.isStarted();
    }

    public boolean isRunning() {
        return this.mAnimator.isRunning();
    }

    public void reverse() {
        this.mAnimator.reverse();
    }

    @RequiresApi(value=19)
    public void pause() {
        this.mAnimator.pause();
    }

    @RequiresApi(value=19)
    public void resume() {
        this.mAnimator.resume();
    }

    @RequiresApi(value=19)
    public boolean isPaused() {
        return this.mAnimator.isPaused();
    }

    protected void processPreDraw(@NonNull Canvas canvas, @NonNull IconicsBrush<TextPaint> iconBrush, @NonNull IconicsBrush<Paint> iconContourBrush, @NonNull IconicsBrush<Paint> backgroundBrush, @NonNull IconicsBrush<Paint> backgroundContourBrush) {
    }

    protected void processPostDraw(@NonNull Canvas canvas) {
    }

    @Nullable
    protected int[] getDrawableState() {
        return this.mDrawable == null ? null : this.mDrawable.getState();
    }

    @Nullable
    protected Rect getDrawableBounds() {
        return this.mDrawable == null ? null : this.mDrawable.getBounds();
    }

    @FloatRange(from=0.0, to=100.0)
    protected float getAnimatedPercent() {
        return ((Float)this.mAnimator.getAnimatedValue()).floatValue();
    }

    protected void onDrawableAttached() {
    }

    protected void onDrawableDetached() {
    }

    void setDrawable(@Nullable IconicsAnimatedDrawable drawable) {
        this.mDrawable = null;
        this.onDrawableDetached();
        if (drawable != null) {
            this.mDrawable = drawable;
            this.onDrawableAttached();
            if (this.mIsStartImmediately || this.mIsStartRequested) {
                this.start();
            }
        } else {
            this.mAnimator.cancel();
        }
    }
}

