/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.animation;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextPaint;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.mikepenz.iconics.IconicsBrush;
import com.mikepenz.iconics.animation.IconicsAnimationProcessor;

public class BlinkScaleProcessor
extends IconicsAnimationProcessor {
    public static int defaultDuration = 500;
    @FloatRange(from=0.0)
    private float mMinimumScale = 0.0f;
    @FloatRange(from=0.0)
    private float mMaximumScale = 1.0f;

    public BlinkScaleProcessor() {
        this.mRepeatMode = 2;
        this.mDuration = defaultDuration;
    }

    @NonNull
    public BlinkScaleProcessor minimumScale(@FloatRange(from=0.0) float minimumScale) {
        this.mMinimumScale = minimumScale;
        return this;
    }

    @NonNull
    public BlinkScaleProcessor maximumScale(@FloatRange(from=0.0) float maximumScale) {
        this.mMaximumScale = maximumScale;
        return this;
    }

    @FloatRange(from=0.0)
    public float getMinimumScale() {
        return this.mMinimumScale;
    }

    @FloatRange(from=0.0)
    public float getMaximumScale() {
        return this.mMaximumScale;
    }

    @Override
    @NonNull
    public String animationTag() {
        return "blink_scale";
    }

    @Override
    protected void processPreDraw(@NonNull Canvas canvas, @NonNull IconicsBrush<TextPaint> iconBrush, @NonNull IconicsBrush<Paint> iconContourBrush, @NonNull IconicsBrush<Paint> backgroundBrush, @NonNull IconicsBrush<Paint> backgroundContourBrush) {
        float scaleByPercent = (this.mMaximumScale - this.mMinimumScale) / 100.0f;
        float scale = this.getAnimatedPercent() * scaleByPercent;
        Rect bounds = this.getDrawableBounds();
        canvas.save();
        canvas.scale(scale, scale, (float)(bounds.width() / 2), (float)(bounds.height() / 2));
    }

    @Override
    protected void processPostDraw(@NonNull Canvas canvas) {
        canvas.restore();
    }
}

