/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.animation;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.mikepenz.iconics.IconicsBrush;
import com.mikepenz.iconics.animation.IconicsAnimationProcessor;

public class BlinkAlphaProcessor
extends IconicsAnimationProcessor {
    public static int defaultDuration = 500;
    @IntRange(from=0L, to=255L)
    private int mMinimumAlpha = 0;
    @IntRange(from=0L, to=255L)
    private int mMaximumAlpha = 255;

    public BlinkAlphaProcessor() {
        this.mRepeatMode = 2;
        this.mDuration = defaultDuration;
    }

    @NonNull
    public BlinkAlphaProcessor minimumAlpha(@IntRange(from=0L, to=255L) int minimumAlpha) {
        this.mMinimumAlpha = minimumAlpha;
        return this;
    }

    @NonNull
    public BlinkAlphaProcessor maximumAlpha(@IntRange(from=0L, to=255L) int maximumAlpha) {
        this.mMaximumAlpha = maximumAlpha;
        return this;
    }

    @IntRange(from=0L, to=255L)
    public int getMinimumAlpha() {
        return this.mMinimumAlpha;
    }

    @IntRange(from=0L, to=255L)
    public int getMaximumAlpha() {
        return this.mMaximumAlpha;
    }

    @Override
    @NonNull
    public String animationTag() {
        return "blink_alpha";
    }

    @Override
    protected void processPreDraw(@NonNull Canvas canvas, @NonNull IconicsBrush<TextPaint> iconBrush, @NonNull IconicsBrush<Paint> iconContourBrush, @NonNull IconicsBrush<Paint> backgroundBrush, @NonNull IconicsBrush<Paint> backgroundContourBrush) {
        int alphaByPercent = (this.mMaximumAlpha - this.mMinimumAlpha) / 100;
        int alpha = (int)(this.getAnimatedPercent() * (float)alphaByPercent);
        iconBrush.setAlpha(alpha);
        iconContourBrush.setAlpha(alpha);
        backgroundBrush.setAlpha(alpha);
        backgroundContourBrush.setAlpha(alpha);
    }
}

