/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.Log;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.IconicsBrush;
import com.mikepenz.iconics.animation.IconicsAnimatedDrawable;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.utils.Utils;

public class IconicsDrawable
extends Drawable {
    @Dimension(unit=0)
    public static final int TOOLBAR_ICON_SIZE = 24;
    @Dimension(unit=0)
    public static final int TOOLBAR_ICON_PADDING = 1;
    @NonNull
    protected Context mContext;
    private int mSizeX = -1;
    private int mSizeY = -1;
    private boolean mRespectFontBounds = false;
    @NonNull
    protected final IconicsBrush<TextPaint> mIconBrush = new IconicsBrush<TextPaint>(new TextPaint(1));
    @NonNull
    protected final IconicsBrush<Paint> mBackgroundBrush = new IconicsBrush<Paint>(new Paint(1));
    @NonNull
    protected final IconicsBrush<Paint> mContourBrush = new IconicsBrush<Paint>(new Paint(1));
    private boolean mDrawContour;
    @NonNull
    protected final IconicsBrush<Paint> mBackgroundContourBrush = new IconicsBrush<Paint>(new Paint(1));
    private boolean mDrawBackgroundContour;
    private int mRoundedCornerRx = -1;
    private int mRoundedCornerRy = -1;
    @NonNull
    private final Rect mPaddingBounds = new Rect();
    @NonNull
    private final RectF mPathBounds = new RectF();
    @NonNull
    private final Path mPath = new Path();
    private int mIconPadding;
    private int mContourWidth;
    private int mBackgroundContourWidth;
    private int mIconOffsetX = 0;
    private int mIconOffsetY = 0;
    private int mAlpha = 255;
    private float mShadowRadius = 0.0f;
    private float mShadowDx = 0.0f;
    private float mShadowDy = 0.0f;
    private int mShadowColor = 0;
    @Nullable
    private IIcon mIcon;
    @Nullable
    private String mPlainIcon;
    @Nullable
    private ColorStateList mTint;
    @NonNull
    private PorterDuff.Mode mTintMode = PorterDuff.Mode.SRC_IN;
    @Nullable
    private ColorFilter mTintFilter;
    @Nullable
    private ColorFilter mColorFilter;

    public IconicsDrawable(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.mIconBrush.getPaint().setStyle(Paint.Style.FILL);
        this.mIconBrush.getPaint().setTextAlign(Paint.Align.CENTER);
        this.mIconBrush.getPaint().setUnderlineText(false);
        this.mContourBrush.getPaint().setStyle(Paint.Style.STROKE);
        this.mBackgroundContourBrush.getPaint().setStyle(Paint.Style.STROKE);
        this.icon(Character.valueOf(' '));
    }

    public IconicsDrawable(@NonNull Context context, @NonNull Character icon) {
        this(context);
        this.icon(icon);
    }

    public IconicsDrawable(@NonNull Context context, @NonNull String icon) {
        this(context);
        this.icon(icon);
    }

    public IconicsDrawable(@NonNull Context context, @NonNull IIcon icon) {
        this(context);
        this.icon(icon);
    }

    protected IconicsDrawable(@NonNull Context context, @NonNull ITypeface typeface, @NonNull IIcon icon) {
        this(context);
        this.icon(typeface, icon);
    }

    @ColorInt
    public int getColor() {
        return this.mIconBrush.getColorForCurrentState();
    }

    @Nullable
    public ColorStateList getColorList() {
        return this.mIconBrush.getColorsList();
    }

    @ColorInt
    public int getContourColor() {
        return this.mContourBrush.getColorForCurrentState();
    }

    @Nullable
    public ColorStateList getContourColorList() {
        return this.mContourBrush.getColorsList();
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.mBackgroundBrush.getColorForCurrentState();
    }

    @Nullable
    public ColorStateList getBackgroundColorList() {
        return this.mBackgroundBrush.getColorsList();
    }

    @ColorInt
    public int getBackgroundContourColor() {
        return this.mBackgroundContourBrush.getColorForCurrentState();
    }

    @Nullable
    public ColorStateList getBackgroundContourColorList() {
        return this.mBackgroundContourBrush.getColorsList();
    }

    @Nullable
    public IIcon getIcon() {
        return this.mIcon;
    }

    @Nullable
    public String getPlainIcon() {
        return this.mPlainIcon;
    }

    @IntRange(from=0L, to=255L)
    public int getCompatAlpha() {
        return this.mAlpha;
    }

    @NonNull
    public Bitmap toBitmap() {
        if (this.mSizeX == -1 || this.mSizeY == -1) {
            this.actionBar();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.getIntrinsicWidth(), (int)this.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.style(Paint.Style.FILL);
        Canvas canvas = new Canvas(bitmap);
        this.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        this.draw(canvas);
        return bitmap;
    }

    @NonNull
    public IconicsDrawable clone() {
        return this.copyTo(new IconicsDrawable(this.mContext));
    }

    @NonNull
    public IconicsAnimatedDrawable toAnimatedDrawable() {
        return this.copyTo(new IconicsAnimatedDrawable(this.mContext));
    }

    private <T extends IconicsDrawable> T copyTo(T drawable) {
        drawable.color(this.mIconBrush.getColorsList()).sizePxX(this.mSizeX).sizePxY(this.mSizeY).iconOffsetXPx(this.mIconOffsetX).iconOffsetYPx(this.mIconOffsetY).paddingPx(this.mIconPadding).typeface(this.mIconBrush.getPaint().getTypeface()).backgroundColor(this.mBackgroundBrush.getColorsList()).roundedCornersRxPx(this.mRoundedCornerRx).roundedCornersRyPx(this.mRoundedCornerRy).drawContour(this.mDrawContour).contourColor(this.mContourBrush.getColorsList()).contourWidthPx(this.mContourWidth).drawBackgroundContour(this.mDrawBackgroundContour).backgroundContourColor(this.mBackgroundContourBrush.getColorsList()).backgroundContourWidthPx(this.mBackgroundContourWidth).shadowPx(this.mShadowRadius, this.mShadowDx, this.mShadowDy, this.mShadowColor).alpha(this.mAlpha);
        if (this.mIcon != null) {
            drawable.icon(this.mIcon);
        } else if (this.mPlainIcon != null) {
            drawable.iconText(this.mPlainIcon);
        }
        return drawable;
    }

    @NonNull
    public IconicsDrawable icon(@NonNull String icon) {
        try {
            ITypeface font = Iconics.findFont(this.mContext, icon.substring(0, 3));
            icon = icon.replace("-", "_");
            this.icon(font.getIcon(icon));
        }
        catch (Exception ex) {
            Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + icon));
        }
        return this;
    }

    @NonNull
    public IconicsDrawable icon(@NonNull Character icon) {
        return this.iconText(icon.toString(), null);
    }

    @NonNull
    public IconicsDrawable icon(@NonNull Character icon, @Nullable Typeface typeface) {
        return this.iconText(icon.toString(), typeface);
    }

    @NonNull
    public IconicsDrawable iconText(@NonNull String icon) {
        return this.iconText(icon, null);
    }

    @NonNull
    public IconicsDrawable iconText(@NonNull String icon, @Nullable Typeface typeface) {
        this.mPlainIcon = icon;
        this.mIcon = null;
        this.mIconBrush.getPaint().setTypeface(typeface == null ? Typeface.DEFAULT : typeface);
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable icon(@NonNull IIcon icon) {
        this.mIcon = icon;
        this.mPlainIcon = null;
        ITypeface typeface = icon.getTypeface();
        this.mIconBrush.getPaint().setTypeface(typeface.getTypeface(this.mContext));
        this.invalidateSelf();
        return this;
    }

    @NonNull
    protected IconicsDrawable icon(@NonNull ITypeface typeface, @NonNull IIcon icon) {
        this.mIcon = icon;
        this.mIconBrush.getPaint().setTypeface(typeface.getTypeface(this.mContext));
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable respectFontBounds(boolean respectBounds) {
        this.mRespectFontBounds = respectBounds;
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable color(@ColorInt int color) {
        return this.color(ColorStateList.valueOf((int)color));
    }

    @NonNull
    public IconicsDrawable colorRes(@ColorRes int colorResId) {
        return this.color(ContextCompat.getColor((Context)this.mContext, (int)colorResId));
    }

    @NonNull
    public IconicsDrawable colorListRes(@ColorRes int colorResId) {
        return this.color(ContextCompat.getColorStateList((Context)this.mContext, (int)colorResId));
    }

    @NonNull
    public IconicsDrawable color(@NonNull ColorStateList colors) {
        if (colors != null) {
            this.mIconBrush.setColors(colors);
            if (this.mIconBrush.applyState(this.getState())) {
                this.invalidateSelf();
            }
        }
        return this;
    }

    @NonNull
    public IconicsDrawable iconOffsetXRes(@DimenRes int sizeResId) {
        return this.iconOffsetXPx(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable iconOffsetXDp(@Dimension(unit=0) int sizeDp) {
        return this.iconOffsetXPx(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable iconOffsetXPx(@Dimension(unit=1) int sizePx) {
        this.mIconOffsetX = sizePx;
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable iconOffsetYRes(@DimenRes int sizeResId) {
        return this.iconOffsetYPx(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable iconOffsetYDp(@Dimension(unit=0) int sizeDp) {
        return this.iconOffsetYPx(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable iconOffsetYPx(@Dimension(unit=1) int sizePx) {
        this.mIconOffsetY = sizePx;
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable paddingRes(@DimenRes int sizeResId) {
        return this.paddingPx(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable paddingDp(@Dimension(unit=0) int sizeDp) {
        return this.paddingPx(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable paddingPx(@Dimension(unit=1) int sizePx) {
        if (this.mIconPadding != sizePx) {
            this.mIconPadding = sizePx;
            if (this.mDrawContour) {
                this.mIconPadding += this.mContourWidth;
            }
            if (this.mDrawBackgroundContour) {
                this.mIconPadding += this.mBackgroundContourWidth;
            }
            this.invalidateSelf();
        }
        return this;
    }

    @NonNull
    public IconicsDrawable actionBar() {
        return this.sizeDp(24).paddingDp(1);
    }

    @NonNull
    public IconicsDrawable sizeRes(@DimenRes int sizeResId) {
        return this.sizePx(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable sizeDp(@Dimension(unit=0) int sizeDp) {
        return this.sizePx(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable sizePx(@Dimension(unit=1) int sizePx) {
        this.mSizeX = this.mSizeY = sizePx;
        this.setBounds(0, 0, this.mSizeX, this.mSizeY);
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable sizeResX(@DimenRes int sizeResId) {
        return this.sizePxX(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable sizeDpX(@Dimension(unit=0) int sizeDp) {
        return this.sizePxX(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable sizePxX(@Dimension(unit=1) int sizePx) {
        this.mSizeX = sizePx;
        this.setBounds(0, 0, this.mSizeX, this.mSizeY);
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable sizeResY(@DimenRes int sizeResId) {
        return this.sizePxY(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable sizeDpY(@Dimension(unit=0) int sizeDp) {
        return this.sizePxY(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable sizePxY(@Dimension(unit=1) int sizePx) {
        this.mSizeY = sizePx;
        this.setBounds(0, 0, this.mSizeX, this.mSizeY);
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable backgroundContourColorRes(@ColorRes int colorResId) {
        return this.backgroundContourColor(ContextCompat.getColor((Context)this.mContext, (int)colorResId));
    }

    @NonNull
    public IconicsDrawable backgroundContourColor(@ColorInt int color) {
        return this.backgroundContourColor(ColorStateList.valueOf((int)color));
    }

    @NonNull
    public IconicsDrawable backgroundContourColorListRes(@ColorRes int colorResId) {
        return this.backgroundContourColor(ContextCompat.getColorStateList((Context)this.mContext, (int)colorResId));
    }

    @NonNull
    public IconicsDrawable backgroundContourColor(@NonNull ColorStateList colors) {
        if (colors != null) {
            this.mBackgroundContourBrush.setColors(colors);
            if (this.mBackgroundContourBrush.applyState(this.getState())) {
                this.invalidateSelf();
            }
        }
        return this;
    }

    @NonNull
    public IconicsDrawable contourColorRes(@ColorRes int colorResId) {
        return this.contourColor(ContextCompat.getColor((Context)this.mContext, (int)colorResId));
    }

    @NonNull
    public IconicsDrawable contourColor(@ColorInt int color) {
        return this.contourColor(ColorStateList.valueOf((int)color));
    }

    @NonNull
    public IconicsDrawable contourColorListRes(@ColorRes int colorResId) {
        return this.contourColor(ContextCompat.getColorStateList((Context)this.mContext, (int)colorResId));
    }

    @NonNull
    public IconicsDrawable contourColor(@NonNull ColorStateList colors) {
        if (colors != null) {
            this.mContourBrush.setColors(colors);
            if (this.mContourBrush.applyState(this.getState())) {
                this.invalidateSelf();
            }
        }
        return this;
    }

    @NonNull
    public IconicsDrawable backgroundColorRes(@ColorRes int colorResId) {
        return this.backgroundColor(ContextCompat.getColor((Context)this.mContext, (int)colorResId));
    }

    @NonNull
    public IconicsDrawable backgroundColor(@ColorInt int color) {
        return this.backgroundColor(ColorStateList.valueOf((int)color));
    }

    @NonNull
    public IconicsDrawable backgroundColorListRes(@ColorRes int colorResId) {
        return this.backgroundColor(ContextCompat.getColorStateList((Context)this.mContext, (int)colorResId));
    }

    @NonNull
    public IconicsDrawable backgroundColor(@NonNull ColorStateList colors) {
        if (colors != null) {
            boolean isInvalidate = false;
            if (this.mRoundedCornerRx == -1) {
                this.mRoundedCornerRx = 0;
                isInvalidate = true;
            }
            if (this.mRoundedCornerRy == -1) {
                this.mRoundedCornerRy = 0;
                isInvalidate = true;
            }
            this.mBackgroundBrush.setColors(colors);
            if (this.mBackgroundBrush.applyState(this.getState())) {
                isInvalidate = true;
            }
            if (isInvalidate) {
                this.invalidateSelf();
            }
        }
        return this;
    }

    @NonNull
    public IconicsDrawable roundedCornersRxRes(@DimenRes int sizeResId) {
        return this.roundedCornersRxPx(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable roundedCornersRxDp(@Dimension(unit=0) int sizeDp) {
        return this.roundedCornersRxPx(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable roundedCornersRxPx(@Dimension(unit=1) int sizePx) {
        this.mRoundedCornerRx = sizePx;
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable roundedCornersRyRes(@DimenRes int sizeResId) {
        return this.roundedCornersRyPx(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable roundedCornersRyDp(@Dimension(unit=0) int sizeDp) {
        return this.roundedCornersRyPx(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable roundedCornersRyPx(@Dimension(unit=1) int sizePx) {
        this.mRoundedCornerRy = sizePx;
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable roundedCornersRes(@DimenRes int sizeResId) {
        return this.roundedCornersPx(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable roundedCornersDp(@Dimension(unit=0) int sizeDp) {
        return this.roundedCornersPx(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable roundedCornersPx(@Dimension(unit=1) int sizePx) {
        this.mRoundedCornerRx = this.mRoundedCornerRy = sizePx;
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable contourWidthRes(@DimenRes int sizeResId) {
        return this.contourWidthPx(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable contourWidthDp(@Dimension(unit=0) int sizeDp) {
        return this.contourWidthPx(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable contourWidthPx(@Dimension(unit=1) int sizePx) {
        this.mContourWidth = sizePx;
        this.mContourBrush.getPaint().setStrokeWidth((float)sizePx);
        this.drawContour(true);
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable enableShadowSupport(@NonNull View view) {
        view.setLayerType(1, null);
        return this;
    }

    @NonNull
    public IconicsDrawable shadowRes(@DimenRes int radiusRes, @DimenRes int dxRes, @DimenRes int dyRes, @ColorRes int colorResId) {
        return this.shadowPx(this.mContext.getResources().getDimensionPixelSize(radiusRes), this.mContext.getResources().getDimensionPixelSize(dxRes), this.mContext.getResources().getDimensionPixelSize(dyRes), ContextCompat.getColor((Context)this.mContext, (int)colorResId));
    }

    @NonNull
    public IconicsDrawable shadowDp(@Dimension(unit=0) float radiusDp, @Dimension(unit=0) float dxDp, @Dimension(unit=0) float dyDp, @ColorInt int color) {
        return this.shadowPx(Utils.convertDpToPx(this.mContext, radiusDp), Utils.convertDpToPx(this.mContext, dxDp), Utils.convertDpToPx(this.mContext, dyDp), color);
    }

    @NonNull
    public IconicsDrawable shadowPx(@Dimension(unit=1) float radius, @Dimension(unit=1) float dx, @Dimension(unit=1) float dy, @ColorInt int color) {
        this.mShadowRadius = radius;
        this.mShadowDx = dx;
        this.mShadowDy = dy;
        this.mShadowColor = color;
        this.mIconBrush.getPaint().setShadowLayer(radius, dx, dy, color);
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable clearShadow() {
        this.mIconBrush.getPaint().clearShadowLayer();
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable backgroundContourWidthRes(@DimenRes int sizeResId) {
        return this.backgroundContourWidthPx(this.mContext.getResources().getDimensionPixelSize(sizeResId));
    }

    @NonNull
    public IconicsDrawable backgroundContourWidthDp(@Dimension(unit=0) int sizeDp) {
        return this.backgroundContourWidthPx(Utils.convertDpToPx(this.mContext, sizeDp));
    }

    @NonNull
    public IconicsDrawable backgroundContourWidthPx(@Dimension(unit=1) int sizePx) {
        this.mBackgroundContourWidth = sizePx;
        this.mBackgroundContourBrush.getPaint().setStrokeWidth((float)sizePx);
        this.drawBackgroundContour(true);
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable drawContour(boolean drawContour) {
        if (this.mDrawContour != drawContour) {
            this.mDrawContour = drawContour;
            this.mIconPadding += (this.mDrawContour ? 1 : -1) * this.mContourWidth;
            this.invalidateSelf();
        }
        return this;
    }

    @NonNull
    public IconicsDrawable drawBackgroundContour(boolean drawBackgroundContour) {
        if (this.mDrawBackgroundContour != drawBackgroundContour) {
            this.mDrawBackgroundContour = drawBackgroundContour;
            this.mIconPadding += (this.mDrawBackgroundContour ? 1 : -1) * this.mBackgroundContourWidth * 2;
            this.invalidateSelf();
        }
        return this;
    }

    @NonNull
    public IconicsDrawable colorFilter(@Nullable ColorFilter cf) {
        this.setColorFilter(cf);
        return this;
    }

    @NonNull
    public IconicsDrawable alpha(@IntRange(from=0L, to=255L) int alpha) {
        this.setAlpha(alpha);
        return this;
    }

    @NonNull
    public IconicsDrawable style(@NonNull Paint.Style style) {
        this.mIconBrush.getPaint().setStyle(style);
        this.invalidateSelf();
        return this;
    }

    @NonNull
    public IconicsDrawable typeface(@Nullable Typeface typeface) {
        this.mIconBrush.getPaint().setTypeface(typeface);
        this.invalidateSelf();
        return this;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.mIcon == null && this.mPlainIcon == null) {
            return;
        }
        Rect viewBounds = this.getBounds();
        this.updatePaddingBounds(viewBounds);
        this.updateTextSize(viewBounds);
        this.offsetIcon(viewBounds);
        if (this.mRoundedCornerRy > -1 && this.mRoundedCornerRx > -1) {
            if (this.mDrawBackgroundContour) {
                float halfContourSize = this.mBackgroundContourWidth / 2;
                RectF rectF = new RectF(halfContourSize, halfContourSize, (float)viewBounds.width() - halfContourSize, (float)viewBounds.height() - halfContourSize);
                canvas.drawRoundRect(rectF, (float)this.mRoundedCornerRx, (float)this.mRoundedCornerRy, this.mBackgroundBrush.getPaint());
                canvas.drawRoundRect(rectF, (float)this.mRoundedCornerRx, (float)this.mRoundedCornerRy, this.mBackgroundContourBrush.getPaint());
            } else {
                RectF rectF = new RectF(0.0f, 0.0f, (float)viewBounds.width(), (float)viewBounds.height());
                canvas.drawRoundRect(rectF, (float)this.mRoundedCornerRx, (float)this.mRoundedCornerRy, this.mBackgroundBrush.getPaint());
            }
        }
        try {
            this.mPath.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mDrawContour) {
            canvas.drawPath(this.mPath, this.mContourBrush.getPaint());
        }
        this.mIconBrush.getPaint().setColorFilter(this.mColorFilter == null ? this.mTintFilter : this.mColorFilter);
        canvas.drawPath(this.mPath, (Paint)this.mIconBrush.getPaint());
    }

    public void setTintList(@Nullable ColorStateList tint) {
        this.mTint = tint;
        this.mTintFilter = this.updateTintFilter(tint, this.mTintMode);
        this.invalidateSelf();
    }

    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTint, tintMode);
        this.invalidateSelf();
    }

    protected void onBoundsChange(@NonNull Rect bounds) {
        this.offsetIcon(bounds);
        try {
            this.mPath.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onBoundsChange(bounds);
    }

    public boolean isStateful() {
        return this.mIconBrush.isStateful() || this.mContourBrush.isStateful() || this.mBackgroundBrush.isStateful() || this.mBackgroundContourBrush.isStateful();
    }

    public boolean setState(@NonNull int[] stateSet) {
        boolean b = super.setState(stateSet);
        return b || this.mIconBrush.isStateful() || this.mContourBrush.isStateful() || this.mBackgroundBrush.isStateful() || this.mBackgroundContourBrush.isStateful() || this.mColorFilter != null || this.mTintFilter != null;
    }

    public int getOpacity() {
        if (this.mTintFilter != null || this.mIconBrush.getPaint().getColorFilter() != null) {
            return -3;
        }
        switch (this.getAlpha()) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }

    protected boolean onStateChange(@NonNull int[] stateSet) {
        boolean isNeedsRedraw = this.mIconBrush.applyState(stateSet);
        isNeedsRedraw |= this.mContourBrush.applyState(stateSet);
        isNeedsRedraw |= this.mBackgroundBrush.applyState(stateSet);
        isNeedsRedraw |= this.mBackgroundContourBrush.applyState(stateSet);
        if (this.mTint != null && this.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTint, this.mTintMode);
            isNeedsRedraw = true;
        }
        return isNeedsRedraw;
    }

    public int getIntrinsicWidth() {
        return this.mSizeX;
    }

    public int getIntrinsicHeight() {
        return this.mSizeY;
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mIconBrush.setAlpha(alpha);
        this.mContourBrush.setAlpha(alpha);
        this.mBackgroundBrush.setAlpha(alpha);
        this.mBackgroundContourBrush.setAlpha(alpha);
        this.mAlpha = alpha;
        this.invalidateSelf();
    }

    @IntRange(from=0L, to=255L)
    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(@Nullable ColorFilter cf) {
        this.mColorFilter = cf;
        this.invalidateSelf();
    }

    public void clearColorFilter() {
        this.mColorFilter = null;
        this.invalidateSelf();
    }

    private void updatePaddingBounds(@NonNull Rect viewBounds) {
        if (this.mIconPadding >= 0 && this.mIconPadding * 2 <= viewBounds.width() && this.mIconPadding * 2 <= viewBounds.height()) {
            this.mPaddingBounds.set(viewBounds.left + this.mIconPadding, viewBounds.top + this.mIconPadding, viewBounds.right - this.mIconPadding, viewBounds.bottom - this.mIconPadding);
        }
    }

    private void updateTextSize(@NonNull Rect viewBounds) {
        float textSize = (float)viewBounds.height() * (float)(this.mRespectFontBounds ? 1 : 2);
        this.mIconBrush.getPaint().setTextSize(textSize);
        String textValue = this.mIcon != null ? String.valueOf(this.mIcon.getCharacter()) : String.valueOf(this.mPlainIcon);
        this.mIconBrush.getPaint().getTextPath(textValue, 0, textValue.length(), 0.0f, (float)viewBounds.height(), this.mPath);
        this.mPath.computeBounds(this.mPathBounds, true);
        if (!this.mRespectFontBounds) {
            float deltaHeight;
            float deltaWidth = (float)this.mPaddingBounds.width() / this.mPathBounds.width();
            float delta = deltaWidth < (deltaHeight = (float)this.mPaddingBounds.height() / this.mPathBounds.height()) ? deltaWidth : deltaHeight;
            this.mIconBrush.getPaint().setTextSize(textSize *= delta);
            this.mIconBrush.getPaint().getTextPath(textValue, 0, textValue.length(), 0.0f, (float)viewBounds.height(), this.mPath);
            this.mPath.computeBounds(this.mPathBounds, true);
        }
    }

    private void offsetIcon(@NonNull Rect viewBounds) {
        float startX = (float)viewBounds.centerX() - this.mPathBounds.width() / 2.0f;
        float offsetX = startX - this.mPathBounds.left;
        float startY = (float)viewBounds.centerY() - this.mPathBounds.height() / 2.0f;
        float offsetY = startY - this.mPathBounds.top;
        this.mPath.offset(offsetX + (float)this.mIconOffsetX, offsetY + (float)this.mIconOffsetY);
    }

    private PorterDuffColorFilter updateTintFilter(@Nullable ColorStateList tint, @Nullable PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color = tint.getColorForState(this.getState(), 0);
        return new PorterDuffColorFilter(color, tintMode);
    }
}

