/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.Paint;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class IconicsBrush<T extends Paint> {
    @Nullable
    private ColorStateList mColors;
    @NonNull
    private final T mPaint;
    @Nullable
    private int[] mState;
    private int mAlpha;

    public IconicsBrush(@NonNull T paint) {
        this.mPaint = paint;
    }

    public void setColors(@Nullable ColorStateList colors) {
        this.mColors = colors;
        this.applyState(this.mState);
    }

    @Nullable
    public ColorStateList getColorsList() {
        return this.mColors;
    }

    @NonNull
    public T getPaint() {
        return this.mPaint;
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mAlpha = alpha;
        this.mPaint.setAlpha(alpha);
    }

    @IntRange(from=0L, to=255L)
    public int getAlpha() {
        return this.mAlpha;
    }

    boolean isStateful() {
        return this.mColors != null && this.mColors.isStateful();
    }

    int getColorForCurrentState(int defaultColor) {
        if (this.mColors != null) {
            return this.mColors.getColorForState(this.mState, defaultColor);
        }
        return defaultColor;
    }

    int getColorForCurrentState() {
        if (this.mColors != null) {
            return this.getColorForCurrentState(this.mColors.getDefaultColor());
        }
        return 0;
    }

    boolean applyState(@NonNull int[] state) {
        int alpha;
        int blue;
        int green;
        this.mState = state;
        boolean isInvalidate = false;
        int colorForState = this.getColorForCurrentState();
        int red = Color.red((int)colorForState);
        int colorRgb = Color.rgb((int)red, (int)(green = Color.green((int)colorForState)), (int)(blue = Color.blue((int)colorForState)));
        if (colorRgb != this.mPaint.getColor()) {
            this.mPaint.setColor(colorRgb);
            isInvalidate = true;
        }
        if ((alpha = Color.alpha((int)colorForState)) != 255 && alpha != this.mAlpha) {
            this.setAlpha(alpha);
            isInvalidate = true;
        }
        return isInvalidate;
    }
}

