/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics;

import android.content.Context;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.CharacterStyle;
import android.util.Log;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mikepenz.iconics.animation.IconicsAnimationProcessor;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.utils.GenericsUtil;
import com.mikepenz.iconics.utils.IconicsUtils;
import com.mikepenz.iconics.utils.StyleContainer;
import com.mikepenz.iconics.utils.TextStyleContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class Iconics {
    @NonNull
    public static final String TAG = Iconics.class.getSimpleName();
    private static boolean INIT_DONE = false;
    @NonNull
    private static final HashMap<String, ITypeface> FONTS = new HashMap();
    @NonNull
    private static final HashMap<String, Class<? extends IconicsAnimationProcessor>> PROCESSORS = new HashMap();

    public static void init(@NonNull Context ctx) {
        if (!INIT_DONE) {
            String[] processors;
            String[] fonts;
            for (String fontsClassPath : fonts = GenericsUtil.getDefinedFonts(ctx)) {
                try {
                    ITypeface typeface = (ITypeface)Class.forName(fontsClassPath).newInstance();
                    Iconics.validateFont(typeface);
                    FONTS.put(typeface.getMappingPrefix(), typeface);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Can't init: " + fontsClassPath));
                }
            }
            for (String processorClassPath : processors = GenericsUtil.getDefinedProcessors(ctx)) {
                try {
                    IconicsAnimationProcessor processor = (IconicsAnimationProcessor)Class.forName(processorClassPath).newInstance();
                    Iconics.registerProcessor(processor);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Can't init: " + processorClassPath));
                }
            }
            INIT_DONE = true;
        }
    }

    private static HashMap<String, ITypeface> init(@NonNull Context ctx, @NonNull HashMap<String, ITypeface> fonts) {
        Iconics.init(ctx);
        if (fonts == null || fonts.size() == 0) {
            fonts = FONTS;
        }
        return fonts;
    }

    public static void markInitDone() {
        if (FONTS.size() == 0) {
            throw new IllegalArgumentException("At least one font needs to be registered first via `registerFont`.");
        }
        INIT_DONE = true;
    }

    public static boolean iconExists(@NonNull Context context, @NonNull String icon) {
        try {
            ITypeface font = Iconics.findFont(context, icon.substring(0, 3));
            icon = icon.replace("-", "_");
            font.getIcon(icon);
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static boolean registerFont(@NonNull ITypeface font) {
        Iconics.validateFont(font);
        FONTS.put(font.getMappingPrefix(), font);
        return true;
    }

    public static void registerProcessor(@NonNull IconicsAnimationProcessor processor) {
        PROCESSORS.put(processor.animationTag(), processor.getClass());
    }

    @Nullable
    public static IconicsAnimationProcessor findProcessor(@NonNull Context ctx, @NonNull String animationTag) {
        Iconics.init(ctx);
        Class<? extends IconicsAnimationProcessor> processorClass = PROCESSORS.get(animationTag);
        if (processorClass != null) {
            try {
                return processorClass.newInstance();
            }
            catch (IllegalAccessException e) {
                Log.d((String)TAG, (String)("Can't create processor for animation tag " + animationTag), (Throwable)e);
            }
            catch (InstantiationException e) {
                Log.d((String)TAG, (String)("Can't create processor for animation tag " + animationTag), (Throwable)e);
            }
        }
        return null;
    }

    private static void validateFont(@NonNull ITypeface font) {
        if (font.getMappingPrefix().length() != 3) {
            throw new IllegalArgumentException("The mapping prefix of a font must be three characters long.");
        }
    }

    @NonNull
    public static Collection<ITypeface> getRegisteredFonts(@NonNull Context ctx) {
        Iconics.init(ctx);
        return FONTS.values();
    }

    @Nullable
    public static ITypeface findFont(@NonNull Context ctx, @NonNull String key) {
        Iconics.init(ctx);
        return FONTS.get(key);
    }

    @NonNull
    public static ITypeface findFont(@NonNull IIcon icon) {
        return icon.getTypeface();
    }

    private Iconics() {
    }

    @NonNull
    public static Spanned style(@NonNull Context ctx, @NonNull Spanned textSpanned) {
        return Iconics.style(ctx, null, textSpanned, null, null);
    }

    @NonNull
    public static Spanned style(@NonNull Context ctx, @Nullable HashMap<String, ITypeface> fonts, @NonNull Spanned textSpanned, @Nullable List<CharacterStyle> styles, @Nullable HashMap<String, List<CharacterStyle>> stylesFor) {
        fonts = Iconics.init(ctx, fonts);
        TextStyleContainer textStyleContainer = IconicsUtils.findIcons(textSpanned, fonts);
        SpannableString sb = SpannableString.valueOf((CharSequence)textStyleContainer.spannableStringBuilder);
        IconicsUtils.applyStyles(ctx, (Spannable)sb, textStyleContainer.styleContainers, styles, stylesFor);
        return sb;
    }

    public static void styleEditable(@NonNull Context ctx, @NonNull Editable editable) {
        Iconics.styleEditable(ctx, null, editable, null, null);
    }

    public static void styleEditable(@NonNull Context ctx, @Nullable HashMap<String, ITypeface> fonts, @NonNull Editable textSpanned, @Nullable List<CharacterStyle> styles, @Nullable HashMap<String, List<CharacterStyle>> stylesFor) {
        fonts = Iconics.init(ctx, fonts);
        LinkedList<StyleContainer> styleContainers = IconicsUtils.findIconsFromEditable(textSpanned, fonts);
        IconicsUtils.applyStyles(ctx, (Spannable)textSpanned, styleContainers, styles, stylesFor);
    }

    public static class IconicsBuilder {
        @NonNull
        private final List<CharacterStyle> styles = new LinkedList<CharacterStyle>();
        @NonNull
        private final HashMap<String, List<CharacterStyle>> stylesFor = new HashMap();
        @NonNull
        private final List<ITypeface> fonts = new LinkedList<ITypeface>();
        @NonNull
        private Context ctx;

        @NonNull
        public IconicsBuilder ctx(@NonNull Context ctx) {
            this.ctx = ctx;
            return this;
        }

        @NonNull
        public IconicsBuilder style(CharacterStyle ... styles) {
            if (styles != null && styles.length > 0) {
                Collections.addAll(this.styles, styles);
            }
            return this;
        }

        @NonNull
        public IconicsBuilder styleFor(@NonNull IIcon styleFor, CharacterStyle ... styles) {
            return this.styleFor(styleFor.getName(), styles);
        }

        @NonNull
        public IconicsBuilder styleFor(@NonNull String styleFor, CharacterStyle ... styles) {
            if (!this.stylesFor.containsKey(styleFor = styleFor.replace("-", "_"))) {
                this.stylesFor.put(styleFor, new LinkedList());
            }
            if (styles != null && styles.length > 0) {
                for (CharacterStyle style : styles) {
                    this.stylesFor.get(styleFor).add(style);
                }
            }
            return this;
        }

        @NonNull
        public IconicsBuilder font(@NonNull ITypeface font) {
            this.fonts.add(font);
            return this;
        }

        @NonNull
        public IconicsBuilderString on(@NonNull Spanned on) {
            return new IconicsBuilderString(this.ctx, this.fonts, on, this.styles, this.stylesFor);
        }

        @NonNull
        public IconicsBuilderString on(@NonNull String on) {
            return this.on((Spanned)new SpannableString((CharSequence)on));
        }

        @NonNull
        public IconicsBuilderString on(@NonNull CharSequence on) {
            return this.on(on.toString());
        }

        @NonNull
        public IconicsBuilderString on(@NonNull StringBuilder on) {
            return this.on(on.toString());
        }

        @NonNull
        public IconicsBuilderView on(@NonNull TextView on) {
            return new IconicsBuilderView(this.ctx, this.fonts, on, this.styles, this.stylesFor);
        }

        @NonNull
        public IconicsBuilderView on(@NonNull Button on) {
            return new IconicsBuilderView(this.ctx, this.fonts, (TextView)on, this.styles, this.stylesFor);
        }
    }

    public static class IconicsBuilderView {
        @NonNull
        private Context ctx;
        @NonNull
        private TextView view;
        @NonNull
        private List<CharacterStyle> withStyles;
        @NonNull
        private HashMap<String, List<CharacterStyle>> withStylesFor;
        @NonNull
        private List<ITypeface> fonts;

        public IconicsBuilderView(@NonNull Context ctx, @NonNull List<ITypeface> fonts, @NonNull TextView view, @NonNull List<CharacterStyle> styles, @NonNull HashMap<String, List<CharacterStyle>> stylesFor) {
            this.ctx = ctx;
            this.fonts = fonts;
            this.view = view;
            this.withStyles = styles;
            this.withStylesFor = stylesFor;
        }

        public void build() {
            HashMap<String, ITypeface> mappedFonts = new HashMap<String, ITypeface>();
            for (ITypeface font : this.fonts) {
                mappedFonts.put(font.getMappingPrefix(), font);
            }
            if (this.view.getText() instanceof Spanned) {
                this.view.setText((CharSequence)Iconics.style(this.ctx, mappedFonts, (Spanned)this.view.getText(), this.withStyles, this.withStylesFor));
            } else {
                this.view.setText((CharSequence)Iconics.style(this.ctx, mappedFonts, (Spanned)new SpannableString(this.view.getText()), this.withStyles, this.withStylesFor));
            }
            if (this.view instanceof Button) {
                this.view.setAllCaps(false);
            }
        }
    }

    public static class IconicsBuilderString {
        @NonNull
        private Context ctx;
        @NonNull
        private Spanned text;
        @NonNull
        private List<CharacterStyle> withStyles;
        @NonNull
        private HashMap<String, List<CharacterStyle>> withStylesFor;
        @NonNull
        private List<ITypeface> fonts;

        public IconicsBuilderString(@NonNull Context ctx, @NonNull List<ITypeface> fonts, @NonNull Spanned text, @NonNull List<CharacterStyle> styles, @NonNull HashMap<String, List<CharacterStyle>> stylesFor) {
            this.ctx = ctx;
            this.fonts = fonts;
            this.text = text;
            this.withStyles = styles;
            this.withStylesFor = stylesFor;
        }

        @NonNull
        public Spanned build() {
            HashMap<String, ITypeface> mappedFonts = new HashMap<String, ITypeface>();
            for (ITypeface font : this.fonts) {
                mappedFonts.put(font.getMappingPrefix(), font);
            }
            return Iconics.style(this.ctx, mappedFonts, this.text, this.withStyles, this.withStylesFor);
        }
    }
}

