/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.core.R;
import com.mikepenz.iconics.typeface.IIcon;

public class IconicsImageView
extends ImageView {
    private IconicsDrawable mIcon = null;
    private int mColor = 0;
    private int mSize = -1;
    private int mPadding = -1;
    private int mContourColor = 0;
    private int mContourWidth = -1;
    private int mBackgroundColor = 0;
    private int mCornerRadius = -1;

    public IconicsImageView(Context context) {
        this(context, null);
    }

    public IconicsImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IconicsImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IconicsImageView, defStyle, 0);
            String icon = a.getString(R.styleable.IconicsImageView_iiv_icon);
            this.mColor = a.getColor(R.styleable.IconicsImageView_iiv_color, 0);
            this.mSize = a.getDimensionPixelSize(R.styleable.IconicsImageView_iiv_size, -1);
            this.mPadding = a.getDimensionPixelSize(R.styleable.IconicsImageView_iiv_padding, -1);
            this.mContourColor = a.getColor(R.styleable.IconicsImageView_iiv_contour_color, 0);
            this.mContourWidth = a.getDimensionPixelSize(R.styleable.IconicsImageView_iiv_contour_width, -1);
            this.mBackgroundColor = a.getColor(R.styleable.IconicsImageView_iiv_background_color, 0);
            this.mCornerRadius = a.getDimensionPixelSize(R.styleable.IconicsImageView_iiv_corner_radius, -1);
            a.recycle();
            this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            if (icon == null) {
                return;
            }
            this.mIcon = new IconicsDrawable(context, icon);
            this.setAttributes();
            this.setImageDrawable(this.mIcon);
        }
    }

    public void setIcon(Character icon) {
        this.setIcon(icon, true);
    }

    public void setIcon(Character icon, boolean resetAttributes) {
        this.setIcon(new IconicsDrawable(this.getContext(), icon), resetAttributes);
    }

    public void setIcon(String icon) {
        this.setIcon(icon, true);
    }

    public void setIcon(String icon, boolean resetAttributes) {
        this.setIcon(new IconicsDrawable(this.getContext(), icon), resetAttributes);
    }

    public void setIcon(IIcon icon) {
        this.setIcon(icon, true);
    }

    public void setIcon(IIcon icon, boolean resetAttributes) {
        this.setIcon(new IconicsDrawable(this.getContext(), icon), resetAttributes);
    }

    public void setIcon(IconicsDrawable icon) {
        this.setIcon(icon, true);
    }

    public void setIcon(IconicsDrawable icon, boolean resetAttributes) {
        this.mIcon = icon;
        if (resetAttributes) {
            this.setAttributes();
        }
        this.setImageDrawable(this.mIcon);
    }

    public void setIconText(String iconText) {
        this.setIconText(iconText, true);
    }

    public void setIconText(String iconText, boolean resetAttributes) {
        this.setIcon(new IconicsDrawable(this.getContext()).iconText(iconText), resetAttributes);
    }

    private void setAttributes() {
        if (this.mColor != 0) {
            this.mIcon.color(this.mColor);
        }
        if (this.mSize != -1) {
            this.mIcon.sizePx(this.mSize);
        }
        if (this.mPadding != -1) {
            this.mIcon.paddingPx(this.mPadding);
        }
        if (this.mContourColor != 0) {
            this.mIcon.contourColor(this.mContourColor);
        }
        if (this.mContourWidth != -1) {
            this.mIcon.contourWidthPx(this.mContourWidth);
        }
        if (this.mBackgroundColor != 0) {
            this.mIcon.backgroundColor(this.mBackgroundColor);
        }
        if (this.mCornerRadius != -1) {
            this.mIcon.roundedCornersPx(this.mCornerRadius);
        }
    }

    public void setColor(@ColorInt int color) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).color(color);
        }
    }

    public void setColorRes(@ColorRes int colorRes) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).colorRes(colorRes);
        }
    }

    public void setPaddingPx(int padding) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).paddingPx(padding);
        }
    }

    public void setPaddingDp(int paddingDp) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).paddingDp(paddingDp);
        }
    }

    public void setPaddingRes(@DimenRes int paddingRes) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).paddingRes(paddingRes);
        }
    }

    public void setContourColor(@ColorInt int color) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).contourColor(color);
        }
    }

    public void setContourColorRes(@ColorRes int colorRes) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).contourColorRes(colorRes);
        }
    }

    public void setContourWidthPx(int padding) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).contourWidthPx(padding);
        }
    }

    public void setContourWidthDp(int paddingDp) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).contourWidthDp(paddingDp);
        }
    }

    public void setContourWidthRes(@DimenRes int paddingRes) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).contourWidthRes(paddingRes);
        }
    }

    public void setBackgroundColor(@ColorInt int color) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).backgroundColor(color);
        }
    }

    public void setBackgroundColorRes(@ColorRes int colorRes) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).backgroundColorRes(colorRes);
        }
    }

    public void setRoundedCornersPx(int padding) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).roundedCornersDp(padding);
        }
    }

    public void setRoundedCornersDp(int paddingDp) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).roundedCornersDp(paddingDp);
        }
    }

    public void setRoundedCornersRes(@DimenRes int paddingRes) {
        if (this.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)this.getDrawable()).roundedCornersPx(paddingRes);
        }
    }

    public IconicsDrawable getIcon() {
        if (this.getDrawable() instanceof IconicsDrawable) {
            return (IconicsDrawable)this.getDrawable();
        }
        return null;
    }
}

