/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.utils;

import android.content.Context;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.CharacterStyle;
import android.util.Log;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.utils.IconicsTypefaceSpan;
import com.mikepenz.iconics.utils.StyleContainer;
import com.mikepenz.iconics.utils.TextStyleContainer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class IconicsUtils {
    public static LinkedList<StyleContainer> findIconsFromEditable(Editable editable, HashMap<String, ITypeface> fonts) {
        LinkedList<StyleContainer> styleContainers = new LinkedList<StyleContainer>();
        int iconStart = -1;
        for (int i = 0; i < editable.length(); ++i) {
            StyleContainer styleContainer;
            Character c = Character.valueOf(editable.charAt(i));
            if (c.charValue() == '{') {
                iconStart = i;
                continue;
            }
            if (c.charValue() != '}') continue;
            if (iconStart > -1 && (styleContainer = IconicsUtils.placeFontIcon(editable, iconStart, i, fonts)) != null) {
                styleContainers.add(styleContainer);
                i -= iconStart;
            }
            iconStart = -1;
        }
        return styleContainers;
    }

    private static StyleContainer placeFontIcon(Editable editable, int iconStart, int iconEnd, HashMap<String, ITypeface> fonts) {
        if (iconEnd - iconStart >= 6) {
            String iconString = editable.subSequence(iconStart + 1, iconEnd).toString().replace("-", "_");
            String fontKey = editable.subSequence(iconStart + 1, iconStart + 4).toString();
            try {
                ITypeface typeface = fonts.get(fontKey);
                if (typeface != null) {
                    IIcon icon = typeface.getIcon(iconString);
                    if (icon != null) {
                        char fontChar = icon.getCharacter();
                        editable.replace(iconStart, iconEnd + 1, (CharSequence)String.valueOf(fontChar));
                        return new StyleContainer(iconStart, iconStart + 1, iconString, fonts.get(fontKey));
                    }
                    Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + iconString));
                } else {
                    Log.e((String)Iconics.TAG, (String)("Wrong fontId: " + iconString));
                }
            }
            catch (IllegalArgumentException e) {
                Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + iconString));
            }
        }
        return null;
    }

    public static TextStyleContainer findIcons(Spannable spannable, HashMap<String, ITypeface> fonts) {
        LinkedList<StyleContainer> styleContainers = new LinkedList<StyleContainer>();
        SpannableStringBuilder spannedString = new SpannableStringBuilder();
        SpannableStringBuilder tempIconString = new SpannableStringBuilder();
        for (int i = 0; i < spannable.length(); ++i) {
            Character c = Character.valueOf(spannable.charAt(i));
            if (c.charValue() == '{') {
                spannedString.append((CharSequence)tempIconString);
                tempIconString = new SpannableStringBuilder();
                tempIconString.append(c.charValue());
                continue;
            }
            if (c.charValue() == '}') {
                tempIconString.append(c.charValue());
                if (tempIconString.length() > 5) {
                    StyleContainer styleContainer = IconicsUtils.placeFontIcon(spannedString, tempIconString, fonts);
                    if (styleContainer != null) {
                        styleContainers.add(styleContainer);
                    }
                } else {
                    spannedString.append((CharSequence)tempIconString);
                }
                tempIconString = new SpannableStringBuilder();
                continue;
            }
            if (tempIconString.length() == 0) {
                spannedString.append(c.charValue());
                continue;
            }
            tempIconString.append(c.charValue());
        }
        spannedString.append((CharSequence)tempIconString);
        return new TextStyleContainer(spannedString, styleContainers);
    }

    private static StyleContainer placeFontIcon(SpannableStringBuilder spannedString, SpannableStringBuilder tempIconString, HashMap<String, ITypeface> fonts) {
        if (tempIconString.length() >= 6) {
            String iconString = tempIconString.subSequence(1, tempIconString.length() - 1).toString().replace("-", "_");
            String fontKey = tempIconString.subSequence(1, 4).toString();
            try {
                ITypeface typeface = fonts.get(fontKey);
                if (typeface != null) {
                    IIcon icon = typeface.getIcon(iconString);
                    if (icon != null) {
                        char fontChar = icon.getCharacter();
                        spannedString.append(fontChar);
                        return new StyleContainer(spannedString.length() - 1, spannedString.length(), iconString, fonts.get(fontKey));
                    }
                    Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + iconString));
                } else {
                    Log.e((String)Iconics.TAG, (String)("Wrong fontId: " + iconString));
                }
            }
            catch (IllegalArgumentException e) {
                Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + iconString));
            }
        }
        spannedString.append((CharSequence)tempIconString);
        return null;
    }

    public static void applyStyles(Context ctx, Spannable text, List<StyleContainer> styleContainers, List<CharacterStyle> styles, HashMap<String, List<CharacterStyle>> stylesFor) {
        for (StyleContainer styleContainer : styleContainers) {
            text.setSpan((Object)new IconicsTypefaceSpan("sans-serif", styleContainer.getFont().getTypeface(ctx)), styleContainer.getStartIndex(), styleContainer.getEndIndex(), 33);
            if (stylesFor != null && stylesFor.containsKey(styleContainer.getIcon())) {
                for (CharacterStyle style : stylesFor.get(styleContainer.getIcon())) {
                    text.setSpan((Object)CharacterStyle.wrap((CharacterStyle)style), styleContainer.getStartIndex(), styleContainer.getEndIndex(), 33);
                }
                continue;
            }
            if (styles == null) continue;
            for (CharacterStyle style : styles) {
                text.setSpan((Object)CharacterStyle.wrap((CharacterStyle)style), styleContainer.getStartIndex(), styleContainer.getEndIndex(), 33);
            }
        }
    }
}

