/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.utils;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.TypefaceSpan;

public class IconicsTypefaceSpan
extends TypefaceSpan {
    private final Typeface newType;

    public IconicsTypefaceSpan(String family, Typeface type) {
        super(family);
        this.newType = type;
    }

    public void updateDrawState(TextPaint ds) {
        IconicsTypefaceSpan.applyCustomTypeFace((Paint)ds, this.newType);
    }

    public void updateMeasureState(TextPaint paint) {
        IconicsTypefaceSpan.applyCustomTypeFace((Paint)paint, this.newType);
    }

    private static void applyCustomTypeFace(Paint paint, Typeface tf) {
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int fake = oldStyle & ~tf.getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(tf);
    }
}

