/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics;

import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.CharacterStyle;
import android.util.Log;
import android.widget.Button;
import android.widget.TextView;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.utils.GenericsUtil;
import com.mikepenz.iconics.utils.IconicsUtils;
import com.mikepenz.iconics.utils.StyleContainer;
import com.mikepenz.iconics.utils.TextStyleContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class Iconics {
    public static final String TAG = Iconics.class.getSimpleName();
    private static boolean INIT_DONE = false;
    private static HashMap<String, ITypeface> FONTS = new HashMap();

    public static void init(Context ctx) {
        String[] fonts;
        for (String fontsClassPath : fonts = GenericsUtil.getFields(ctx)) {
            try {
                ITypeface typeface = (ITypeface)Class.forName(fontsClassPath).newInstance();
                FONTS.put(typeface.getMappingPrefix(), typeface);
            }
            catch (Exception e) {
                Log.e((String)"Android-Iconics", (String)("Can't init: " + fontsClassPath));
            }
        }
        INIT_DONE = true;
    }

    public static boolean registerFont(ITypeface font) {
        FONTS.put(font.getMappingPrefix(), font);
        return true;
    }

    public static Collection<ITypeface> getRegisteredFonts(Context ctx) {
        if (!INIT_DONE) {
            Iconics.init(ctx);
        }
        return FONTS.values();
    }

    public static ITypeface findFont(Context ctx, String key) {
        if (!INIT_DONE) {
            Iconics.init(ctx);
        }
        return FONTS.get(key);
    }

    public static ITypeface findFont(IIcon icon) {
        return icon.getTypeface();
    }

    private Iconics() {
    }

    public static Spannable style(Context ctx, Spannable textSpanned) {
        return Iconics.style(ctx, null, textSpanned, null, null);
    }

    public static Spannable style(Context ctx, HashMap<String, ITypeface> fonts, Spannable textSpanned, List<CharacterStyle> styles, HashMap<String, List<CharacterStyle>> stylesFor) {
        if (!INIT_DONE) {
            Iconics.init(ctx);
        }
        if (fonts == null || fonts.size() == 0) {
            fonts = FONTS;
        }
        TextStyleContainer textStyleContainer = IconicsUtils.findIcons(textSpanned, fonts);
        SpannableString sb = SpannableString.valueOf((CharSequence)textStyleContainer.spannableStringBuilder);
        IconicsUtils.applyStyles(ctx, (Spannable)sb, textStyleContainer.styleContainers, styles, stylesFor);
        return sb;
    }

    public static void styleEditable(Context ctx, Editable editable) {
        Iconics.styleEditable(ctx, null, editable, null, null);
    }

    public static void styleEditable(Context ctx, HashMap<String, ITypeface> fonts, Editable textSpanned, List<CharacterStyle> styles, HashMap<String, List<CharacterStyle>> stylesFor) {
        if (!INIT_DONE) {
            Iconics.init(ctx);
        }
        if (fonts == null || fonts.size() == 0) {
            fonts = FONTS;
        }
        LinkedList<StyleContainer> styleContainers = IconicsUtils.findIconsFromEditable(textSpanned, fonts);
        IconicsUtils.applyStyles(ctx, (Spannable)textSpanned, styleContainers, styles, stylesFor);
    }

    public static class IconicsBuilder {
        private List<CharacterStyle> styles = new LinkedList<CharacterStyle>();
        private HashMap<String, List<CharacterStyle>> stylesFor = new HashMap();
        private List<ITypeface> fonts = new LinkedList<ITypeface>();
        private Context ctx;

        public IconicsBuilder ctx(Context ctx) {
            this.ctx = ctx;
            return this;
        }

        public IconicsBuilder style(CharacterStyle ... styles) {
            if (styles != null && styles.length > 0) {
                Collections.addAll(this.styles, styles);
            }
            return this;
        }

        public IconicsBuilder styleFor(IIcon styleFor, CharacterStyle ... styles) {
            return this.styleFor(styleFor.getName(), styles);
        }

        public IconicsBuilder styleFor(String styleFor, CharacterStyle ... styles) {
            if (!this.stylesFor.containsKey(styleFor = styleFor.replace("-", "_"))) {
                this.stylesFor.put(styleFor, new LinkedList());
            }
            if (styles != null && styles.length > 0) {
                for (CharacterStyle style : styles) {
                    this.stylesFor.get(styleFor).add(style);
                }
            }
            return this;
        }

        public IconicsBuilder font(ITypeface font) {
            this.fonts.add(font);
            return this;
        }

        public IconicsBuilderString on(SpannableString on) {
            return new IconicsBuilderString(this.ctx, this.fonts, on, this.styles, this.stylesFor);
        }

        public IconicsBuilderString on(String on) {
            return this.on(new SpannableString((CharSequence)on));
        }

        public IconicsBuilderString on(CharSequence on) {
            return this.on(on.toString());
        }

        public IconicsBuilderString on(StringBuilder on) {
            return this.on(on.toString());
        }

        public IconicsBuilderView on(TextView on) {
            return new IconicsBuilderView(this.ctx, this.fonts, on, this.styles, this.stylesFor);
        }

        public IconicsBuilderView on(Button on) {
            return new IconicsBuilderView(this.ctx, this.fonts, (TextView)on, this.styles, this.stylesFor);
        }
    }

    public static class IconicsBuilderView {
        private Context ctx;
        private TextView view;
        private List<CharacterStyle> withStyles;
        private HashMap<String, List<CharacterStyle>> withStylesFor;
        private List<ITypeface> fonts;

        public IconicsBuilderView(Context ctx, List<ITypeface> fonts, TextView view, List<CharacterStyle> styles, HashMap<String, List<CharacterStyle>> stylesFor) {
            this.ctx = ctx;
            this.fonts = fonts;
            this.view = view;
            this.withStyles = styles;
            this.withStylesFor = stylesFor;
        }

        public void build() {
            HashMap<String, ITypeface> mappedFonts = new HashMap<String, ITypeface>();
            for (ITypeface font : this.fonts) {
                mappedFonts.put(font.getMappingPrefix(), font);
            }
            if (this.view.getText() instanceof SpannableString) {
                this.view.setText((CharSequence)Iconics.style(this.ctx, mappedFonts, (Spannable)((SpannableString)this.view.getText()), this.withStyles, this.withStylesFor));
            } else {
                this.view.setText((CharSequence)Iconics.style(this.ctx, mappedFonts, (Spannable)new SpannableString(this.view.getText()), this.withStyles, this.withStylesFor));
            }
            if (Build.VERSION.SDK_INT >= 14 && this.view instanceof Button) {
                this.view.setAllCaps(false);
            }
        }
    }

    public static class IconicsBuilderString {
        private Context ctx;
        private SpannableString text;
        private List<CharacterStyle> withStyles;
        private HashMap<String, List<CharacterStyle>> withStylesFor;
        private List<ITypeface> fonts;

        public IconicsBuilderString(Context ctx, List<ITypeface> fonts, SpannableString text, List<CharacterStyle> styles, HashMap<String, List<CharacterStyle>> stylesFor) {
            this.ctx = ctx;
            this.fonts = fonts;
            this.text = text;
            this.withStyles = styles;
            this.withStylesFor = stylesFor;
        }

        public Spannable build() {
            HashMap<String, ITypeface> mappedFonts = new HashMap<String, ITypeface>();
            for (ITypeface font : this.fonts) {
                mappedFonts.put(font.getMappingPrefix(), font);
            }
            return Iconics.style(this.ctx, mappedFonts, (Spannable)this.text, this.withStyles, this.withStylesFor);
        }
    }
}

