/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.utils.DefaultItemListImpl;
import com.mikepenz.fastadapter.utils.SortKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002j\u0002`\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B'\b\u0007\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u001e\u0010\u0017\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u0019H\u0007R.\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00072\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/mikepenz/fastadapter/utils/ComparableItemListImpl;", "Item", "Lcom/mikepenz/fastadapter/IItem;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/mikepenz/fastadapter/GenericItem;", "Lcom/mikepenz/fastadapter/utils/DefaultItemListImpl;", "comparator", "Ljava/util/Comparator;", "items", "", "(Ljava/util/Comparator;Ljava/util/List;)V", "<set-?>", "getComparator", "()Ljava/util/Comparator;", "addAll", "", "position", "", "", "preItemCount", "move", "fromPosition", "toPosition", "setNewList", "notify", "", "withComparator", "sortNow", "fastadapter"})
public final class ComparableItemListImpl<Item extends IItem<? extends RecyclerView.ViewHolder>>
extends DefaultItemListImpl<Item> {
    @Nullable
    private Comparator<Item> comparator;

    @JvmOverloads
    public ComparableItemListImpl(@Nullable Comparator<Item> comparator, @NotNull List<Item> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        super(items);
        this.comparator = comparator;
    }

    public /* synthetic */ ComparableItemListImpl(Comparator comparator, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        this(comparator, list);
    }

    @Nullable
    public final Comparator<Item> getComparator() {
        return this.comparator;
    }

    @JvmOverloads
    @NotNull
    public final ComparableItemListImpl<Item> withComparator(@Nullable Comparator<Item> comparator, boolean sortNow) {
        block1: {
            this.comparator = comparator;
            if (this.comparator == null || !sortNow) break block1;
            Collections.sort(this.get_items(), this.comparator);
            FastAdapter fastAdapter = this.getFastAdapter();
            if (fastAdapter != null) {
                fastAdapter.notifyAdapterDataSetChanged();
            }
        }
        return this;
    }

    public static /* synthetic */ ComparableItemListImpl withComparator$default(ComparableItemListImpl comparableItemListImpl, Comparator comparator, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return comparableItemListImpl.withComparator(comparator, bl);
    }

    @Override
    public void move(int fromPosition, int toPosition, int preItemCount) {
        block0: {
            IItem item = (IItem)this.get_items().get(fromPosition - preItemCount);
            this.get_items().remove(fromPosition - preItemCount);
            this.get_items().add(toPosition - preItemCount, item);
            SortKt.trySortWith(this.get_items(), this.comparator);
            FastAdapter fastAdapter = this.getFastAdapter();
            if (fastAdapter == null) break block0;
            fastAdapter.notifyAdapterDataSetChanged();
        }
    }

    @Override
    public void addAll(@NotNull List<? extends Item> items, int preItemCount) {
        block0: {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.get_items().addAll((Collection)items);
            SortKt.trySortWith(this.get_items(), this.comparator);
            FastAdapter fastAdapter = this.getFastAdapter();
            if (fastAdapter == null) break block0;
            fastAdapter.notifyAdapterDataSetChanged();
        }
    }

    @Override
    public void addAll(int position, @NotNull List<? extends Item> items, int preItemCount) {
        block0: {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.get_items().addAll(position - preItemCount, (Collection)items);
            SortKt.trySortWith(this.get_items(), this.comparator);
            FastAdapter fastAdapter = this.getFastAdapter();
            if (fastAdapter == null) break block0;
            fastAdapter.notifyAdapterDataSetChanged();
        }
    }

    @Override
    public void setNewList(@NotNull List<? extends Item> items, boolean notify) {
        block1: {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.set_items(new ArrayList(items));
            SortKt.trySortWith(this.get_items(), this.comparator);
            if (!notify) break block1;
            FastAdapter fastAdapter = this.getFastAdapter();
            if (fastAdapter != null) {
                fastAdapter.notifyAdapterDataSetChanged();
            }
        }
    }

    @JvmOverloads
    public ComparableItemListImpl(@Nullable Comparator<Item> comparator) {
        this(comparator, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final ComparableItemListImpl<Item> withComparator(@Nullable Comparator<Item> comparator) {
        return ComparableItemListImpl.withComparator$default(this, comparator, false, 2, null);
    }
}

