/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import android.widget.Filter;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IAdapterExtension;
import com.mikepenz.fastadapter.IIdentifyable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.ModelAdapter;
import com.mikepenz.fastadapter.listeners.ItemFilterListener;
import com.mikepenz.fastadapter.select.SelectExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0014\b\u0001\u0010\u0002*\u000e\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003j\u0002`\u00052\u00020\u0006B\u0019\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ+\u0010(\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\b2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010*\"\u00028\u0001H\u0007\u00a2\u0006\u0002\u0010+J3\u0010(\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\b2\u0006\u0010,\u001a\u00020&2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010*\"\u00028\u0001H\u0007\u00a2\u0006\u0002\u0010-J&\u0010(\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\b2\u0006\u0010,\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010.J\u001e\u0010(\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010.J\u0010\u0010/\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\bJ\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u000bJ\u0013\u00103\u001a\u00020&2\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u00104J\u000e\u00103\u001a\u00020&2\u0006\u00105\u001a\u000206J \u00107\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\b2\u0006\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020&J\u0012\u0010:\u001a\u00020;2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0014J\u001a\u0010<\u001a\u0002012\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010=\u001a\u00020;H\u0014J\u0018\u0010>\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\b2\u0006\u0010,\u001a\u00020&J \u0010?\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\b2\u0006\u0010,\u001a\u00020&2\u0006\u0010@\u001a\u00020&J\u0006\u0010A\u001a\u000201J(\u0010B\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\b2\u0006\u0010,\u001a\u00020&2\u0006\u0010\u0013\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010CR\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eRN\u0010\u000f\u001a6\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010$\u00a8\u0006D"}, d2={"Lcom/mikepenz/fastadapter/adapters/ItemFilter;", "Model", "Item", "Lcom/mikepenz/fastadapter/IItem;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/mikepenz/fastadapter/GenericItem;", "Landroid/widget/Filter;", "itemAdapter", "Lcom/mikepenz/fastadapter/adapters/ModelAdapter;", "(Lcom/mikepenz/fastadapter/adapters/ModelAdapter;)V", "<set-?>", "", "constraint", "getConstraint", "()Ljava/lang/CharSequence;", "filterPredicate", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "item", "", "getFilterPredicate", "()Lkotlin/jvm/functions/Function2;", "setFilterPredicate", "(Lkotlin/jvm/functions/Function2;)V", "itemFilterListener", "Lcom/mikepenz/fastadapter/listeners/ItemFilterListener;", "getItemFilterListener", "()Lcom/mikepenz/fastadapter/listeners/ItemFilterListener;", "setItemFilterListener", "(Lcom/mikepenz/fastadapter/listeners/ItemFilterListener;)V", "originalItems", "", "selectedItems", "", "getSelectedItems", "()Ljava/util/Set;", "selections", "", "getSelections", "add", "items", "", "([Lcom/mikepenz/fastadapter/IItem;)Lcom/mikepenz/fastadapter/adapters/ModelAdapter;", "position", "(I[Lcom/mikepenz/fastadapter/IItem;)Lcom/mikepenz/fastadapter/adapters/ModelAdapter;", "", "clear", "filterItems", "", "filter", "getAdapterPosition", "(Lcom/mikepenz/fastadapter/IItem;)I", "identifier", "", "move", "fromPosition", "toPosition", "performFiltering", "Landroid/widget/Filter$FilterResults;", "publishResults", "results", "remove", "removeRange", "itemCount", "resetFilter", "set", "(ILcom/mikepenz/fastadapter/IItem;)Lcom/mikepenz/fastadapter/adapters/ModelAdapter;", "fastadapter"})
public class ItemFilter<Model, Item extends IItem<? extends RecyclerView.ViewHolder>>
extends Filter {
    @NotNull
    private final ModelAdapter<Model, Item> itemAdapter;
    @Nullable
    private List<Item> originalItems;
    @Nullable
    private CharSequence constraint;
    @Nullable
    private ItemFilterListener<Item> itemFilterListener;
    @Nullable
    private Function2<? super Item, ? super CharSequence, Boolean> filterPredicate;

    public ItemFilter(@NotNull ModelAdapter<Model, Item> itemAdapter) {
        Intrinsics.checkNotNullParameter(itemAdapter, (String)"itemAdapter");
        this.itemAdapter = itemAdapter;
    }

    @Nullable
    public final CharSequence getConstraint() {
        return this.constraint;
    }

    @Nullable
    public final ItemFilterListener<Item> getItemFilterListener() {
        return this.itemFilterListener;
    }

    public final void setItemFilterListener(@Nullable ItemFilterListener<Item> itemFilterListener) {
        this.itemFilterListener = itemFilterListener;
    }

    @Nullable
    public final Function2<Item, CharSequence, Boolean> getFilterPredicate() {
        return this.filterPredicate;
    }

    public final void setFilterPredicate(@Nullable Function2<? super Item, ? super CharSequence, Boolean> function2) {
        this.filterPredicate = function2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Integer> getSelections() {
        Set set;
        FastAdapter<Item> fastAdapter = this.itemAdapter.getFastAdapter();
        if (fastAdapter == null) {
            return SetsKt.emptySet();
        }
        FastAdapter<Item> fastAdapter2 = fastAdapter;
        int adapterOffset = fastAdapter2.getPreItemCountByOrder(this.itemAdapter.getOrder());
        List<Item> list = this.originalItems;
        if (list != null) {
            void $this$mapIndexedNotNullTo$iv;
            Iterable iterable = list;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv = $this$mapIndexedNotNullTo$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                Integer it$iv;
                void item;
                void element$iv;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int index$iv = n;
                boolean bl = false;
                IItem iItem = (IItem)element$iv;
                int index = index$iv;
                boolean bl2 = false;
                if ((item.isSelected() ? Integer.valueOf(index + adapterOffset) : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            set = (HashSet)destination$iv;
        } else {
            SelectExtension selectExtension = fastAdapter2.getExtension(SelectExtension.class);
            set = selectExtension != null ? selectExtension.getSelections() : SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Item> getSelectedItems() {
        Set set;
        List<Item> list = this.originalItems;
        if (list != null) {
            void var2_3;
            void $this$filterTo$iv;
            Iterable iterable = list;
            Collection destination$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                IItem it = (IItem)element$iv;
                boolean bl = false;
                if (!it.isSelected()) continue;
                destination$iv.add(element$iv);
            }
            set = (HashSet)var2_3;
        } else {
            SelectExtension selectExtension;
            FastAdapter<Item> fastAdapter = this.itemAdapter.getFastAdapter();
            set = fastAdapter != null && (selectExtension = fastAdapter.getExtension(SelectExtension.class)) != null ? selectExtension.getSelectedItems() : SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Filter.FilterResults performFiltering(@Nullable CharSequence constraint) {
        CharSequence charSequence;
        List items;
        CharSequence charSequence2;
        Filter.FilterResults results = new Filter.FilterResults();
        if (this.originalItems == null && ((charSequence2 = constraint) == null || charSequence2.length() == 0)) {
            return results;
        }
        FastAdapter<Item> fastAdapter = this.itemAdapter.getFastAdapter();
        if (fastAdapter != null && (fastAdapter = fastAdapter.getExtensions()) != null) {
            Iterable $this$forEach$iv = (Iterable)((Object)fastAdapter);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IAdapterExtension adapterExtension = (IAdapterExtension)element$iv;
                boolean bl = false;
                adapterExtension.performFiltering(constraint);
            }
        }
        this.constraint = constraint;
        List list = this.originalItems;
        if (list == null) {
            ArrayList arrayList;
            ArrayList it = arrayList = new ArrayList(this.itemAdapter.getAdapterItems());
            boolean bl = false;
            this.originalItems = it;
            list = items = (List)arrayList;
        }
        if ((charSequence = constraint) == null || charSequence.length() == 0) {
            results.values = items;
            results.count = items.size();
            this.originalItems = null;
            ItemFilterListener<Item> itemFilterListener = this.itemFilterListener;
            if (itemFilterListener != null) {
                itemFilterListener.onReset();
            }
        } else {
            List filteredItems;
            List list2;
            Function2<? super Item, ? super CharSequence, Boolean> function2 = this.filterPredicate;
            if (function2 != null) {
                void $this$filterTo$iv$iv;
                Function2<? super Item, ? super CharSequence, Boolean> filterPredicate = function2;
                boolean bl = false;
                Iterable $this$filter$iv = items;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IItem it = (IItem)element$iv$iv;
                    boolean bl2 = false;
                    if (!((Boolean)filterPredicate.invoke((Object)it, (Object)constraint)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = this.itemAdapter.getAdapterItems();
            }
            results.values = filteredItems = list2;
            results.count = filteredItems.size();
        }
        return results;
    }

    protected void publishResults(@Nullable CharSequence constraint, @NotNull Filter.FilterResults results) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)results, (String)"results");
            if (results.values != null) {
                Object object = results.values;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<Item of com.mikepenz.fastadapter.adapters.ItemFilter>");
                this.itemAdapter.setInternal((List)object, false, null);
            }
            if (this.originalItems == null) break block2;
            ItemFilterListener<Item> itemFilterListener = this.itemFilterListener;
            if (itemFilterListener != null) {
                Object object = results.values;
                itemFilterListener.itemsFiltered(constraint, object instanceof List ? (List)object : null);
            }
        }
    }

    public final void resetFilter() {
        this.performFiltering(null);
    }

    public final void filterItems(@NotNull CharSequence filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        this.publishResults(filter, this.performFiltering(filter));
    }

    public final int getAdapterPosition(@NotNull Item item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return this.getAdapterPosition(item.getIdentifier());
    }

    public final int getAdapterPosition(long identifier) {
        int n;
        block4: {
            List<Item> list = this.originalItems;
            if (list != null) {
                List<Item> $this$indexOfFirst$iv = list;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Item item$iv : $this$indexOfFirst$iv) {
                    IItem it = (IItem)item$iv;
                    boolean bl = false;
                    if (it.getIdentifier() == identifier) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            } else {
                n = -1;
            }
        }
        return n;
    }

    @SafeVarargs
    @NotNull
    public final ModelAdapter<?, Item> add(Item ... items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        return this.add(CollectionsKt.listOf((Object[])Arrays.copyOf(items, items.length)));
    }

    @NotNull
    public final ModelAdapter<?, Item> add(@NotNull List<? extends Item> items) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                if (items.isEmpty()) {
                    return this.itemAdapter;
                }
                object = this.originalItems;
                if (object == null) break block5;
                List<Item> originalItems = object;
                boolean bl = false;
                if (this.itemAdapter.isUseIdDistributor()) {
                    this.itemAdapter.getIdDistributor().checkIds(items);
                }
                originalItems.addAll((Collection)items);
                this.publishResults(this.constraint, this.performFiltering(this.constraint));
                ModelAdapter<Model, Item> modelAdapter = this.itemAdapter;
                object = modelAdapter;
                if (modelAdapter != null) break block6;
            }
            object = this.itemAdapter.addInternal((List)items);
        }
        return object;
    }

    @SafeVarargs
    @NotNull
    public final ModelAdapter<?, Item> add(int position, Item ... items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        List<Item> list = Arrays.asList(Arrays.copyOf(items, items.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(*items)");
        return this.add(position, list);
    }

    @NotNull
    public final ModelAdapter<?, Item> add(int position, @NotNull List<? extends Item> items) {
        Object object;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                if (items.isEmpty()) {
                    return this.itemAdapter;
                }
                object = this.originalItems;
                if (object == null) break block7;
                List<Item> originalItems = object;
                boolean bl = false;
                if (this.itemAdapter.isUseIdDistributor()) {
                    this.itemAdapter.getIdDistributor().checkIds(items);
                }
                FastAdapter<Item> fastAdapter = this.itemAdapter.getFastAdapter();
                if (fastAdapter != null) {
                    FastAdapter<Item> fastAdapter2 = fastAdapter;
                    boolean bl2 = false;
                    int origPosition = this.getAdapterPosition((IItem)this.itemAdapter.getAdapterItems().get(position)) - fastAdapter2.getPreItemCount(position);
                    originalItems.addAll(origPosition, (Collection)items);
                }
                this.publishResults(this.constraint, this.performFiltering(this.constraint));
                ModelAdapter<Model, Item> modelAdapter = this.itemAdapter;
                object = modelAdapter;
                if (modelAdapter != null) break block8;
            }
            object = this.itemAdapter.addInternal(position, (List)items);
        }
        return object;
    }

    @NotNull
    public final ModelAdapter<?, Item> set(int position, @NotNull Item item) {
        Object object;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(item, (String)"item");
                object = this.originalItems;
                if (object == null) break block6;
                List<Item> originalItems = object;
                boolean bl = false;
                if (this.itemAdapter.isUseIdDistributor()) {
                    this.itemAdapter.getIdDistributor().checkId((IIdentifyable)item);
                }
                FastAdapter<Item> fastAdapter = this.itemAdapter.getFastAdapter();
                if (fastAdapter != null) {
                    FastAdapter<Item> fastAdapter2 = fastAdapter;
                    boolean bl2 = false;
                    int origPosition = this.getAdapterPosition((IItem)this.itemAdapter.getAdapterItems().get(position)) - fastAdapter2.getPreItemCount(position);
                    originalItems.set(origPosition, item);
                }
                this.publishResults(this.constraint, this.performFiltering(this.constraint));
                ModelAdapter<Model, Item> modelAdapter = this.itemAdapter;
                object = modelAdapter;
                if (modelAdapter != null) break block7;
            }
            object = this.itemAdapter.setInternal(position, (IItem)item);
        }
        return object;
    }

    @NotNull
    public final ModelAdapter<?, Item> move(int fromPosition, int toPosition) {
        Object object;
        block5: {
            block4: {
                object = this.originalItems;
                if (object == null) break block4;
                List<Item> originalItems = object;
                boolean bl = false;
                FastAdapter<Item> fastAdapter = this.itemAdapter.getFastAdapter();
                if (fastAdapter != null) {
                    int preItemCount = fastAdapter.getPreItemCount(fromPosition);
                    boolean bl2 = false;
                    int adjustedFrom = this.getAdapterPosition((IItem)this.itemAdapter.getAdapterItems().get(fromPosition));
                    int adjustedTo = this.getAdapterPosition((IItem)this.itemAdapter.getAdapterItems().get(toPosition));
                    IItem item = (IItem)originalItems.get(adjustedFrom - preItemCount);
                    originalItems.remove(adjustedFrom - preItemCount);
                    originalItems.add(adjustedTo - preItemCount, item);
                    this.performFiltering(this.constraint);
                }
                ModelAdapter<Model, Item> modelAdapter = this.itemAdapter;
                object = modelAdapter;
                if (modelAdapter != null) break block5;
            }
            object = this.itemAdapter.move(fromPosition, toPosition);
        }
        return object;
    }

    @NotNull
    public final ModelAdapter<?, Item> remove(int position) {
        Object object;
        block5: {
            block4: {
                object = this.originalItems;
                if (object == null) break block4;
                List<Item> originalItems = object;
                boolean bl = false;
                FastAdapter<Item> fastAdapter = this.itemAdapter.getFastAdapter();
                if (fastAdapter != null) {
                    FastAdapter<Item> fastAdapter2 = fastAdapter;
                    boolean bl2 = false;
                    int origPosition = this.getAdapterPosition((IItem)this.itemAdapter.getAdapterItems().get(position)) - fastAdapter2.getPreItemCount(position);
                    IItem cfr_ignored_0 = (IItem)originalItems.remove(origPosition);
                }
                this.publishResults(this.constraint, this.performFiltering(this.constraint));
                ModelAdapter<Model, Item> modelAdapter = this.itemAdapter;
                object = modelAdapter;
                if (modelAdapter != null) break block5;
            }
            object = this.itemAdapter.remove(position);
        }
        return object;
    }

    @NotNull
    public final ModelAdapter<?, Item> removeRange(int position, int itemCount) {
        Object object;
        block6: {
            block5: {
                object = this.originalItems;
                if (object == null) break block5;
                List<Item> originalItems = object;
                boolean bl = false;
                int length = originalItems.size();
                FastAdapter<Item> fastAdapter = this.itemAdapter.getFastAdapter();
                if (fastAdapter != null) {
                    int preItemCount = fastAdapter.getPreItemCount(position);
                    boolean bl2 = false;
                    int saveItemCount = Math.min(itemCount, length - position + preItemCount);
                    for (int i = 0; i < saveItemCount; ++i) {
                        originalItems.remove(position - preItemCount);
                    }
                    this.publishResults(this.constraint, this.performFiltering(this.constraint));
                }
                ModelAdapter<Model, Item> modelAdapter = this.itemAdapter;
                object = modelAdapter;
                if (modelAdapter != null) break block6;
            }
            object = this.itemAdapter.removeRange(position, itemCount);
        }
        return object;
    }

    @NotNull
    public final ModelAdapter<?, Item> clear() {
        Object object;
        block3: {
            block2: {
                object = this.originalItems;
                if (object == null) break block2;
                List<Item> originalItems = object;
                boolean bl = false;
                originalItems.clear();
                this.publishResults(this.constraint, this.performFiltering(this.constraint));
                ModelAdapter<Model, Item> modelAdapter = this.itemAdapter;
                object = modelAdapter;
                if (modelAdapter != null) break block3;
            }
            object = this.itemAdapter.clear();
        }
        return object;
    }
}

