/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.listeners;

import android.util.Log;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.R;
import com.mikepenz.fastadapter.listeners.OnBindViewHolderListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002j\u0002`\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/mikepenz/fastadapter/listeners/OnBindViewHolderListenerImpl;", "Item", "Lcom/mikepenz/fastadapter/IItem;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/mikepenz/fastadapter/GenericItem;", "Lcom/mikepenz/fastadapter/listeners/OnBindViewHolderListener;", "()V", "onBindViewHolder", "", "viewHolder", "position", "", "payloads", "", "", "onFailedToRecycleView", "", "onViewAttachedToWindow", "onViewDetachedFromWindow", "unBindViewHolder", "fastadapter"})
public class OnBindViewHolderListenerImpl<Item extends IItem<? extends RecyclerView.ViewHolder>>
implements OnBindViewHolderListener {
    @Override
    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int position, @NotNull List<? extends Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        FastAdapter fastAdapter = FastAdapter.Companion.getFromHolderTag(viewHolder);
        if (fastAdapter == null) {
            return;
        }
        FastAdapter adapter = fastAdapter;
        Object object = adapter.getItem(position);
        if (object == null) {
            return;
        }
        Object item = object;
        if ((object = item) != null) {
            object.bindView((RecyclerView.ViewHolder)viewHolder, payloads);
        }
        FastAdapter.ViewHolder viewHolder2 = object = viewHolder instanceof FastAdapter.ViewHolder ? (FastAdapter.ViewHolder)viewHolder : null;
        if (object != null) {
            ((FastAdapter.ViewHolder)((Object)object)).bindView(item, payloads);
        }
        viewHolder.itemView.setTag(R.id.fastadapter_item, item);
    }

    @Override
    public void unBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Object item = FastAdapter.Companion.getHolderAdapterItemTag(viewHolder);
        if (item != null) {
            FastAdapter.ViewHolder viewHolder2;
            item.unbindView((RecyclerView.ViewHolder)viewHolder);
            FastAdapter.ViewHolder viewHolder3 = viewHolder2 = viewHolder instanceof FastAdapter.ViewHolder ? (FastAdapter.ViewHolder)viewHolder : null;
            if (viewHolder2 != null) {
                viewHolder2.unbindView(item);
            }
            viewHolder.itemView.setTag(R.id.fastadapter_item, null);
            viewHolder.itemView.setTag(R.id.fastadapter_item_adapter, null);
        } else {
            Log.e((String)"FastAdapter", (String)"The bindView method of this item should set the `Tag` on its itemView (https://github.com/mikepenz/FastAdapter/blob/develop/library-core/src/main/java/com/mikepenz/fastadapter/items/AbstractItem.kt#L22)");
        }
    }

    @Override
    public void onViewAttachedToWindow(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Object item = FastAdapter.Companion.getHolderAdapterItem(viewHolder, position);
        if (item != null) {
            try {
                FastAdapter.ViewHolder viewHolder2;
                item.attachToWindow((RecyclerView.ViewHolder)viewHolder);
                FastAdapter.ViewHolder viewHolder3 = viewHolder2 = viewHolder instanceof FastAdapter.ViewHolder ? (FastAdapter.ViewHolder)viewHolder : null;
                if (viewHolder2 != null) {
                    viewHolder2.attachToWindow(item);
                }
            }
            catch (AbstractMethodError e) {
                Log.e((String)"FastAdapter", (String)e.toString());
            }
        }
    }

    @Override
    public void onViewDetachedFromWindow(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Object object = FastAdapter.Companion.getHolderAdapterItemTag(viewHolder);
        if (object == null) {
            return;
        }
        Object item = object;
        item.detachFromWindow((RecyclerView.ViewHolder)viewHolder);
        FastAdapter.ViewHolder viewHolder2 = object = viewHolder instanceof FastAdapter.ViewHolder ? (FastAdapter.ViewHolder)viewHolder : null;
        if (object != null) {
            ((FastAdapter.ViewHolder)((Object)object)).detachFromWindow(item);
        }
    }

    @Override
    public boolean onFailedToRecycleView(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Object Item = FastAdapter.Companion.getHolderAdapterItemTag(viewHolder);
        if (Item == null) {
            return false;
        }
        Object item = Item;
        boolean recycle = item.failedToRecycle((RecyclerView.ViewHolder)viewHolder);
        if (viewHolder instanceof FastAdapter.ViewHolder) {
            recycle = recycle || ((FastAdapter.ViewHolder)viewHolder).failedToRecycle(item);
        }
        return recycle;
    }
}

