/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.utils.DefaultItemListImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0017\b\u0016\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B%\b\u0016\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u001e\u0010\u0018\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u001aH\u0007R4\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00062\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/mikepenz/fastadapter/utils/ComparableItemListImpl;", "Item", "Lcom/mikepenz/fastadapter/IItem;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/mikepenz/fastadapter/utils/DefaultItemListImpl;", "comparator", "Ljava/util/Comparator;", "(Ljava/util/Comparator;)V", "items", "", "(Ljava/util/Comparator;Ljava/util/List;)V", "<set-?>", "getComparator", "()Ljava/util/Comparator;", "setComparator", "addAll", "", "position", "", "", "preItemCount", "move", "fromPosition", "toPosition", "setNewList", "notify", "", "withComparator", "sortNow", "library-core_release"})
public final class ComparableItemListImpl<Item extends IItem<? extends RecyclerView.ViewHolder>>
extends DefaultItemListImpl<Item> {
    @Nullable
    private Comparator<Item> comparator;

    @Nullable
    public final Comparator<Item> getComparator() {
        return this.comparator;
    }

    private final void setComparator(Comparator<Item> comparator) {
        this.comparator = comparator;
    }

    @JvmOverloads
    @NotNull
    public final ComparableItemListImpl<Item> withComparator(@Nullable Comparator<Item> comparator, boolean sortNow) {
        this.comparator = comparator;
        if (this.comparator != null && sortNow) {
            Collections.sort(this.getMItems(), this.comparator);
            FastAdapter fastAdapter = this.getFastAdapter();
            if (fastAdapter == null) {
                Intrinsics.throwNpe();
            }
            fastAdapter.notifyAdapterDataSetChanged();
        }
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ ComparableItemListImpl withComparator$default(ComparableItemListImpl comparableItemListImpl, Comparator comparator, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return comparableItemListImpl.withComparator(comparator, bl);
    }

    @JvmOverloads
    @NotNull
    public final ComparableItemListImpl<Item> withComparator(@Nullable Comparator<Item> comparator) {
        return ComparableItemListImpl.withComparator$default(this, comparator, false, 2, null);
    }

    @Override
    public void move(int fromPosition, int toPosition, int preItemCount) {
        IItem item = (IItem)this.getMItems().get(fromPosition - preItemCount);
        this.getMItems().remove(fromPosition - preItemCount);
        this.getMItems().add(toPosition - preItemCount, item);
        if (this.comparator != null) {
            Collections.sort(this.getMItems(), this.comparator);
        }
        FastAdapter fastAdapter = this.getFastAdapter();
        if (fastAdapter == null) {
            Intrinsics.throwNpe();
        }
        fastAdapter.notifyAdapterDataSetChanged();
    }

    @Override
    public void addAll(@NotNull List<? extends Item> items, int preItemCount) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this.getMItems().addAll((Collection)items);
        if (this.comparator != null) {
            Collections.sort(this.getMItems(), this.comparator);
        }
        FastAdapter fastAdapter = this.getFastAdapter();
        if (fastAdapter == null) {
            Intrinsics.throwNpe();
        }
        fastAdapter.notifyAdapterDataSetChanged();
    }

    @Override
    public void addAll(int position, @NotNull List<? extends Item> items, int preItemCount) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this.getMItems().addAll(position - preItemCount, (Collection)items);
        if (this.comparator != null) {
            Collections.sort(this.getMItems(), this.comparator);
        }
        FastAdapter fastAdapter = this.getFastAdapter();
        if (fastAdapter == null) {
            Intrinsics.throwNpe();
        }
        fastAdapter.notifyAdapterDataSetChanged();
    }

    @Override
    public void setNewList(@NotNull List<? extends Item> items, boolean notify) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this.setMItems(new ArrayList(items));
        if (this.comparator != null) {
            Collections.sort(this.getMItems(), this.comparator);
        }
        if (notify) {
            FastAdapter fastAdapter = this.getFastAdapter();
            if (fastAdapter == null) {
                Intrinsics.throwNpe();
            }
            fastAdapter.notifyAdapterDataSetChanged();
        }
    }

    public ComparableItemListImpl(@Nullable Comparator<Item> comparator) {
        super(null, 1, null);
        this.setMItems(new ArrayList());
        this.comparator = comparator;
    }

    public ComparableItemListImpl(@Nullable Comparator<Item> comparator, @NotNull List<Item> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        super(null, 1, null);
        this.setMItems(items);
        this.comparator = comparator;
    }
}

