/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.items;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.IClickable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.listeners.OnClickListener;
import java.util.Collections;
import java.util.List;

public abstract class AbstractItem<Item extends IItem & IClickable, VH extends RecyclerView.ViewHolder>
implements IItem<Item, VH>,
IClickable<Item> {
    protected long mIdentifier = -1L;
    protected Object mTag;
    protected boolean mEnabled = true;
    protected boolean mSelected = false;
    protected boolean mSelectable = true;
    protected OnClickListener<Item> mOnItemPreClickListener;
    protected OnClickListener<Item> mOnItemClickListener;

    @Override
    public Item withIdentifier(long identifier) {
        this.mIdentifier = identifier;
        return (Item)this;
    }

    @Override
    public long getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public Item withTag(Object object) {
        this.mTag = object;
        return (Item)this;
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    @Override
    public Item withEnabled(boolean enabled) {
        this.mEnabled = enabled;
        return (Item)this;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public Item withSetSelected(boolean selected) {
        this.mSelected = selected;
        return (Item)this;
    }

    @Override
    public boolean isSelected() {
        return this.mSelected;
    }

    @Override
    public Item withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return (Item)this;
    }

    @Override
    public boolean isSelectable() {
        return this.mSelectable;
    }

    @Override
    public Item withOnItemPreClickListener(OnClickListener<Item> onItemPreClickListener) {
        this.mOnItemPreClickListener = onItemPreClickListener;
        return (Item)this;
    }

    @Override
    public OnClickListener<Item> getOnPreItemClickListener() {
        return this.mOnItemPreClickListener;
    }

    @Override
    public Item withOnItemClickListener(OnClickListener<Item> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
        return (Item)this;
    }

    @Override
    public OnClickListener<Item> getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    @Override
    @CallSuper
    public void bindView(VH holder, List<Object> payloads) {
        ((RecyclerView.ViewHolder)holder).itemView.setSelected(this.isSelected());
    }

    @Override
    public void unbindView(VH holder) {
    }

    @Override
    public void attachToWindow(VH holder) {
    }

    @Override
    public void detachFromWindow(VH holder) {
    }

    @Override
    public boolean failedToRecycle(VH holder) {
        return false;
    }

    public View createView(Context ctx, @Nullable ViewGroup parent) {
        return LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), parent, false);
    }

    @Override
    public View generateView(Context ctx) {
        VH viewHolder = this.getViewHolder(this.createView(ctx, null));
        this.bindView(viewHolder, Collections.EMPTY_LIST);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public View generateView(Context ctx, ViewGroup parent) {
        VH viewHolder = this.getViewHolder(this.createView(ctx, parent));
        this.bindView(viewHolder, Collections.EMPTY_LIST);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public VH getViewHolder(ViewGroup parent) {
        return this.getViewHolder(this.createView(parent.getContext(), parent));
    }

    @NonNull
    public abstract VH getViewHolder(View var1);

    @Override
    public boolean equals(int id2) {
        return (long)id2 == this.getIdentifier();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractItem that = (AbstractItem)o;
        return this.getIdentifier() == that.getIdentifier();
    }

    public int hashCode() {
        return Long.valueOf(this.getIdentifier()).hashCode();
    }
}

