/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter;

import android.os.Bundle;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import androidx.core.util.Pair;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IAdapterExtension;
import com.mikepenz.fastadapter.IClickable;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IHookable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.ISelectionListener;
import com.mikepenz.fastadapter.ITypeInstanceCache;
import com.mikepenz.fastadapter.R;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.listeners.ClickEventHook;
import com.mikepenz.fastadapter.listeners.EventHook;
import com.mikepenz.fastadapter.listeners.LongClickEventHook;
import com.mikepenz.fastadapter.listeners.OnBindViewHolderListener;
import com.mikepenz.fastadapter.listeners.OnBindViewHolderListenerImpl;
import com.mikepenz.fastadapter.listeners.OnClickListener;
import com.mikepenz.fastadapter.listeners.OnCreateViewHolderListener;
import com.mikepenz.fastadapter.listeners.OnCreateViewHolderListenerImpl;
import com.mikepenz.fastadapter.listeners.OnLongClickListener;
import com.mikepenz.fastadapter.listeners.OnTouchListener;
import com.mikepenz.fastadapter.listeners.TouchEventHook;
import com.mikepenz.fastadapter.select.SelectExtension;
import com.mikepenz.fastadapter.utils.AdapterPredicate;
import com.mikepenz.fastadapter.utils.DefaultTypeInstanceCache;
import com.mikepenz.fastadapter.utils.EventHookUtil;
import com.mikepenz.fastadapter.utils.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FastAdapter<Item extends IItem>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = "FastAdapter";
    private final ArrayList<IAdapter<Item>> mAdapters = new ArrayList();
    private ITypeInstanceCache<Item> mTypeInstanceCache;
    private final SparseArray<IAdapter<Item>> mAdapterSizes = new SparseArray();
    private int mGlobalSize = 0;
    private List<EventHook<Item>> eventHooks;
    private final Map<Class, IAdapterExtension<Item>> mExtensions = new ArrayMap();
    private SelectExtension<Item> mSelectExtension = new SelectExtension();
    private boolean mLegacyBindViewMode = false;
    private boolean mAttachDefaultListeners = true;
    private boolean mVerbose = false;
    private OnClickListener<Item> mOnPreClickListener;
    private OnClickListener<Item> mOnClickListener;
    private OnLongClickListener<Item> mOnPreLongClickListener;
    private OnLongClickListener<Item> mOnLongClickListener;
    private OnTouchListener<Item> mOnTouchListener;
    private OnCreateViewHolderListener mOnCreateViewHolderListener = new OnCreateViewHolderListenerImpl();
    private OnBindViewHolderListener mOnBindViewHolderListener = new OnBindViewHolderListenerImpl();
    private ClickEventHook<Item> fastAdapterViewClickListener = new ClickEventHook<Item>(){

        @Override
        public void onClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
            IAdapter adapter = fastAdapter.getAdapter(pos);
            if (adapter != null && item != null && item.isEnabled()) {
                boolean consumed = false;
                if (item instanceof IClickable && ((IClickable)item).getOnPreItemClickListener() != null) {
                    consumed = ((IClickable)item).getOnPreItemClickListener().onClick(v, adapter, item, pos);
                }
                if (!consumed && fastAdapter.mOnPreClickListener != null) {
                    consumed = fastAdapter.mOnPreClickListener.onClick(v, adapter, item, pos);
                }
                for (IAdapterExtension ext : fastAdapter.mExtensions.values()) {
                    if (consumed) break;
                    consumed = ext.onClick(v, pos, fastAdapter, item);
                }
                if (!consumed && item instanceof IClickable && ((IClickable)item).getOnItemClickListener() != null) {
                    consumed = ((IClickable)item).getOnItemClickListener().onClick(v, adapter, item, pos);
                }
                if (!consumed && fastAdapter.mOnClickListener != null) {
                    fastAdapter.mOnClickListener.onClick(v, adapter, item, pos);
                }
            }
        }
    };
    private LongClickEventHook<Item> fastAdapterViewLongClickListener = new LongClickEventHook<Item>(){

        @Override
        public boolean onLongClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
            boolean consumed = false;
            IAdapter adapter = fastAdapter.getAdapter(pos);
            if (adapter != null && item != null && item.isEnabled()) {
                if (fastAdapter.mOnPreLongClickListener != null) {
                    consumed = fastAdapter.mOnPreLongClickListener.onLongClick(v, adapter, item, pos);
                }
                for (IAdapterExtension ext : fastAdapter.mExtensions.values()) {
                    if (consumed) break;
                    consumed = ext.onLongClick(v, pos, fastAdapter, item);
                }
                if (!consumed && fastAdapter.mOnLongClickListener != null) {
                    consumed = fastAdapter.mOnLongClickListener.onLongClick(v, adapter, item, pos);
                }
            }
            return consumed;
        }
    };
    private TouchEventHook<Item> fastAdapterViewTouchListener = new TouchEventHook<Item>(){

        @Override
        public boolean onTouch(View v, MotionEvent event, int position, FastAdapter<Item> fastAdapter, Item item) {
            IAdapter adapter;
            boolean consumed = false;
            for (IAdapterExtension ext : fastAdapter.mExtensions.values()) {
                if (consumed) break;
                consumed = ext.onTouch(v, event, position, fastAdapter, item);
            }
            if (fastAdapter.mOnTouchListener != null && (adapter = fastAdapter.getAdapter(position)) != null) {
                return fastAdapter.mOnTouchListener.onTouch(v, event, adapter, item, position);
            }
            return consumed;
        }
    };

    private static int floorIndex(SparseArray<?> sparseArray, int key) {
        int index = sparseArray.indexOfKey(key);
        if (index < 0) {
            index = ~index - 1;
        }
        return index;
    }

    public FastAdapter() {
        this.setHasStableIds(true);
    }

    public FastAdapter<Item> enableVerboseLog() {
        this.mVerbose = true;
        return this;
    }

    public void setTypeInstanceCache(ITypeInstanceCache<Item> mTypeInstanceCache) {
        this.mTypeInstanceCache = mTypeInstanceCache;
    }

    public ITypeInstanceCache<Item> getTypeInstanceCache() {
        if (this.mTypeInstanceCache == null) {
            this.mTypeInstanceCache = new DefaultTypeInstanceCache();
        }
        return this.mTypeInstanceCache;
    }

    public static <Item extends IItem, A extends IAdapter> FastAdapter<Item> with(A adapter) {
        FastAdapter<Item> fastAdapter = new FastAdapter<Item>();
        fastAdapter.addAdapter(0, adapter);
        return fastAdapter;
    }

    public static <Item extends IItem, A extends IAdapter> FastAdapter<Item> with(@Nullable Collection<A> adapters) {
        return FastAdapter.with(adapters, null);
    }

    public static <Item extends IItem, A extends IAdapter> FastAdapter<Item> with(@Nullable Collection<A> adapters, @Nullable Collection<IAdapterExtension<Item>> extensions) {
        FastAdapter<Item> fastAdapter = new FastAdapter<Item>();
        if (adapters == null) {
            fastAdapter.mAdapters.add(ItemAdapter.items());
        } else {
            fastAdapter.mAdapters.addAll(adapters);
        }
        for (int i = 0; i < fastAdapter.mAdapters.size(); ++i) {
            fastAdapter.mAdapters.get(i).withFastAdapter(fastAdapter).setOrder(i);
        }
        fastAdapter.cacheSizes();
        if (extensions != null) {
            for (IAdapterExtension<Item> extension : extensions) {
                fastAdapter.addExtension(extension);
            }
        }
        return fastAdapter;
    }

    public <A extends IAdapter<Item>> FastAdapter<Item> addAdapter(int index, A adapter) {
        this.mAdapters.add(index, adapter);
        adapter.withFastAdapter(this);
        adapter.mapPossibleTypes(adapter.getAdapterItems());
        for (int i = 0; i < this.mAdapters.size(); ++i) {
            this.mAdapters.get(i).setOrder(i);
        }
        this.cacheSizes();
        return this;
    }

    @Nullable
    public IAdapter<Item> adapter(int order) {
        if (this.mAdapters.size() <= order) {
            return null;
        }
        return this.mAdapters.get(order);
    }

    public <E extends IAdapterExtension<Item>> FastAdapter<Item> addExtension(E extension) {
        if (this.mExtensions.containsKey(extension.getClass())) {
            throw new IllegalStateException("The given extension was already registered with this FastAdapter instance");
        }
        this.mExtensions.put(extension.getClass(), extension);
        extension.init(this);
        return this;
    }

    public Collection<IAdapterExtension<Item>> getExtensions() {
        return this.mExtensions.values();
    }

    @Nullable
    public <T extends IAdapterExtension<Item>> T getExtension(Class<? super T> clazz) {
        return (T)this.mExtensions.get(clazz);
    }

    @Deprecated
    public FastAdapter<Item> withItemEvent(EventHook<Item> eventHook) {
        return this.withEventHook(eventHook);
    }

    public List<EventHook<Item>> getEventHooks() {
        return this.eventHooks;
    }

    public FastAdapter<Item> withEventHook(EventHook<Item> eventHook) {
        if (this.eventHooks == null) {
            this.eventHooks = new LinkedList<EventHook<Item>>();
        }
        this.eventHooks.add(eventHook);
        return this;
    }

    public FastAdapter<Item> withEventHooks(@Nullable Collection<? extends EventHook<Item>> eventHooks) {
        if (eventHooks == null) {
            return this;
        }
        if (this.eventHooks == null) {
            this.eventHooks = new LinkedList<EventHook<Item>>();
        }
        this.eventHooks.addAll(eventHooks);
        return this;
    }

    public FastAdapter<Item> withOnClickListener(OnClickListener<Item> onClickListener) {
        this.mOnClickListener = onClickListener;
        return this;
    }

    public OnClickListener<Item> getOnClickListener() {
        return this.mOnClickListener;
    }

    public FastAdapter<Item> withOnPreClickListener(OnClickListener<Item> onPreClickListener) {
        this.mOnPreClickListener = onPreClickListener;
        return this;
    }

    public FastAdapter<Item> withOnLongClickListener(OnLongClickListener<Item> onLongClickListener) {
        this.mOnLongClickListener = onLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnPreLongClickListener(OnLongClickListener<Item> onPreLongClickListener) {
        this.mOnPreLongClickListener = onPreLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnTouchListener(OnTouchListener<Item> onTouchListener) {
        this.mOnTouchListener = onTouchListener;
        return this;
    }

    public FastAdapter<Item> withOnCreateViewHolderListener(OnCreateViewHolderListener onCreateViewHolderListener) {
        this.mOnCreateViewHolderListener = onCreateViewHolderListener;
        return this;
    }

    public FastAdapter<Item> withOnBindViewHolderListener(OnBindViewHolderListener onBindViewHolderListener) {
        this.mOnBindViewHolderListener = onBindViewHolderListener;
        return this;
    }

    public FastAdapter<Item> withSelectWithItemUpdate(boolean selectWithItemUpdate) {
        this.mSelectExtension.withSelectWithItemUpdate(selectWithItemUpdate);
        return this;
    }

    public FastAdapter<Item> withMultiSelect(boolean multiSelect) {
        this.mSelectExtension.withMultiSelect(multiSelect);
        return this;
    }

    public FastAdapter<Item> withSelectOnLongClick(boolean selectOnLongClick) {
        this.mSelectExtension.withSelectOnLongClick(selectOnLongClick);
        return this;
    }

    public FastAdapter<Item> withAllowDeselection(boolean allowDeselection) {
        this.mSelectExtension.withAllowDeselection(allowDeselection);
        return this;
    }

    public FastAdapter<Item> withSelectable(boolean selectable) {
        if (selectable) {
            this.addExtension(this.mSelectExtension);
        } else {
            this.mExtensions.remove(this.mSelectExtension.getClass());
        }
        this.mSelectExtension.withSelectable(selectable);
        return this;
    }

    public FastAdapter<Item> withLegacyBindViewMode(boolean legacyBindViewMode) {
        this.mLegacyBindViewMode = legacyBindViewMode;
        return this;
    }

    public FastAdapter<Item> withAttachDefaultListeners(boolean mAttachDefaultListeners) {
        this.mAttachDefaultListeners = mAttachDefaultListeners;
        return this;
    }

    public FastAdapter<Item> withSelectionListener(ISelectionListener<Item> selectionListener) {
        this.mSelectExtension.withSelectionListener(selectionListener);
        return this;
    }

    public boolean isSelectable() {
        return this.mSelectExtension.isSelectable();
    }

    public FastAdapter<Item> withSavedInstanceState(Bundle savedInstanceState) {
        return this.withSavedInstanceState(savedInstanceState, "");
    }

    public FastAdapter<Item> withSavedInstanceState(@Nullable Bundle savedInstanceState, String prefix) {
        for (IAdapterExtension<Item> ext : this.mExtensions.values()) {
            ext.withSavedInstanceState(savedInstanceState, prefix);
        }
        return this;
    }

    public void registerTypeInstance(Item item) {
        if (this.getTypeInstanceCache().register(item) && item instanceof IHookable) {
            this.withEventHooks(((IHookable)item).getEventHooks());
        }
    }

    public Item getTypeInstance(int type) {
        return this.getTypeInstanceCache().get(type);
    }

    public void clearTypeInstance() {
        this.getTypeInstanceCache().clear();
    }

    public int getHolderAdapterPosition(@NonNull RecyclerView.ViewHolder holder) {
        return holder.getAdapterPosition();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onCreateViewHolder: " + viewType));
        }
        RecyclerView.ViewHolder holder = this.mOnCreateViewHolderListener.onPreCreateViewHolder(this, parent, viewType);
        holder.itemView.setTag(R.id.fastadapter_item_adapter, (Object)this);
        if (this.mAttachDefaultListeners) {
            EventHookUtil.attachToView(this.fastAdapterViewClickListener, holder, holder.itemView);
            EventHookUtil.attachToView(this.fastAdapterViewLongClickListener, holder, holder.itemView);
            EventHookUtil.attachToView(this.fastAdapterViewTouchListener, holder, holder.itemView);
        }
        return this.mOnCreateViewHolderListener.onPostCreateViewHolder(this, holder);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.mLegacyBindViewMode) {
            if (this.mVerbose) {
                Log.v((String)TAG, (String)("onBindViewHolderLegacy: " + position + "/" + holder.getItemViewType() + " isLegacy: true"));
            }
            holder.itemView.setTag(R.id.fastadapter_item_adapter, (Object)this);
            this.mOnBindViewHolderListener.onBindViewHolder(holder, position, Collections.EMPTY_LIST);
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        if (!this.mLegacyBindViewMode) {
            if (this.mVerbose) {
                Log.v((String)TAG, (String)("onBindViewHolder: " + position + "/" + holder.getItemViewType() + " isLegacy: false"));
            }
            holder.itemView.setTag(R.id.fastadapter_item_adapter, (Object)this);
            this.mOnBindViewHolderListener.onBindViewHolder(holder, position, payloads);
        }
        super.onBindViewHolder(holder, position, payloads);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onViewRecycled: " + holder.getItemViewType()));
        }
        super.onViewRecycled(holder);
        this.mOnBindViewHolderListener.unBindViewHolder(holder, holder.getAdapterPosition());
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onViewDetachedFromWindow: " + holder.getItemViewType()));
        }
        super.onViewDetachedFromWindow(holder);
        this.mOnBindViewHolderListener.onViewDetachedFromWindow(holder, holder.getAdapterPosition());
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onViewAttachedToWindow: " + holder.getItemViewType()));
        }
        super.onViewAttachedToWindow(holder);
        this.mOnBindViewHolderListener.onViewAttachedToWindow(holder, holder.getAdapterPosition());
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onFailedToRecycleView: " + holder.getItemViewType()));
        }
        return this.mOnBindViewHolderListener.onFailedToRecycleView(holder, holder.getAdapterPosition()) || super.onFailedToRecycleView(holder);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)"onAttachedToRecyclerView");
        }
        super.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)"onDetachedFromRecyclerView");
        }
        super.onDetachedFromRecyclerView(recyclerView);
    }

    public int getPosition(Item item) {
        if (item.getIdentifier() == -1L) {
            Log.e((String)TAG, (String)"You have to define an identifier for your item to retrieve the position via this method");
            return -1;
        }
        return this.getPosition(item.getIdentifier());
    }

    public int getPosition(long identifier) {
        int position = 0;
        for (IAdapter<Item> adapter : this.mAdapters) {
            if (adapter.getOrder() < 0) continue;
            int relativePosition = adapter.getAdapterPosition(identifier);
            if (relativePosition != -1) {
                return position + relativePosition;
            }
            position = adapter.getAdapterItemCount();
        }
        return -1;
    }

    public Item getItem(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        int index = FastAdapter.floorIndex(this.mAdapterSizes, position);
        return ((IAdapter)this.mAdapterSizes.valueAt(index)).getAdapterItem(position - this.mAdapterSizes.keyAt(index));
    }

    public Pair<Item, Integer> getItemById(final long identifier) {
        if (identifier == -1L) {
            return null;
        }
        Triple<Boolean, Item, Integer> result = this.recursive(new AdapterPredicate(){

            public boolean apply(@NonNull IAdapter lastParentAdapter, int lastParentPosition, @NonNull IItem item, int position) {
                return item.getIdentifier() == identifier;
            }
        }, true);
        if (result.second == null) {
            return null;
        }
        return new Pair(result.second, result.third);
    }

    public RelativeInfo<Item> getRelativeInfo(int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return new RelativeInfo();
        }
        RelativeInfo relativeInfo = new RelativeInfo();
        int index = FastAdapter.floorIndex(this.mAdapterSizes, position);
        if (index != -1) {
            relativeInfo.item = ((IAdapter)this.mAdapterSizes.valueAt(index)).getAdapterItem(position - this.mAdapterSizes.keyAt(index));
            relativeInfo.adapter = (IAdapter)this.mAdapterSizes.valueAt(index);
            relativeInfo.position = position;
        }
        return relativeInfo;
    }

    @Nullable
    public IAdapter<Item> getAdapter(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        if (this.mVerbose) {
            Log.v((String)TAG, (String)"getAdapter");
        }
        return (IAdapter)this.mAdapterSizes.valueAt(FastAdapter.floorIndex(this.mAdapterSizes, position));
    }

    public int getItemViewType(int position) {
        return this.getItem(position).getType();
    }

    public long getItemId(int position) {
        return this.getItem(position).getIdentifier();
    }

    public int getItemCount() {
        return this.mGlobalSize;
    }

    public int getPreItemCountByOrder(int order) {
        if (this.mGlobalSize == 0) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < Math.min(order, this.mAdapters.size()); ++i) {
            size += this.mAdapters.get(i).getAdapterItemCount();
        }
        return size;
    }

    public int getPreItemCount(int position) {
        if (this.mGlobalSize == 0) {
            return 0;
        }
        return this.mAdapterSizes.keyAt(FastAdapter.floorIndex(this.mAdapterSizes, position));
    }

    public Bundle saveInstanceState(@Nullable Bundle savedInstanceState) {
        return this.saveInstanceState(savedInstanceState, "");
    }

    public Bundle saveInstanceState(@Nullable Bundle savedInstanceState, String prefix) {
        for (IAdapterExtension<Item> ext : this.mExtensions.values()) {
            ext.saveInstanceState(savedInstanceState, prefix);
        }
        return savedInstanceState;
    }

    protected void cacheSizes() {
        this.mAdapterSizes.clear();
        int size = 0;
        for (IAdapter<Item> adapter : this.mAdapters) {
            if (adapter.getAdapterItemCount() <= 0) continue;
            this.mAdapterSizes.append(size, adapter);
            size += adapter.getAdapterItemCount();
        }
        if (size == 0 && this.mAdapters.size() > 0) {
            this.mAdapterSizes.append(0, this.mAdapters.get(0));
        }
        this.mGlobalSize = size;
    }

    public ClickEventHook<Item> getViewClickListener() {
        return this.fastAdapterViewClickListener;
    }

    public LongClickEventHook<Item> getViewLongClickListener() {
        return this.fastAdapterViewLongClickListener;
    }

    public TouchEventHook<Item> getViewTouchListener() {
        return this.fastAdapterViewTouchListener;
    }

    @Deprecated
    public SelectExtension<Item> getSelectExtension() {
        return this.mSelectExtension;
    }

    @Deprecated
    public Set<Integer> getSelections() {
        return this.mSelectExtension.getSelections();
    }

    @Deprecated
    public Set<Item> getSelectedItems() {
        return this.mSelectExtension.getSelectedItems();
    }

    @Deprecated
    public void toggleSelection(int position) {
        this.mSelectExtension.toggleSelection(position);
    }

    @Deprecated
    public void select(Iterable<Integer> positions) {
        this.mSelectExtension.select(positions);
    }

    @Deprecated
    public void select(int position) {
        this.mSelectExtension.select(position, false, false);
    }

    @Deprecated
    public void select(int position, boolean fireEvent) {
        this.mSelectExtension.select(position, fireEvent, false);
    }

    @Deprecated
    public void select(int position, boolean fireEvent, boolean considerSelectableFlag) {
        this.mSelectExtension.select(position, fireEvent, considerSelectableFlag);
    }

    @Deprecated
    public void deselect() {
        this.mSelectExtension.deselect();
    }

    @Deprecated
    public void select() {
        this.mSelectExtension.select(false);
    }

    @Deprecated
    public void select(boolean considerSelectableFlag) {
        this.mSelectExtension.select(considerSelectableFlag);
    }

    @Deprecated
    public void deselect(Iterable<Integer> positions) {
        this.mSelectExtension.deselect(positions);
    }

    @Deprecated
    public void deselect(int position) {
        this.mSelectExtension.deselect(position);
    }

    @Deprecated
    public void deselect(int position, Iterator<Integer> entries) {
        this.mSelectExtension.deselect(position, entries);
    }

    @Deprecated
    public List<Item> deleteAllSelectedItems() {
        return this.mSelectExtension.deleteAllSelectedItems();
    }

    public void notifyAdapterDataSetChanged() {
        for (IAdapterExtension<Item> ext : this.mExtensions.values()) {
            ext.notifyAdapterDataSetChanged();
        }
        this.cacheSizes();
        this.notifyDataSetChanged();
    }

    public void notifyAdapterItemInserted(int position) {
        this.notifyAdapterItemRangeInserted(position, 1);
    }

    public void notifyAdapterItemRangeInserted(int position, int itemCount) {
        for (IAdapterExtension<Item> ext : this.mExtensions.values()) {
            ext.notifyAdapterItemRangeInserted(position, itemCount);
        }
        this.cacheSizes();
        this.notifyItemRangeInserted(position, itemCount);
    }

    public void notifyAdapterItemRemoved(int position) {
        this.notifyAdapterItemRangeRemoved(position, 1);
    }

    public void notifyAdapterItemRangeRemoved(int position, int itemCount) {
        for (IAdapterExtension<Item> ext : this.mExtensions.values()) {
            ext.notifyAdapterItemRangeRemoved(position, itemCount);
        }
        this.cacheSizes();
        this.notifyItemRangeRemoved(position, itemCount);
    }

    public void notifyAdapterItemMoved(int fromPosition, int toPosition) {
        for (IAdapterExtension<Item> ext : this.mExtensions.values()) {
            ext.notifyAdapterItemMoved(fromPosition, toPosition);
        }
        this.notifyItemMoved(fromPosition, toPosition);
    }

    public void notifyAdapterItemChanged(int position) {
        this.notifyAdapterItemChanged(position, null);
    }

    public void notifyAdapterItemChanged(int position, @Nullable Object payload) {
        this.notifyAdapterItemRangeChanged(position, 1, payload);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount) {
        this.notifyAdapterItemRangeChanged(position, itemCount, null);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount, @Nullable Object payload) {
        for (IAdapterExtension<Item> ext : this.mExtensions.values()) {
            ext.notifyAdapterItemRangeChanged(position, itemCount, payload);
        }
        if (payload == null) {
            this.notifyItemRangeChanged(position, itemCount);
        } else {
            this.notifyItemRangeChanged(position, itemCount, payload);
        }
    }

    public static <Item extends IItem> Item getHolderAdapterItem(@Nullable RecyclerView.ViewHolder holder) {
        FastAdapter fastAdapter;
        int pos;
        Object tag;
        if (holder != null && (tag = holder.itemView.getTag(R.id.fastadapter_item_adapter)) instanceof FastAdapter && (pos = (fastAdapter = (FastAdapter)((Object)tag)).getHolderAdapterPosition(holder)) != -1) {
            return fastAdapter.getItem(pos);
        }
        return null;
    }

    public static <Item extends IItem> Item getHolderAdapterItem(@Nullable RecyclerView.ViewHolder holder, int position) {
        Object tag;
        if (holder != null && (tag = holder.itemView.getTag(R.id.fastadapter_item_adapter)) instanceof FastAdapter) {
            return ((FastAdapter)((Object)tag)).getItem(position);
        }
        return null;
    }

    @NonNull
    public Triple<Boolean, Item, Integer> recursive(AdapterPredicate<Item> predicate, boolean stopOnMatch) {
        return this.recursive(predicate, 0, stopOnMatch);
    }

    @NonNull
    public Triple<Boolean, Item, Integer> recursive(AdapterPredicate<Item> predicate, int globalStartPosition, boolean stopOnMatch) {
        for (int i = globalStartPosition; i < this.getItemCount(); ++i) {
            RelativeInfo<Item> relativeInfo = this.getRelativeInfo(i);
            Object item = relativeInfo.item;
            if (predicate.apply(relativeInfo.adapter, i, item, i) && stopOnMatch) {
                return new Triple(true, item, i);
            }
            if (!(item instanceof IExpandable)) continue;
            Triple res = FastAdapter.recursiveSub(relativeInfo.adapter, i, (IExpandable)item, predicate, stopOnMatch);
            if (!((Boolean)res.first).booleanValue() || !stopOnMatch) continue;
            return res;
        }
        return new Triple<Boolean, Object, Object>(false, null, null);
    }

    public static <Item extends IItem> Triple<Boolean, Item, Integer> recursiveSub(IAdapter<Item> lastParentAdapter, int lastParentPosition, IExpandable parent, AdapterPredicate<Item> predicate, boolean stopOnMatch) {
        if (!parent.isExpanded() && parent.getSubItems() != null) {
            for (int ii = 0; ii < parent.getSubItems().size(); ++ii) {
                IItem sub = (IItem)parent.getSubItems().get(ii);
                if (predicate.apply(lastParentAdapter, lastParentPosition, sub, -1) && stopOnMatch) {
                    return new Triple<Boolean, IItem, Object>(true, sub, null);
                }
                if (!(sub instanceof IExpandable)) continue;
                Triple<Boolean, Item, Integer> res = FastAdapter.recursiveSub(lastParentAdapter, lastParentPosition, (IExpandable)((Object)sub), predicate, stopOnMatch);
                if (!((Boolean)res.first).booleanValue()) continue;
                return res;
            }
        }
        return new Triple<Boolean, Object, Object>(false, null, null);
    }

    public static abstract class ViewHolder<Item extends IItem>
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }

        public abstract void bindView(Item var1, List<Object> var2);

        public abstract void unbindView(Item var1);

        public void attachToWindow(Item item) {
        }

        public void detachFromWindow(Item item) {
        }

        public boolean failedToRecycle(Item item) {
            return false;
        }
    }

    public static class RelativeInfo<Item extends IItem> {
        public IAdapter<Item> adapter = null;
        public Item item = null;
        public int position = -1;
    }
}

