/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.select;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.util.ArraySet;
import android.view.MotionEvent;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IAdapterExtension;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.ISelectionListener;
import com.mikepenz.fastadapter.ISubItem;
import com.mikepenz.fastadapter.utils.AdapterPredicate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class SelectExtension<Item extends IItem>
implements IAdapterExtension<Item> {
    protected static final String BUNDLE_SELECTIONS = "bundle_selections";
    private FastAdapter<Item> mFastAdapter;
    private boolean mSelectWithItemUpdate = false;
    private boolean mMultiSelect = false;
    private boolean mSelectOnLongClick = false;
    private boolean mAllowDeselection = true;
    private boolean mSelectable = false;
    private ISelectionListener<Item> mSelectionListener;

    public SelectExtension<Item> withSelectWithItemUpdate(boolean selectWithItemUpdate) {
        this.mSelectWithItemUpdate = selectWithItemUpdate;
        return this;
    }

    public SelectExtension<Item> withMultiSelect(boolean multiSelect) {
        this.mMultiSelect = multiSelect;
        return this;
    }

    public SelectExtension<Item> withSelectOnLongClick(boolean selectOnLongClick) {
        this.mSelectOnLongClick = selectOnLongClick;
        return this;
    }

    public SelectExtension<Item> withAllowDeselection(boolean allowDeselection) {
        this.mAllowDeselection = allowDeselection;
        return this;
    }

    public SelectExtension<Item> withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return this;
    }

    public boolean isSelectable() {
        return this.mSelectable;
    }

    public SelectExtension<Item> withSelectionListener(ISelectionListener<Item> selectionListener) {
        this.mSelectionListener = selectionListener;
        return this;
    }

    @Override
    public IAdapterExtension<Item> init(FastAdapter<Item> fastAdapter) {
        this.mFastAdapter = fastAdapter;
        return null;
    }

    @Override
    public void withSavedInstanceState(@Nullable Bundle savedInstanceState, String prefix) {
        if (savedInstanceState == null) {
            return;
        }
        long[] selectedItems = savedInstanceState.getLongArray(BUNDLE_SELECTIONS + prefix);
        if (selectedItems != null) {
            for (long id2 : selectedItems) {
                this.selectByIdentifier(id2, false, true);
            }
        }
    }

    @Override
    public void saveInstanceState(@Nullable Bundle savedInstanceState, String prefix) {
        if (savedInstanceState == null) {
            return;
        }
        Set<Item> selections = this.mFastAdapter.getSelectedItems();
        long[] selectionsArray = new long[selections.size()];
        int i = 0;
        for (IItem item : selections) {
            selectionsArray[i] = item.getIdentifier();
            ++i;
        }
        savedInstanceState.putLongArray(BUNDLE_SELECTIONS + prefix, selectionsArray);
    }

    @Override
    public boolean onClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
        if (!this.mSelectOnLongClick && this.mSelectable) {
            this.handleSelection(v, item, pos);
        }
        return false;
    }

    @Override
    public boolean onLongClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
        if (this.mSelectOnLongClick && this.mSelectable) {
            this.handleSelection(v, item, pos);
        }
        return false;
    }

    @Override
    public boolean onTouch(View v, MotionEvent event, int position, FastAdapter<Item> fastAdapter, Item item) {
        return false;
    }

    @Override
    public void notifyAdapterDataSetChanged() {
    }

    @Override
    public void notifyAdapterItemRangeInserted(int position, int itemCount) {
    }

    @Override
    public void notifyAdapterItemRangeRemoved(int position, int itemCount) {
    }

    @Override
    public void notifyAdapterItemMoved(int fromPosition, int toPosition) {
    }

    @Override
    public void notifyAdapterItemRangeChanged(int position, int itemCount, @Nullable Object payload) {
    }

    @Override
    public void set(List<Item> items, boolean resetFilter) {
    }

    @Override
    public void performFiltering(CharSequence constraint) {
    }

    public Set<Integer> getSelections() {
        ArraySet selections = new ArraySet();
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!this.mFastAdapter.getItem(i).isSelected()) continue;
            selections.add(i);
        }
        return selections;
    }

    public Set<Item> getSelectedItems() {
        ArraySet items = new ArraySet();
        this.mFastAdapter.recursive(new AdapterPredicate<Item>((Set)items){
            final /* synthetic */ Set val$items;
            {
                this.val$items = set;
            }

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                if (item.isSelected()) {
                    this.val$items.add(item);
                }
                return false;
            }
        }, false);
        return items;
    }

    public void toggleSelection(int position) {
        if (this.mFastAdapter.getItem(position).isSelected()) {
            this.deselect(position);
        } else {
            this.select(position);
        }
    }

    private void handleSelection(@Nullable View view, Item item, int position) {
        if (!item.isSelectable()) {
            return;
        }
        if (item.isSelected() && !this.mAllowDeselection) {
            return;
        }
        boolean selected = item.isSelected();
        if (this.mSelectWithItemUpdate || view == null) {
            if (!this.mMultiSelect) {
                this.deselect();
            }
            if (selected) {
                this.deselect(position);
            } else {
                this.select(position);
            }
        } else {
            if (!this.mMultiSelect) {
                Set<Item> selections = this.getSelectedItems();
                selections.remove(item);
                this.deselectByItems(selections);
            }
            item.withSetSelected(!selected);
            view.setSelected(!selected);
            if (this.mSelectionListener != null) {
                this.mSelectionListener.onSelectionChanged(item, !selected);
            }
        }
    }

    public void select() {
        this.select(false);
    }

    public void select(final boolean considerSelectableFlag) {
        this.mFastAdapter.recursive(new AdapterPredicate<Item>(){

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                SelectExtension.this.select(lastParentAdapter, item, -1, false, considerSelectableFlag);
                return false;
            }
        }, false);
        this.mFastAdapter.notifyDataSetChanged();
    }

    public void select(Item item, boolean considerSelectableFlag) {
        if (considerSelectableFlag && !item.isSelectable()) {
            return;
        }
        item.withSetSelected(true);
        if (this.mSelectionListener != null) {
            this.mSelectionListener.onSelectionChanged(item, true);
        }
    }

    public void select(Iterable<Integer> positions) {
        for (Integer position : positions) {
            this.select(position);
        }
    }

    public void select(int position) {
        this.select(position, false);
    }

    public void select(int position, boolean fireEvent) {
        this.select(position, fireEvent, false);
    }

    public void select(int position, boolean fireEvent, boolean considerSelectableFlag) {
        FastAdapter.RelativeInfo<Item> relativeInfo = this.mFastAdapter.getRelativeInfo(position);
        if (relativeInfo == null || relativeInfo.item == null) {
            return;
        }
        this.select(relativeInfo.adapter, relativeInfo.item, position, fireEvent, considerSelectableFlag);
    }

    public void select(IAdapter<Item> adapter, Item item, int position, boolean fireEvent, boolean considerSelectableFlag) {
        if (considerSelectableFlag && !item.isSelectable()) {
            return;
        }
        item.withSetSelected(true);
        this.mFastAdapter.notifyItemChanged(position);
        if (this.mSelectionListener != null) {
            this.mSelectionListener.onSelectionChanged(item, true);
        }
        if (this.mFastAdapter.getOnClickListener() != null && fireEvent) {
            this.mFastAdapter.getOnClickListener().onClick(null, adapter, item, position);
        }
    }

    public void selectByIdentifier(final long identifier, final boolean fireEvent, final boolean considerSelectableFlag) {
        this.mFastAdapter.recursive(new AdapterPredicate<Item>(){

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                if (item.getIdentifier() == identifier) {
                    SelectExtension.this.select(lastParentAdapter, item, position, fireEvent, considerSelectableFlag);
                    return true;
                }
                return false;
            }
        }, true);
    }

    public void selectByIdentifiers(final Set<Long> identifiers, final boolean fireEvent, final boolean considerSelectableFlag) {
        this.mFastAdapter.recursive(new AdapterPredicate<Item>(){

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                if (identifiers.contains(item.getIdentifier())) {
                    SelectExtension.this.select(lastParentAdapter, item, position, fireEvent, considerSelectableFlag);
                }
                return false;
            }
        }, false);
    }

    public void deselect() {
        this.mFastAdapter.recursive(new AdapterPredicate<Item>(){

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                SelectExtension.this.deselect(item);
                return false;
            }
        }, false);
        this.mFastAdapter.notifyDataSetChanged();
    }

    public void deselect(Item item) {
        this.deselect(item, -1, null);
    }

    public void deselect(Iterable<Integer> positions) {
        Iterator<Integer> entries = positions.iterator();
        while (entries.hasNext()) {
            this.deselect(entries.next(), entries);
        }
    }

    public void deselect(int position) {
        this.deselect(position, null);
    }

    public void deselect(int position, @Nullable Iterator<Integer> entries) {
        Item item = this.mFastAdapter.getItem(position);
        if (item == null) {
            return;
        }
        this.deselect(item, position, entries);
    }

    public void deselect(Item item, int position, @Nullable Iterator<Integer> entries) {
        item.withSetSelected(false);
        if (entries != null) {
            entries.remove();
        }
        if (position >= 0) {
            this.mFastAdapter.notifyItemChanged(position);
        }
        if (this.mSelectionListener != null) {
            this.mSelectionListener.onSelectionChanged(item, false);
        }
    }

    public void deselectByIdentifier(final long identifier) {
        this.mFastAdapter.recursive(new AdapterPredicate<Item>(){

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                if (item.getIdentifier() == identifier) {
                    SelectExtension.this.deselect(item, position, null);
                    return true;
                }
                return false;
            }
        }, true);
    }

    public void deselectByIdentifiers(final Set<Long> identifiers) {
        this.mFastAdapter.recursive(new AdapterPredicate<Item>(){

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                if (identifiers.contains(item.getIdentifier())) {
                    SelectExtension.this.deselect(item, position, null);
                }
                return false;
            }
        }, false);
    }

    public void deselectByItems(final Set<Item> items) {
        this.mFastAdapter.recursive(new AdapterPredicate<Item>(){

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                if (items.contains(item)) {
                    SelectExtension.this.deselect(item, position, null);
                }
                return false;
            }
        }, false);
    }

    public List<Item> deleteAllSelectedItems() {
        ArrayList deletedItems = new ArrayList();
        final ArrayList positions = new ArrayList();
        this.mFastAdapter.recursive(new AdapterPredicate<Item>(){

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                if (item.isSelected()) {
                    IExpandable parent;
                    if (item instanceof ISubItem && (parent = (IExpandable)((ISubItem)item).getParent()) != null) {
                        parent.getSubItems().remove(item);
                    }
                    if (position != -1) {
                        positions.add(position);
                    }
                }
                return false;
            }
        }, false);
        for (int i = positions.size() - 1; i >= 0; --i) {
            FastAdapter.RelativeInfo<Item> ri = this.mFastAdapter.getRelativeInfo((Integer)positions.get(i));
            if (ri.item == null || !ri.item.isSelected() || ri.adapter == null || !(ri.adapter instanceof IItemAdapter)) continue;
            ((IItemAdapter)ri.adapter).remove((Integer)positions.get(i));
        }
        return deletedItems;
    }
}

