/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import android.support.annotation.NonNull;
import com.mikepenz.fastadapter.AbstractAdapter;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IAdapterExtension;
import com.mikepenz.fastadapter.IAdapterNotifier;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IIdDistributor;
import com.mikepenz.fastadapter.IInterceptor;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.IItemList;
import com.mikepenz.fastadapter.IModelItem;
import com.mikepenz.fastadapter.ISubItem;
import com.mikepenz.fastadapter.adapters.ItemFilter;
import com.mikepenz.fastadapter.utils.AdapterPredicate;
import com.mikepenz.fastadapter.utils.DefaultItemList;
import com.mikepenz.fastadapter.utils.DefaultItemListImpl;
import com.mikepenz.fastadapter.utils.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class ModelAdapter<Model, Item extends IItem>
extends AbstractAdapter<Item>
implements IItemAdapter<Model, Item> {
    private final IItemList<Item> mItems;
    private IInterceptor<Model, Item> mInterceptor;
    private IInterceptor<Item, Model> mReverseInterceptor;
    private IIdDistributor<Item> mIdDistributor;
    private boolean mUseIdDistributor = true;
    private ItemFilter<Model, Item> mItemFilter = new ItemFilter(this);

    public ModelAdapter(IInterceptor<Model, Item> interceptor) {
        this(new DefaultItemListImpl(), interceptor);
    }

    public ModelAdapter(IItemList<Item> itemList, IInterceptor<Model, Item> interceptor) {
        this.mInterceptor = interceptor;
        this.mItems = itemList;
    }

    @Override
    public AbstractAdapter<Item> withFastAdapter(FastAdapter<Item> fastAdapter) {
        if (this.mItems instanceof DefaultItemList) {
            ((DefaultItemList)this.mItems).setFastAdapter(fastAdapter);
        }
        return super.withFastAdapter((FastAdapter)fastAdapter);
    }

    public IItemList<Item> getItemList() {
        return this.mItems;
    }

    public static <Model, Item extends IItem> ModelAdapter<Model, Item> models(IInterceptor<Model, Item> interceptor) {
        return new ModelAdapter<Model, Item>(interceptor);
    }

    public IInterceptor<Model, Item> getInterceptor() {
        return this.mInterceptor;
    }

    public ModelAdapter<Model, Item> withInterceptor(IInterceptor<Model, Item> mInterceptor) {
        this.mInterceptor = mInterceptor;
        return this;
    }

    public IInterceptor<Item, Model> getReverseInterceptor() {
        return this.mReverseInterceptor;
    }

    public ModelAdapter<Model, Item> withReverseInterceptor(IInterceptor<Item, Model> reverseInterceptor) {
        this.mReverseInterceptor = reverseInterceptor;
        return this;
    }

    @Nullable
    public Item intercept(Model model) {
        return (Item)((IItem)this.mInterceptor.intercept(model));
    }

    public List<Item> intercept(List<Model> models) {
        ArrayList<Item> items = new ArrayList<Item>(models.size());
        for (Model model : models) {
            Item item = this.intercept(model);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public ModelAdapter<Model, Item> withIdDistributor(IIdDistributor<Item> idDistributor) {
        this.mIdDistributor = idDistributor;
        return this;
    }

    public IIdDistributor<Item> getIdDistributor() {
        if (this.mIdDistributor == null) {
            return IIdDistributor.DEFAULT;
        }
        return this.mIdDistributor;
    }

    public ModelAdapter<Model, Item> withUseIdDistributor(boolean useIdDistributor) {
        this.mUseIdDistributor = useIdDistributor;
        return this;
    }

    public boolean isUseIdDistributor() {
        return this.mUseIdDistributor;
    }

    public ModelAdapter<Model, Item> withItemFilter(ItemFilter<Model, Item> itemFilter) {
        this.mItemFilter = itemFilter;
        return this;
    }

    public ItemFilter<Model, Item> getItemFilter() {
        return this.mItemFilter;
    }

    public void filter(@Nullable CharSequence constraint) {
        this.mItemFilter.filter(constraint);
    }

    public List<Model> getModels() {
        ArrayList list = new ArrayList(this.mItems.size());
        for (IItem item : this.mItems.getItems()) {
            if (this.mReverseInterceptor != null) {
                list.add(this.mReverseInterceptor.intercept(item));
                continue;
            }
            if (item instanceof IModelItem) {
                list.add(((IModelItem)item).getModel());
                continue;
            }
            throw new RuntimeException("to get the list of models, the item either needs to implement `IModelItem` or you have to provide a `reverseInterceptor`");
        }
        return list;
    }

    @Override
    public int getAdapterItemCount() {
        return this.mItems.size();
    }

    @Override
    public List<Item> getAdapterItems() {
        return this.mItems.getItems();
    }

    @Override
    public int getAdapterPosition(Item item) {
        return this.getAdapterPosition(item.getIdentifier());
    }

    @Override
    public int getAdapterPosition(long identifier) {
        return this.mItems.getAdapterPosition(identifier);
    }

    @Override
    public int getGlobalPosition(int position) {
        return position + this.getFastAdapter().getPreItemCountByOrder(this.getOrder());
    }

    @Override
    public Item getAdapterItem(int position) {
        return (Item)((IItem)this.mItems.get(position));
    }

    @Override
    public ModelAdapter<Model, Item> set(List<Model> items) {
        return this.set(items, true);
    }

    protected ModelAdapter<Model, Item> set(List<Model> list, boolean resetFilter) {
        List<Item> items = this.intercept(list);
        return this.setInternal(items, resetFilter, null);
    }

    public ModelAdapter<Model, Item> set(List<Model> list, boolean resetFilter, @Nullable IAdapterNotifier adapterNotifier) {
        List<Item> items = this.intercept(list);
        return this.setInternal(items, resetFilter, adapterNotifier);
    }

    public ModelAdapter<Model, Item> setInternal(List<Item> items, boolean resetFilter, @Nullable IAdapterNotifier adapterNotifier) {
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkIds(items);
        }
        if (resetFilter && this.getItemFilter().getConstraint() != null) {
            this.getItemFilter().performFiltering(null);
        }
        for (IAdapterExtension<Item> ext : this.getFastAdapter().getExtensions()) {
            ext.set(items, resetFilter);
        }
        this.mapPossibleTypes(items);
        int itemsBeforeThisAdapter = this.getFastAdapter().getPreItemCountByOrder(this.getOrder());
        this.mItems.set(items, itemsBeforeThisAdapter, adapterNotifier);
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> setNewList(List<Model> items) {
        return this.setNewList(items, false);
    }

    public ModelAdapter<Model, Item> setNewList(List<Model> list, boolean retainFilter) {
        boolean publishResults;
        List<Item> items = this.intercept(list);
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkIds(items);
        }
        CharSequence filter = null;
        if (this.getItemFilter().getConstraint() != null) {
            filter = this.getItemFilter().getConstraint();
            this.getItemFilter().performFiltering(null);
        }
        this.mapPossibleTypes(items);
        boolean bl = publishResults = filter != null && retainFilter;
        if (publishResults) {
            this.getItemFilter().publishResults(filter, this.getItemFilter().performFiltering(filter));
        }
        this.mItems.setNewList(items, !publishResults);
        return this;
    }

    public void remapMappedTypes() {
        this.getFastAdapter().clearTypeInstance();
        this.mapPossibleTypes(this.mItems.getItems());
    }

    @Override
    @SafeVarargs
    public final ModelAdapter<Model, Item> add(Model ... items) {
        return this.add((List)Arrays.asList(items));
    }

    @Override
    public ModelAdapter<Model, Item> add(List<Model> list) {
        List<Item> items = this.intercept(list);
        return this.addInternal((List)items);
    }

    @Override
    public ModelAdapter<Model, Item> addInternal(List<Item> items) {
        FastAdapter fastAdapter;
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkIds(items);
        }
        if ((fastAdapter = this.getFastAdapter()) != null) {
            this.mItems.addAll(items, fastAdapter.getPreItemCountByOrder(this.getOrder()));
        } else {
            this.mItems.addAll(items, 0);
        }
        this.mapPossibleTypes(items);
        return this;
    }

    @Override
    @SafeVarargs
    public final ModelAdapter<Model, Item> add(int position, Model ... items) {
        return this.add(position, (List)Arrays.asList(items));
    }

    @Override
    public ModelAdapter<Model, Item> add(int position, List<Model> list) {
        List<Item> items = this.intercept(list);
        return this.addInternal(position, (List)items);
    }

    @Override
    public ModelAdapter<Model, Item> addInternal(int position, List<Item> items) {
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkIds(items);
        }
        if (items.size() > 0) {
            this.mItems.addAll(position, items, this.getFastAdapter().getPreItemCountByOrder(this.getOrder()));
            this.mapPossibleTypes(items);
        }
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> set(int position, Model element) {
        Item item = this.intercept(element);
        if (item == null) {
            return this;
        }
        return this.setInternal(position, (IItem)item);
    }

    @Override
    public ModelAdapter<Model, Item> setInternal(int position, Item item) {
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkId(item);
        }
        this.mItems.set(position, item, this.getFastAdapter().getPreItemCount(position));
        this.mFastAdapter.registerTypeInstance(item);
        return this;
    }

    public ModelAdapter<Model, Item> move(int fromPosition, int toPosition) {
        this.mItems.move(fromPosition, toPosition, this.getFastAdapter().getPreItemCount(fromPosition));
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> remove(int position) {
        this.mItems.remove(position, this.getFastAdapter().getPreItemCount(position));
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> removeRange(int position, int itemCount) {
        this.mItems.removeRange(position, itemCount, this.getFastAdapter().getPreItemCount(position));
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> clear() {
        this.mItems.clear(this.getFastAdapter().getPreItemCountByOrder(this.getOrder()));
        return this;
    }

    public ModelAdapter<Model, Item> removeByIdentifier(final long identifier) {
        this.recursive(new AdapterPredicate<Item>(){

            @Override
            public boolean apply(@NonNull IAdapter<Item> lastParentAdapter, int lastParentPosition, Item item, int position) {
                if (identifier == item.getIdentifier()) {
                    IExpandable parent;
                    if (item instanceof ISubItem && (parent = (IExpandable)((ISubItem)item).getParent()) != null) {
                        parent.getSubItems().remove(item);
                    }
                    if (position != -1) {
                        ModelAdapter.this.remove(position);
                    }
                }
                return false;
            }
        }, false);
        return this;
    }

    @NonNull
    public Triple<Boolean, Item, Integer> recursive(AdapterPredicate<Item> predicate, boolean stopOnMatch) {
        int preItemCount = this.getFastAdapter().getPreItemCountByOrder(this.getOrder());
        for (int i = 0; i < this.getAdapterItemCount(); ++i) {
            int globalPosition = i + preItemCount;
            FastAdapter.RelativeInfo relativeInfo = this.getFastAdapter().getRelativeInfo(globalPosition);
            Object item = relativeInfo.item;
            if (predicate.apply(relativeInfo.adapter, globalPosition, item, globalPosition) && stopOnMatch) {
                return new Triple(true, item, globalPosition);
            }
            if (!(item instanceof IExpandable)) continue;
            Triple res = FastAdapter.recursiveSub(relativeInfo.adapter, globalPosition, (IExpandable)item, predicate, stopOnMatch);
            if (!((Boolean)res.first).booleanValue() || !stopOnMatch) continue;
            return res;
        }
        return new Triple<Boolean, Object, Object>(false, null, null);
    }
}

