/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.select;

import android.os.Bundle;
import android.support.v4.util.ArraySet;
import android.view.MotionEvent;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IAdapterExtension;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.ISelectionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class SelectExtension<Item extends IItem>
implements IAdapterExtension<Item> {
    protected static final String BUNDLE_SELECTIONS = "bundle_selections";
    private FastAdapter<Item> mFastAdapter;
    private boolean mSelectWithItemUpdate = false;
    private boolean mMultiSelect = false;
    private boolean mSelectOnLongClick = false;
    private boolean mAllowDeselection = true;
    private boolean mSelectable = false;
    private ISelectionListener<Item> mSelectionListener;

    public SelectExtension<Item> withSelectWithItemUpdate(boolean selectWithItemUpdate) {
        this.mSelectWithItemUpdate = selectWithItemUpdate;
        return this;
    }

    public SelectExtension<Item> withMultiSelect(boolean multiSelect) {
        this.mMultiSelect = multiSelect;
        return this;
    }

    public SelectExtension<Item> withSelectOnLongClick(boolean selectOnLongClick) {
        this.mSelectOnLongClick = selectOnLongClick;
        return this;
    }

    public SelectExtension<Item> withAllowDeselection(boolean allowDeselection) {
        this.mAllowDeselection = allowDeselection;
        return this;
    }

    public SelectExtension<Item> withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return this;
    }

    public boolean isSelectable() {
        return this.mSelectable;
    }

    public SelectExtension<Item> withSelectionListener(ISelectionListener<Item> selectionListener) {
        this.mSelectionListener = selectionListener;
        return this;
    }

    @Override
    public IAdapterExtension<Item> init(FastAdapter<Item> fastAdapter) {
        this.mFastAdapter = fastAdapter;
        return null;
    }

    @Override
    public void withSavedInstanceState(@Nullable Bundle savedInstanceState, String prefix) {
        if (savedInstanceState == null) {
            return;
        }
        ArrayList selectedItems = savedInstanceState.getStringArrayList(BUNDLE_SELECTIONS + prefix);
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item item = this.mFastAdapter.getItem(i);
            String id2 = String.valueOf(item.getIdentifier());
            if (selectedItems == null || !selectedItems.contains(id2)) continue;
            this.select(item, true);
        }
        this.notifyAdapterDataSetChanged();
    }

    @Override
    public void saveInstanceState(@Nullable Bundle savedInstanceState, String prefix) {
        if (savedInstanceState == null) {
            return;
        }
        ArrayList<String> selections = new ArrayList<String>();
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item item = this.mFastAdapter.getItem(i);
            if (!item.isSelected()) continue;
            selections.add(String.valueOf(item.getIdentifier()));
        }
        savedInstanceState.putStringArrayList(BUNDLE_SELECTIONS + prefix, selections);
    }

    @Override
    public boolean onClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
        if (!this.mSelectOnLongClick && this.mSelectable) {
            this.handleSelection(v, item, pos);
        }
        return false;
    }

    @Override
    public boolean onLongClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
        if (this.mSelectOnLongClick && this.mSelectable) {
            this.handleSelection(v, item, pos);
        }
        return false;
    }

    @Override
    public boolean onTouch(View v, MotionEvent event, int position, FastAdapter<Item> fastAdapter, Item item) {
        return false;
    }

    @Override
    public void notifyAdapterDataSetChanged() {
    }

    @Override
    public void notifyAdapterItemRangeInserted(int position, int itemCount) {
    }

    @Override
    public void notifyAdapterItemRangeRemoved(int position, int itemCount) {
    }

    @Override
    public void notifyAdapterItemMoved(int fromPosition, int toPosition) {
    }

    @Override
    public void notifyAdapterItemRangeChanged(int position, int itemCount, @Nullable Object payload) {
    }

    @Override
    public void set(List<Item> items, boolean resetFilter) {
    }

    @Override
    public void performFiltering(CharSequence constraint) {
    }

    public Set<Integer> getSelections() {
        ArraySet selections = new ArraySet();
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!this.mFastAdapter.getItem(i).isSelected()) continue;
            selections.add(i);
        }
        return selections;
    }

    public Set<Item> getSelectedItems() {
        ArraySet items = new ArraySet();
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item item = this.mFastAdapter.getItem(i);
            if (!item.isSelected()) continue;
            items.add(item);
        }
        return items;
    }

    public void toggleSelection(int position) {
        if (this.mFastAdapter.getItem(position).isSelected()) {
            this.deselect(position);
        } else {
            this.select(position);
        }
    }

    private void handleSelection(@Nullable View view, Item item, int position) {
        if (!item.isSelectable()) {
            return;
        }
        if (item.isSelected() && !this.mAllowDeselection) {
            return;
        }
        boolean selected = item.isSelected();
        if (this.mSelectWithItemUpdate || view == null) {
            if (!this.mMultiSelect) {
                this.deselect();
            }
            if (selected) {
                this.deselect(position);
            } else {
                this.select(position);
            }
        } else {
            if (!this.mMultiSelect) {
                Set<Integer> selections = this.getSelections();
                for (int pos : selections) {
                    if (pos == position) continue;
                    this.deselect(pos);
                }
            }
            item.withSetSelected(!selected);
            view.setSelected(!selected);
            if (this.mSelectionListener != null) {
                this.mSelectionListener.onSelectionChanged(item, !selected);
            }
        }
    }

    public void select(Iterable<Integer> positions) {
        for (Integer position : positions) {
            this.select(position);
        }
    }

    public void select(int position) {
        this.select(position, false);
    }

    public void select(int position, boolean fireEvent) {
        this.select(position, fireEvent, false);
    }

    public void select(int position, boolean fireEvent, boolean considerSelectableFlag) {
        Item item = this.mFastAdapter.getItem(position);
        if (item == null) {
            return;
        }
        if (considerSelectableFlag && !item.isSelectable()) {
            return;
        }
        item.withSetSelected(true);
        this.mFastAdapter.notifyItemChanged(position);
        if (this.mSelectionListener != null) {
            this.mSelectionListener.onSelectionChanged(item, true);
        }
        if (this.mFastAdapter.getOnClickListener() != null && fireEvent) {
            this.mFastAdapter.getOnClickListener().onClick(null, this.mFastAdapter.getAdapter(position), item, position);
        }
    }

    public void deselect() {
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item item = this.mFastAdapter.getItem(i);
            this.deselect(item);
        }
        this.mFastAdapter.notifyDataSetChanged();
    }

    public void deselect(Item item) {
        if (item.isSelected()) {
            item.withSetSelected(false);
            if (this.mSelectionListener != null) {
                this.mSelectionListener.onSelectionChanged(item, false);
            }
        }
    }

    public void select() {
        this.select(false);
    }

    public void select(boolean considerSelectableFlag) {
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item item = this.mFastAdapter.getItem(i);
            this.select(item, considerSelectableFlag);
        }
        this.mFastAdapter.notifyDataSetChanged();
    }

    public void select(Item item, boolean considerSelectableFlag) {
        if (considerSelectableFlag && !item.isSelectable()) {
            return;
        }
        item.withSetSelected(true);
        if (this.mSelectionListener != null) {
            this.mSelectionListener.onSelectionChanged(item, true);
        }
    }

    public void deselect(Iterable<Integer> positions) {
        Iterator<Integer> entries = positions.iterator();
        while (entries.hasNext()) {
            this.deselect(entries.next(), entries);
        }
    }

    public void deselect(int position) {
        this.deselect(position, null);
    }

    public void deselect(int position, @Nullable Iterator<Integer> entries) {
        Item item = this.mFastAdapter.getItem(position);
        if (item != null) {
            item.withSetSelected(false);
        }
        if (entries != null) {
            entries.remove();
        }
        this.mFastAdapter.notifyItemChanged(position);
        if (this.mSelectionListener != null) {
            this.mSelectionListener.onSelectionChanged(item, false);
        }
    }

    public List<Item> deleteAllSelectedItems() {
        ArrayList deletedItems = new ArrayList();
        for (int i = this.mFastAdapter.getItemCount() - 1; i >= 0; --i) {
            FastAdapter.RelativeInfo<Item> ri = this.mFastAdapter.getRelativeInfo(i);
            if (!ri.item.isSelected() || ri.adapter == null || !(ri.adapter instanceof IItemAdapter)) continue;
            ((IItemAdapter)ri.adapter).remove(i);
        }
        return deletedItems;
    }
}

