/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import com.mikepenz.fastadapter.AbstractAdapter;
import com.mikepenz.fastadapter.IAdapterExtension;
import com.mikepenz.fastadapter.IAdapterNotifier;
import com.mikepenz.fastadapter.IIdDistributor;
import com.mikepenz.fastadapter.IInterceptor;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.adapters.ItemFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class ModelAdapter<Model, Item extends IItem>
extends AbstractAdapter<Item>
implements IItemAdapter<Model, Item> {
    private List<Item> mItems = new ArrayList<Item>();
    private IInterceptor<Model, Item> mInterceptor;
    private IInterceptor<Item, Model> mReverseInterceptor;
    private IIdDistributor<Item> mIdDistributor;
    private boolean mUseIdDistributor = true;
    private ItemFilter<Model, Item> mItemFilter = new ItemFilter(this);
    protected Comparator<Item> mComparator;

    public ModelAdapter(IInterceptor<Model, Item> interceptor) {
        this.mInterceptor = interceptor;
    }

    public static <Model, Item extends IItem> ModelAdapter<Model, Item> models(IInterceptor<Model, Item> interceptor) {
        return new ModelAdapter<Model, Item>(interceptor);
    }

    public IInterceptor<Model, Item> getInterceptor() {
        return this.mInterceptor;
    }

    public ModelAdapter<Model, Item> withInterceptor(IInterceptor<Model, Item> mInterceptor) {
        this.mInterceptor = mInterceptor;
        return this;
    }

    public IInterceptor<Item, Model> getReverseInterceptor() {
        return this.mReverseInterceptor;
    }

    public ModelAdapter<Model, Item> withReverseInterceptor(IInterceptor<Item, Model> reverseInterceptor) {
        this.mReverseInterceptor = reverseInterceptor;
        return this;
    }

    @Nullable
    private Item intercept(Model model) {
        return (Item)((IItem)this.mInterceptor.intercept(model));
    }

    private List<Item> intercept(List<Model> models) {
        ArrayList<Item> items = new ArrayList<Item>(models.size());
        for (Model model : models) {
            Item item = this.intercept(model);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public ModelAdapter<Model, Item> withIdDistributor(IIdDistributor<Item> idDistributor) {
        this.mIdDistributor = idDistributor;
        return this;
    }

    public IIdDistributor<Item> getIdDistributor() {
        if (this.mIdDistributor == null) {
            return IIdDistributor.DEFAULT;
        }
        return this.mIdDistributor;
    }

    public ModelAdapter<Model, Item> withUseIdDistributor(boolean useIdDistributor) {
        this.mUseIdDistributor = useIdDistributor;
        return this;
    }

    public boolean isUseIdDistributor() {
        return this.mUseIdDistributor;
    }

    public ModelAdapter<Model, Item> withItemFilter(ItemFilter<Model, Item> itemFilter) {
        this.mItemFilter = itemFilter;
        return this;
    }

    public ItemFilter<Model, Item> getItemFilter() {
        return this.mItemFilter;
    }

    public void filter(@Nullable CharSequence constraint) {
        this.mItemFilter.filter(constraint);
    }

    public ModelAdapter<Model, Item> withComparator(Comparator<Item> comparator) {
        return this.withComparator(comparator, true);
    }

    public ModelAdapter<Model, Item> withComparator(Comparator<Item> comparator, boolean sortNow) {
        this.mComparator = comparator;
        if (this.mItems != null && this.mComparator != null && sortNow) {
            Collections.sort(this.mItems, this.mComparator);
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    public Comparator<Item> getComparator() {
        return this.mComparator;
    }

    public List<Model> getModels() {
        if (this.mReverseInterceptor != null) {
            ArrayList<Model> list = new ArrayList<Model>(this.mItems.size());
            for (IItem item : this.mItems) {
                list.add(this.mReverseInterceptor.intercept(item));
            }
            return list;
        }
        throw new RuntimeException("please provide a reverseInterceptor");
    }

    @Override
    public int getAdapterItemCount() {
        return this.mItems.size();
    }

    @Override
    public List<Item> getAdapterItems() {
        return this.mItems;
    }

    @Override
    public int getAdapterPosition(Item item) {
        return this.getAdapterPosition(item.getIdentifier());
    }

    @Override
    public int getAdapterPosition(long identifier) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            if (((IItem)this.mItems.get(i)).getIdentifier() != identifier) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getGlobalPosition(int position) {
        return position + this.getFastAdapter().getPreItemCountByOrder(this.getOrder());
    }

    @Override
    public Item getAdapterItem(int position) {
        return (Item)((IItem)this.mItems.get(position));
    }

    @Override
    public ModelAdapter<Model, Item> set(List<Model> items) {
        return this.set(items, true);
    }

    protected ModelAdapter<Model, Item> set(List<Model> list, boolean resetFilter) {
        List<Item> items = this.intercept(list);
        return this.setInternal(items, resetFilter, null);
    }

    public ModelAdapter<Model, Item> set(List<Model> list, boolean resetFilter, @Nullable IAdapterNotifier adapterNotifier) {
        List<Item> items = this.intercept(list);
        return this.setInternal(items, resetFilter, adapterNotifier);
    }

    public ModelAdapter<Model, Item> setInternal(List<Item> items, boolean resetFilter, IAdapterNotifier adapterNotifier) {
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkIds(items);
        }
        if (resetFilter && this.getItemFilter().getConstraint() != null) {
            this.getItemFilter().performFiltering(null);
        }
        for (IAdapterExtension<Item> ext : this.getFastAdapter().getExtensions()) {
            ext.set(items, resetFilter);
        }
        int newItemsCount = items.size();
        int previousItemsCount = this.mItems.size();
        int itemsBeforeThisAdapter = this.getFastAdapter().getPreItemCountByOrder(this.getOrder());
        if (items != this.mItems) {
            if (!this.mItems.isEmpty()) {
                this.mItems.clear();
            }
            this.mItems.addAll(items);
        }
        this.mapPossibleTypes(items);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        if (adapterNotifier == null) {
            adapterNotifier = IAdapterNotifier.DEFAULT;
        }
        adapterNotifier.notify(this.getFastAdapter(), newItemsCount, previousItemsCount, itemsBeforeThisAdapter);
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> setNewList(List<Model> items) {
        return this.setNewList(items, false);
    }

    public ModelAdapter<Model, Item> setNewList(List<Model> list, boolean retainFilter) {
        List<Item> items = this.intercept(list);
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkIds(items);
        }
        CharSequence filter = null;
        if (this.getItemFilter().getConstraint() != null) {
            filter = this.getItemFilter().getConstraint();
            this.getItemFilter().performFiltering(null);
        }
        this.mItems = new ArrayList<Item>(items);
        this.mapPossibleTypes(this.mItems);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        if (filter != null && retainFilter) {
            this.getItemFilter().publishResults(filter, this.getItemFilter().performFiltering(filter));
        } else {
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    public void remapMappedTypes() {
        this.getFastAdapter().clearTypeInstance();
        this.mapPossibleTypes(this.mItems);
    }

    @Override
    @SafeVarargs
    public final ModelAdapter<Model, Item> add(Model ... items) {
        return this.add((List)Arrays.asList(items));
    }

    @Override
    public ModelAdapter<Model, Item> add(List<Model> list) {
        List<Item> items = this.intercept(list);
        return this.addInternal((List)items);
    }

    @Override
    public ModelAdapter<Model, Item> addInternal(List<Item> items) {
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkIds(items);
        }
        int countBefore = this.mItems.size();
        this.mItems.addAll(items);
        this.mapPossibleTypes(items);
        if (this.mComparator == null) {
            this.getFastAdapter().notifyAdapterItemRangeInserted(this.getFastAdapter().getPreItemCountByOrder(this.getOrder()) + countBefore, items.size());
        } else {
            Collections.sort(this.mItems, this.mComparator);
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    @Override
    @SafeVarargs
    public final ModelAdapter<Model, Item> add(int position, Model ... items) {
        return this.add(position, (List)Arrays.asList(items));
    }

    @Override
    public ModelAdapter<Model, Item> add(int position, List<Model> list) {
        List<Item> items = this.intercept(list);
        return this.addInternal(position, (List)items);
    }

    @Override
    public ModelAdapter<Model, Item> addInternal(int position, List<Item> items) {
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkIds(items);
        }
        if (items != null && items.size() > 0) {
            this.mItems.addAll(position - this.getFastAdapter().getPreItemCountByOrder(this.getOrder()), items);
            this.mapPossibleTypes(items);
            this.getFastAdapter().notifyAdapterItemRangeInserted(position, items.size());
        }
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> set(int position, Model element) {
        Item item = this.intercept(element);
        if (item == null) {
            return this;
        }
        return this.setInternal(position, (IItem)item);
    }

    @Override
    public ModelAdapter<Model, Item> setInternal(int position, Item item) {
        if (this.mUseIdDistributor) {
            this.getIdDistributor().checkId(item);
        }
        this.mItems.set(position - this.getFastAdapter().getPreItemCount(position), item);
        this.mFastAdapter.registerTypeInstance(item);
        this.getFastAdapter().notifyAdapterItemChanged(position);
        return this;
    }

    public ModelAdapter<Model, Item> move(int fromPosition, int toPosition) {
        int preItemCount = this.getFastAdapter().getPreItemCount(fromPosition);
        IItem item = (IItem)this.mItems.get(fromPosition - preItemCount);
        this.mItems.remove(fromPosition - preItemCount);
        this.mItems.add(toPosition - preItemCount, item);
        this.getFastAdapter().notifyAdapterItemMoved(fromPosition, toPosition);
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> remove(int position) {
        this.mItems.remove(position - this.getFastAdapter().getPreItemCount(position));
        this.getFastAdapter().notifyAdapterItemRemoved(position);
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> removeRange(int position, int itemCount) {
        int length = this.mItems.size();
        int preItemCount = this.getFastAdapter().getPreItemCount(position);
        int saveItemCount = Math.min(itemCount, length - position + preItemCount);
        for (int i = 0; i < saveItemCount; ++i) {
            this.mItems.remove(position - preItemCount);
        }
        this.getFastAdapter().notifyAdapterItemRangeRemoved(position, saveItemCount);
        return this;
    }

    @Override
    public ModelAdapter<Model, Item> clear() {
        int count = this.mItems.size();
        this.mItems.clear();
        this.getFastAdapter().notifyAdapterItemRangeRemoved(this.getFastAdapter().getPreItemCountByOrder(this.getOrder()), count);
        return this;
    }
}

