/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter;

import android.os.Bundle;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IAdapterExtension;
import com.mikepenz.fastadapter.IClickable;
import com.mikepenz.fastadapter.IHookable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.ISelectionListener;
import com.mikepenz.fastadapter.ITypeInstanceCache;
import com.mikepenz.fastadapter.R;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.listeners.ClickEventHook;
import com.mikepenz.fastadapter.listeners.EventHook;
import com.mikepenz.fastadapter.listeners.LongClickEventHook;
import com.mikepenz.fastadapter.listeners.OnBindViewHolderListener;
import com.mikepenz.fastadapter.listeners.OnBindViewHolderListenerImpl;
import com.mikepenz.fastadapter.listeners.OnClickListener;
import com.mikepenz.fastadapter.listeners.OnCreateViewHolderListener;
import com.mikepenz.fastadapter.listeners.OnCreateViewHolderListenerImpl;
import com.mikepenz.fastadapter.listeners.OnLongClickListener;
import com.mikepenz.fastadapter.listeners.OnTouchListener;
import com.mikepenz.fastadapter.listeners.TouchEventHook;
import com.mikepenz.fastadapter.select.SelectExtension;
import com.mikepenz.fastadapter.utils.DefaultTypeInstanceCache;
import com.mikepenz.fastadapter.utils.EventHookUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class FastAdapter<Item extends IItem>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = "FastAdapter";
    private final ArrayList<IAdapter<Item>> mAdapters = new ArrayList();
    private ITypeInstanceCache<Item> mTypeInstanceCache;
    private final SparseArray<IAdapter<Item>> mAdapterSizes = new SparseArray();
    private int mGlobalSize = 0;
    private List<EventHook<Item>> eventHooks;
    private final Set<IAdapterExtension<Item>> mExtensions = new HashSet<IAdapterExtension<Item>>();
    private SelectExtension<Item> mSelectExtension = new SelectExtension();
    private boolean mLegacyBindViewMode = false;
    private boolean mVerbose = false;
    private OnClickListener<Item> mOnPreClickListener;
    private OnClickListener<Item> mOnClickListener;
    private OnLongClickListener<Item> mOnPreLongClickListener;
    private OnLongClickListener<Item> mOnLongClickListener;
    private OnTouchListener<Item> mOnTouchListener;
    private OnCreateViewHolderListener mOnCreateViewHolderListener = new OnCreateViewHolderListenerImpl();
    private OnBindViewHolderListener mOnBindViewHolderListener = new OnBindViewHolderListenerImpl();
    private ClickEventHook<Item> fastAdapterViewClickListener = new ClickEventHook<Item>(){

        @Override
        public void onClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
            IAdapter adapter = fastAdapter.getAdapter(pos);
            if (adapter != null && item != null && item.isEnabled()) {
                boolean consumed = false;
                if (item instanceof IClickable && ((IClickable)item).getOnPreItemClickListener() != null) {
                    consumed = ((IClickable)item).getOnPreItemClickListener().onClick(v, adapter, item, pos);
                }
                if (!consumed && fastAdapter.mOnPreClickListener != null) {
                    consumed = fastAdapter.mOnPreClickListener.onClick(v, adapter, item, pos);
                }
                for (IAdapterExtension ext : fastAdapter.mExtensions) {
                    if (consumed) break;
                    consumed = ext.onClick(v, pos, fastAdapter, item);
                }
                if (!consumed && item instanceof IClickable && ((IClickable)item).getOnItemClickListener() != null) {
                    consumed = ((IClickable)item).getOnItemClickListener().onClick(v, adapter, item, pos);
                }
                if (!consumed && fastAdapter.mOnClickListener != null) {
                    fastAdapter.mOnClickListener.onClick(v, adapter, item, pos);
                }
            }
        }
    };
    private LongClickEventHook<Item> fastAdapterViewLongClickListener = new LongClickEventHook<Item>(){

        @Override
        public boolean onLongClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
            boolean consumed = false;
            IAdapter adapter = fastAdapter.getAdapter(pos);
            if (adapter != null && item != null && item.isEnabled()) {
                if (fastAdapter.mOnPreLongClickListener != null) {
                    consumed = fastAdapter.mOnPreLongClickListener.onLongClick(v, adapter, item, pos);
                }
                for (IAdapterExtension ext : fastAdapter.mExtensions) {
                    if (consumed) break;
                    consumed = ext.onLongClick(v, pos, fastAdapter, item);
                }
                if (!consumed && fastAdapter.mOnLongClickListener != null) {
                    consumed = fastAdapter.mOnLongClickListener.onLongClick(v, adapter, item, pos);
                }
            }
            return consumed;
        }
    };
    private TouchEventHook<Item> fastAdapterViewTouchListener = new TouchEventHook<Item>(){

        @Override
        public boolean onTouch(View v, MotionEvent event, int position, FastAdapter<Item> fastAdapter, Item item) {
            IAdapter adapter;
            boolean consumed = false;
            for (IAdapterExtension ext : fastAdapter.mExtensions) {
                if (consumed) break;
                consumed = ext.onTouch(v, event, position, fastAdapter, item);
            }
            if (fastAdapter.mOnTouchListener != null && (adapter = fastAdapter.getAdapter(position)) != null) {
                return fastAdapter.mOnTouchListener.onTouch(v, event, adapter, item, position);
            }
            return consumed;
        }
    };

    private static int floorIndex(SparseArray<?> sparseArray, int key) {
        int index = sparseArray.indexOfKey(key);
        if (index < 0) {
            index = ~index - 1;
        }
        return index;
    }

    public FastAdapter() {
        this.setHasStableIds(true);
    }

    public FastAdapter<Item> enableVerboseLog() {
        this.mVerbose = true;
        return this;
    }

    public void setTypeInstanceCache(ITypeInstanceCache<Item> mTypeInstanceCache) {
        this.mTypeInstanceCache = mTypeInstanceCache;
    }

    public ITypeInstanceCache<Item> getTypeInstanceCache() {
        if (this.mTypeInstanceCache == null) {
            this.mTypeInstanceCache = new DefaultTypeInstanceCache();
        }
        return this.mTypeInstanceCache;
    }

    public static <Item extends IItem, A extends IAdapter> FastAdapter<Item> with(A adapter) {
        FastAdapter<Item> fastAdapter = new FastAdapter<Item>();
        fastAdapter.addAdapter(0, adapter);
        return fastAdapter;
    }

    public static <Item extends IItem, A extends IAdapter> FastAdapter<Item> with(@Nullable Collection<A> adapters) {
        return FastAdapter.with(adapters, null);
    }

    public static <Item extends IItem, A extends IAdapter> FastAdapter<Item> with(@Nullable Collection<A> adapters, @Nullable Collection<IAdapterExtension<Item>> extensions) {
        FastAdapter<Item> fastAdapter = new FastAdapter<Item>();
        if (adapters == null) {
            fastAdapter.mAdapters.add(ItemAdapter.items());
        } else {
            for (IAdapter adapter : adapters) {
                fastAdapter.mAdapters.add(adapter);
            }
        }
        for (int i = 0; i < fastAdapter.mAdapters.size(); ++i) {
            fastAdapter.mAdapters.get(i).withFastAdapter(fastAdapter).setOrder(i);
        }
        fastAdapter.cacheSizes();
        if (extensions != null) {
            for (IAdapterExtension<Item> extension : extensions) {
                fastAdapter.addExtension(extension);
            }
        }
        return fastAdapter;
    }

    public <A extends IAdapter<Item>> FastAdapter<Item> addAdapter(int index, A adapter) {
        this.mAdapters.add(index, adapter);
        for (int i = 0; i < this.mAdapters.size(); ++i) {
            this.mAdapters.get(i).withFastAdapter(this).setOrder(i);
        }
        this.cacheSizes();
        return this;
    }

    @Nullable
    public IAdapter<Item> adapter(int order) {
        if (this.mAdapters.size() <= order) {
            return null;
        }
        return this.mAdapters.get(order);
    }

    public <E extends IAdapterExtension<Item>> FastAdapter<Item> addExtension(E extension) {
        this.mExtensions.add(extension);
        extension.init(this);
        return this;
    }

    public Set<IAdapterExtension<Item>> getExtensions() {
        return this.mExtensions;
    }

    @Deprecated
    public FastAdapter<Item> withItemEvent(EventHook<Item> eventHook) {
        return this.withEventHook(eventHook);
    }

    public List<EventHook<Item>> getEventHooks() {
        return this.eventHooks;
    }

    public FastAdapter<Item> withEventHook(EventHook<Item> eventHook) {
        if (this.eventHooks == null) {
            this.eventHooks = new LinkedList<EventHook<Item>>();
        }
        this.eventHooks.add(eventHook);
        return this;
    }

    public FastAdapter<Item> withEventHooks(@Nullable Collection<? extends EventHook<Item>> eventHooks) {
        if (eventHooks == null) {
            return this;
        }
        if (this.eventHooks == null) {
            this.eventHooks = new LinkedList<EventHook<Item>>();
        }
        this.eventHooks.addAll(eventHooks);
        return this;
    }

    public FastAdapter<Item> withOnClickListener(OnClickListener<Item> onClickListener) {
        this.mOnClickListener = onClickListener;
        return this;
    }

    public OnClickListener<Item> getOnClickListener() {
        return this.mOnClickListener;
    }

    public FastAdapter<Item> withOnPreClickListener(OnClickListener<Item> onPreClickListener) {
        this.mOnPreClickListener = onPreClickListener;
        return this;
    }

    public FastAdapter<Item> withOnLongClickListener(OnLongClickListener<Item> onLongClickListener) {
        this.mOnLongClickListener = onLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnPreLongClickListener(OnLongClickListener<Item> onPreLongClickListener) {
        this.mOnPreLongClickListener = onPreLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnTouchListener(OnTouchListener<Item> onTouchListener) {
        this.mOnTouchListener = onTouchListener;
        return this;
    }

    public FastAdapter<Item> withOnCreateViewHolderListener(OnCreateViewHolderListener onCreateViewHolderListener) {
        this.mOnCreateViewHolderListener = onCreateViewHolderListener;
        return this;
    }

    public FastAdapter<Item> withOnBindViewHolderListener(OnBindViewHolderListener onBindViewHolderListener) {
        this.mOnBindViewHolderListener = onBindViewHolderListener;
        return this;
    }

    public FastAdapter<Item> withSelectWithItemUpdate(boolean selectWithItemUpdate) {
        this.mSelectExtension.withSelectWithItemUpdate(selectWithItemUpdate);
        return this;
    }

    public FastAdapter<Item> withMultiSelect(boolean multiSelect) {
        this.mSelectExtension.withMultiSelect(multiSelect);
        return this;
    }

    public FastAdapter<Item> withSelectOnLongClick(boolean selectOnLongClick) {
        this.mSelectExtension.withSelectOnLongClick(selectOnLongClick);
        return this;
    }

    public FastAdapter<Item> withAllowDeselection(boolean allowDeselection) {
        this.mSelectExtension.withAllowDeselection(allowDeselection);
        return this;
    }

    public FastAdapter<Item> withSelectable(boolean selectable) {
        if (selectable) {
            this.addExtension(this.mSelectExtension);
        } else {
            this.mExtensions.remove(this.mSelectExtension);
        }
        this.mSelectExtension.withSelectable(selectable);
        return this;
    }

    public FastAdapter<Item> withLegacyBindViewMode(boolean legacyBindViewMode) {
        this.mLegacyBindViewMode = legacyBindViewMode;
        return this;
    }

    public FastAdapter<Item> withSelectionListener(ISelectionListener<Item> selectionListener) {
        this.mSelectExtension.withSelectionListener(selectionListener);
        return this;
    }

    public boolean isSelectable() {
        return this.mSelectExtension.isSelectable();
    }

    public FastAdapter<Item> withSavedInstanceState(Bundle savedInstanceState) {
        return this.withSavedInstanceState(savedInstanceState, "");
    }

    public FastAdapter<Item> withSavedInstanceState(@Nullable Bundle savedInstanceState, String prefix) {
        for (IAdapterExtension<Item> ext : this.mExtensions) {
            ext.withSavedInstanceState(savedInstanceState, prefix);
        }
        return this;
    }

    public void registerTypeInstance(Item item) {
        if (this.getTypeInstanceCache().register(item) && item instanceof IHookable) {
            this.withEventHooks(((IHookable)item).getEventHooks());
        }
    }

    public Item getTypeInstance(int type) {
        return this.getTypeInstanceCache().get(type);
    }

    public void clearTypeInstance() {
        this.getTypeInstanceCache().clear();
    }

    public int getHolderAdapterPosition(RecyclerView.ViewHolder holder) {
        return holder.getAdapterPosition();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onCreateViewHolder: " + viewType));
        }
        RecyclerView.ViewHolder holder = this.mOnCreateViewHolderListener.onPreCreateViewHolder(this, parent, viewType);
        holder.itemView.setTag(R.id.fastadapter_item_adapter, (Object)this);
        EventHookUtil.attachToView(this.fastAdapterViewClickListener, holder, holder.itemView);
        EventHookUtil.attachToView(this.fastAdapterViewLongClickListener, holder, holder.itemView);
        EventHookUtil.attachToView(this.fastAdapterViewTouchListener, holder, holder.itemView);
        return this.mOnCreateViewHolderListener.onPostCreateViewHolder(this, holder);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.mLegacyBindViewMode) {
            if (this.mVerbose) {
                Log.v((String)TAG, (String)("onBindViewHolderLegacy: " + position + "/" + holder.getItemViewType() + " isLegacy: true"));
            }
            holder.itemView.setTag(R.id.fastadapter_item_adapter, (Object)this);
            this.mOnBindViewHolderListener.onBindViewHolder(holder, position, Collections.EMPTY_LIST);
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        if (!this.mLegacyBindViewMode) {
            if (this.mVerbose) {
                Log.v((String)TAG, (String)("onBindViewHolder: " + position + "/" + holder.getItemViewType() + " isLegacy: false"));
            }
            holder.itemView.setTag(R.id.fastadapter_item_adapter, (Object)this);
            this.mOnBindViewHolderListener.onBindViewHolder(holder, position, payloads);
        }
        super.onBindViewHolder(holder, position, payloads);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onViewRecycled: " + holder.getItemViewType()));
        }
        super.onViewRecycled(holder);
        this.mOnBindViewHolderListener.unBindViewHolder(holder, holder.getAdapterPosition());
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onViewDetachedFromWindow: " + holder.getItemViewType()));
        }
        super.onViewDetachedFromWindow(holder);
        this.mOnBindViewHolderListener.onViewDetachedFromWindow(holder, holder.getAdapterPosition());
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onViewAttachedToWindow: " + holder.getItemViewType()));
        }
        super.onViewAttachedToWindow(holder);
        this.mOnBindViewHolderListener.onViewAttachedToWindow(holder, holder.getAdapterPosition());
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onFailedToRecycleView: " + holder.getItemViewType()));
        }
        return this.mOnBindViewHolderListener.onFailedToRecycleView(holder, holder.getAdapterPosition()) || super.onFailedToRecycleView(holder);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)"onAttachedToRecyclerView");
        }
        super.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)"onDetachedFromRecyclerView");
        }
        super.onDetachedFromRecyclerView(recyclerView);
    }

    public int getPosition(Item item) {
        if (item.getIdentifier() == -1L) {
            Log.e((String)TAG, (String)"You have to define an identifier for your item to retrieve the position via this method");
            return -1;
        }
        return this.getPosition(item.getIdentifier());
    }

    public int getPosition(long identifier) {
        int position = 0;
        for (IAdapter<Item> adapter : this.mAdapters) {
            if (adapter.getOrder() < 0) continue;
            int relativePosition = adapter.getAdapterPosition(identifier);
            if (relativePosition != -1) {
                return position + relativePosition;
            }
            position = adapter.getAdapterItemCount();
        }
        return -1;
    }

    public Item getItem(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        int index = FastAdapter.floorIndex(this.mAdapterSizes, position);
        return ((IAdapter)this.mAdapterSizes.valueAt(index)).getAdapterItem(position - this.mAdapterSizes.keyAt(index));
    }

    public RelativeInfo<Item> getRelativeInfo(int position) {
        if (position < 0) {
            return new RelativeInfo();
        }
        RelativeInfo relativeInfo = new RelativeInfo();
        int index = FastAdapter.floorIndex(this.mAdapterSizes, position);
        if (index != -1) {
            relativeInfo.item = ((IAdapter)this.mAdapterSizes.valueAt(index)).getAdapterItem(position - this.mAdapterSizes.keyAt(index));
            relativeInfo.adapter = (IAdapter)this.mAdapterSizes.valueAt(index);
            relativeInfo.position = position;
        }
        return relativeInfo;
    }

    @Nullable
    public IAdapter<Item> getAdapter(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        if (this.mVerbose) {
            Log.v((String)TAG, (String)"getAdapter");
        }
        return (IAdapter)this.mAdapterSizes.valueAt(FastAdapter.floorIndex(this.mAdapterSizes, position));
    }

    public int getItemViewType(int position) {
        return this.getItem(position).getType();
    }

    public long getItemId(int position) {
        return this.getItem(position).getIdentifier();
    }

    public int getItemCount() {
        return this.mGlobalSize;
    }

    public int getPreItemCountByOrder(int order) {
        if (this.mGlobalSize == 0) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < Math.min(order, this.mAdapters.size()); ++i) {
            size += this.mAdapters.get(i).getAdapterItemCount();
        }
        return size;
    }

    public int getPreItemCount(int position) {
        if (this.mGlobalSize == 0) {
            return 0;
        }
        return this.mAdapterSizes.keyAt(FastAdapter.floorIndex(this.mAdapterSizes, position));
    }

    public Bundle saveInstanceState(@Nullable Bundle savedInstanceState) {
        return this.saveInstanceState(savedInstanceState, "");
    }

    public Bundle saveInstanceState(@Nullable Bundle savedInstanceState, String prefix) {
        for (IAdapterExtension<Item> ext : this.mExtensions) {
            ext.saveInstanceState(savedInstanceState, prefix);
        }
        return savedInstanceState;
    }

    protected void cacheSizes() {
        this.mAdapterSizes.clear();
        int size = 0;
        for (IAdapter<Item> adapter : this.mAdapters) {
            if (adapter.getAdapterItemCount() <= 0) continue;
            this.mAdapterSizes.append(size, adapter);
            size += adapter.getAdapterItemCount();
        }
        if (size == 0 && this.mAdapters.size() > 0) {
            this.mAdapterSizes.append(0, this.mAdapters.get(0));
        }
        this.mGlobalSize = size;
    }

    public SelectExtension<Item> getSelectExtension() {
        return this.mSelectExtension;
    }

    public Set<Integer> getSelections() {
        return this.mSelectExtension.getSelections();
    }

    public Set<Item> getSelectedItems() {
        return this.mSelectExtension.getSelectedItems();
    }

    public void toggleSelection(int position) {
        this.mSelectExtension.toggleSelection(position);
    }

    public void select(Iterable<Integer> positions) {
        this.mSelectExtension.select(positions);
    }

    public void select(int position) {
        this.mSelectExtension.select(position, false, false);
    }

    public void select(int position, boolean fireEvent) {
        this.mSelectExtension.select(position, fireEvent, false);
    }

    public void select(int position, boolean fireEvent, boolean considerSelectableFlag) {
        this.mSelectExtension.select(position, fireEvent, considerSelectableFlag);
    }

    public void deselect() {
        this.mSelectExtension.deselect();
    }

    public void select() {
        this.mSelectExtension.select(false);
    }

    public void select(boolean considerSelectableFlag) {
        this.mSelectExtension.select(considerSelectableFlag);
    }

    public void deselect(Iterable<Integer> positions) {
        this.mSelectExtension.deselect(positions);
    }

    public void deselect(int position) {
        this.mSelectExtension.deselect(position, null);
    }

    public void deselect(int position, Iterator<Integer> entries) {
        this.mSelectExtension.deselect(position, entries);
    }

    public List<Item> deleteAllSelectedItems() {
        return this.mSelectExtension.deleteAllSelectedItems();
    }

    public void notifyAdapterDataSetChanged() {
        for (IAdapterExtension<Item> ext : this.mExtensions) {
            ext.notifyAdapterDataSetChanged();
        }
        this.cacheSizes();
        this.notifyDataSetChanged();
    }

    public void notifyAdapterItemInserted(int position) {
        this.notifyAdapterItemRangeInserted(position, 1);
    }

    public void notifyAdapterItemRangeInserted(int position, int itemCount) {
        for (IAdapterExtension<Item> ext : this.mExtensions) {
            ext.notifyAdapterItemRangeInserted(position, itemCount);
        }
        this.cacheSizes();
        this.notifyItemRangeInserted(position, itemCount);
    }

    public void notifyAdapterItemRemoved(int position) {
        this.notifyAdapterItemRangeRemoved(position, 1);
    }

    public void notifyAdapterItemRangeRemoved(int position, int itemCount) {
        for (IAdapterExtension<Item> ext : this.mExtensions) {
            ext.notifyAdapterItemRangeRemoved(position, itemCount);
        }
        this.cacheSizes();
        this.notifyItemRangeRemoved(position, itemCount);
    }

    public void notifyAdapterItemMoved(int fromPosition, int toPosition) {
        for (IAdapterExtension<Item> ext : this.mExtensions) {
            ext.notifyAdapterItemMoved(fromPosition, toPosition);
        }
        this.notifyItemMoved(fromPosition, toPosition);
    }

    public void notifyAdapterItemChanged(int position) {
        this.notifyAdapterItemChanged(position, null);
    }

    public void notifyAdapterItemChanged(int position, @Nullable Object payload) {
        this.notifyAdapterItemRangeChanged(position, 1, payload);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount) {
        this.notifyAdapterItemRangeChanged(position, itemCount, null);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount, @Nullable Object payload) {
        for (IAdapterExtension<Item> ext : this.mExtensions) {
            ext.notifyAdapterItemRangeChanged(position, itemCount, payload);
        }
        if (payload == null) {
            this.notifyItemRangeChanged(position, itemCount);
        } else {
            this.notifyItemRangeChanged(position, itemCount, payload);
        }
    }

    public static abstract class ViewHolder<Item extends IItem>
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }

        public abstract void bindView(Item var1, List<Object> var2);

        public abstract void unbindView(Item var1);

        public void attachToWindow(Item item) {
        }

        public void detachFromWindow(Item item) {
        }

        public boolean failedToRecycle(Item item) {
            return false;
        }
    }

    public static class RelativeInfo<Item extends IItem> {
        public IAdapter<Item> adapter = null;
        public Item item = null;
        public int position = -1;
    }
}

