/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.R;
import com.mikepenz.fastadapter.listeners.ClickEventHook;
import com.mikepenz.fastadapter.listeners.CustomEventHook;
import com.mikepenz.fastadapter.listeners.EventHook;
import com.mikepenz.fastadapter.listeners.LongClickEventHook;
import com.mikepenz.fastadapter.listeners.TouchEventHook;
import java.util.Arrays;
import java.util.List;

public class EventHookUtil {
    public static <Item extends IItem> void bind(@NonNull RecyclerView.ViewHolder viewHolder, @Nullable List<EventHook<Item>> eventHooks) {
        if (eventHooks == null) {
            return;
        }
        for (EventHook<Item> event : eventHooks) {
            List<View> views;
            View view = event.onBind(viewHolder);
            if (view != null) {
                EventHookUtil.attachToView(event, viewHolder, view);
            }
            if ((views = event.onBindMany(viewHolder)) == null) continue;
            for (View v : views) {
                EventHookUtil.attachToView(event, viewHolder, v);
            }
        }
    }

    public static <Item extends IItem> void attachToView(final @NonNull EventHook<Item> event, final @NonNull RecyclerView.ViewHolder viewHolder, @NonNull View view) {
        if (event instanceof ClickEventHook) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FastAdapter adapter;
                    int pos;
                    Object tag = viewHolder.itemView.getTag(R.id.fastadapter_item_adapter);
                    if (tag instanceof FastAdapter && (pos = (adapter = (FastAdapter)((Object)tag)).getHolderAdapterPosition(viewHolder)) != -1) {
                        ((ClickEventHook)event).onClick(v, pos, adapter, adapter.getItem(pos));
                    }
                }
            });
        } else if (event instanceof LongClickEventHook) {
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    FastAdapter adapter;
                    int pos;
                    Object tag = viewHolder.itemView.getTag(R.id.fastadapter_item_adapter);
                    if (tag instanceof FastAdapter && (pos = (adapter = (FastAdapter)((Object)tag)).getHolderAdapterPosition(viewHolder)) != -1) {
                        return ((LongClickEventHook)event).onLongClick(v, pos, adapter, adapter.getItem(pos));
                    }
                    return false;
                }
            });
        } else if (event instanceof TouchEventHook) {
            view.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent e) {
                    FastAdapter adapter;
                    int pos;
                    Object tag = viewHolder.itemView.getTag(R.id.fastadapter_item_adapter);
                    if (tag instanceof FastAdapter && (pos = (adapter = (FastAdapter)((Object)tag)).getHolderAdapterPosition(viewHolder)) != -1) {
                        return ((TouchEventHook)event).onTouch(v, e, pos, adapter, adapter.getItem(pos));
                    }
                    return false;
                }
            });
        } else if (event instanceof CustomEventHook) {
            ((CustomEventHook)event).attachEvent(view, viewHolder);
        }
    }

    public static List<View> toList(View ... views) {
        return Arrays.asList(views);
    }
}

