/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mikepenz.fastadapter.AbstractAdapter;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.ISubItem;
import com.mikepenz.fastadapter.adapters.ItemFilter;
import com.mikepenz.fastadapter.utils.IdDistributor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ItemAdapter<Item extends IItem>
extends AbstractAdapter<Item>
implements IItemAdapter<Item> {
    private List<Item> mItems = new ArrayList<Item>();
    private boolean mUseIdDistributor = true;
    private ItemFilter<Item> mItemFilter = new ItemFilter(this);
    protected Comparator<Item> mComparator;

    public ItemAdapter withUseIdDistributor(boolean useIdDistributor) {
        this.mUseIdDistributor = useIdDistributor;
        return this;
    }

    public boolean isUseIdDistributor() {
        return this.mUseIdDistributor;
    }

    public ItemAdapter<Item> withItemFilter(@NonNull ItemFilter<Item> itemFilter) {
        this.mItemFilter = itemFilter;
        return this;
    }

    @NonNull
    public ItemFilter<Item> getItemFilter() {
        return this.mItemFilter;
    }

    public void filter(@Nullable CharSequence constraint) {
        this.mItemFilter.filter(constraint);
    }

    public ItemAdapter<Item> withComparator(Comparator<Item> comparator) {
        return this.withComparator(comparator, true);
    }

    public ItemAdapter<Item> withComparator(Comparator<Item> comparator, boolean sortNow) {
        this.mComparator = comparator;
        if (this.mItems != null && this.mComparator != null && sortNow) {
            Collections.sort(this.mItems, this.mComparator);
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    public Comparator<Item> getComparator() {
        return this.mComparator;
    }

    @Override
    public int getOrder() {
        return 500;
    }

    @Override
    public int getAdapterItemCount() {
        return this.mItems.size();
    }

    @Override
    public List<Item> getAdapterItems() {
        return this.mItems;
    }

    @Override
    public int getAdapterPosition(Item item) {
        return this.getAdapterPosition(item.getIdentifier());
    }

    @Override
    public int getAdapterPosition(long identifier) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            if (((IItem)this.mItems.get(i)).getIdentifier() != identifier) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getGlobalPosition(int position) {
        return position + this.getFastAdapter().getPreItemCountByOrder(this.getOrder());
    }

    @Override
    public Item getAdapterItem(int position) {
        return (Item)((IItem)this.mItems.get(position));
    }

    @Override
    public <T extends IItem & IExpandable<T, S>, S extends IItem & ISubItem<Item, T>> T setSubItems(T collapsible, List<S> subItems) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(subItems);
        }
        return (T)((IItem)((IExpandable<T, S>)collapsible).withSubItems(subItems));
    }

    @Override
    public ItemAdapter<Item> set(List<Item> items) {
        return this.set(items, true);
    }

    protected ItemAdapter<Item> set(List<Item> items, boolean resetFilter) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        if (resetFilter && this.getItemFilter() != null && this.getItemFilter().getConstraint() != null) {
            this.getItemFilter().performFiltering(null);
        }
        this.getFastAdapter().collapse(false);
        int newItemsCount = items.size();
        int previousItemsCount = this.mItems.size();
        int itemsBeforeThisAdapter = this.getFastAdapter().getPreItemCountByOrder(this.getOrder());
        if (items != this.mItems) {
            if (!this.mItems.isEmpty()) {
                this.mItems.clear();
            }
            this.mItems.addAll(items);
        }
        this.mapPossibleTypes(items);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        if (newItemsCount > previousItemsCount) {
            if (previousItemsCount > 0) {
                this.getFastAdapter().notifyAdapterItemRangeChanged(itemsBeforeThisAdapter, previousItemsCount);
            }
            this.getFastAdapter().notifyAdapterItemRangeInserted(itemsBeforeThisAdapter + previousItemsCount, newItemsCount - previousItemsCount);
        } else if (newItemsCount > 0 && newItemsCount < previousItemsCount) {
            this.getFastAdapter().notifyAdapterItemRangeChanged(itemsBeforeThisAdapter, newItemsCount);
            this.getFastAdapter().notifyAdapterItemRangeRemoved(itemsBeforeThisAdapter + newItemsCount, previousItemsCount - newItemsCount);
        } else if (newItemsCount == 0) {
            this.getFastAdapter().notifyAdapterItemRangeRemoved(itemsBeforeThisAdapter, previousItemsCount);
        } else {
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    @Override
    public ItemAdapter<Item> setNewList(List<Item> items) {
        return this.setNewList(items, false);
    }

    public ItemAdapter<Item> setNewList(List<Item> items, boolean retainFilter) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        CharSequence filter = null;
        if (this.getItemFilter() != null && this.getItemFilter().getConstraint() != null) {
            filter = this.getItemFilter().getConstraint();
            this.getItemFilter().performFiltering(null);
        }
        this.mItems = new ArrayList<Item>(items);
        this.mapPossibleTypes(this.mItems);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        if (filter != null && retainFilter) {
            this.getItemFilter().filter(filter);
        } else {
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    public void remapMappedTypes() {
        this.clearMappedTypes();
        this.mapPossibleTypes(this.mItems);
    }

    @Override
    @SafeVarargs
    public final ItemAdapter<Item> add(Item ... items) {
        return this.add((List)Arrays.asList(items));
    }

    @Override
    public ItemAdapter<Item> add(List<Item> items) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        int countBefore = this.mItems.size();
        this.mItems.addAll(items);
        this.mapPossibleTypes(items);
        if (this.mComparator == null) {
            this.getFastAdapter().notifyAdapterItemRangeInserted(this.getFastAdapter().getPreItemCountByOrder(this.getOrder()) + countBefore, items.size());
        } else {
            Collections.sort(this.mItems, this.mComparator);
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    @Override
    @SafeVarargs
    public final ItemAdapter<Item> add(int position, Item ... items) {
        return this.add(position, (List)Arrays.asList(items));
    }

    @Override
    public ItemAdapter<Item> add(int position, List<Item> items) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        if (items != null && items.size() > 0) {
            this.mItems.addAll(position - this.getFastAdapter().getPreItemCountByOrder(this.getOrder()), items);
            this.mapPossibleTypes(items);
            this.getFastAdapter().notifyAdapterItemRangeInserted(position, items.size());
        }
        return this;
    }

    @Override
    public ItemAdapter<Item> set(int position, Item item) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkId(item);
        }
        this.mItems.set(position - this.getFastAdapter().getPreItemCount(position), item);
        this.mapPossibleType(item);
        this.getFastAdapter().notifyAdapterItemChanged(position);
        return this;
    }

    public ItemAdapter<Item> move(int fromPosition, int toPosition) {
        int preItemCount = this.getFastAdapter().getPreItemCount(fromPosition);
        IItem item = (IItem)this.mItems.get(fromPosition - preItemCount);
        this.mItems.remove(fromPosition - preItemCount);
        this.mItems.add(toPosition - preItemCount, item);
        this.getFastAdapter().notifyAdapterItemMoved(fromPosition, toPosition);
        return this;
    }

    @Override
    public ItemAdapter<Item> remove(int position) {
        this.mItems.remove(position - this.getFastAdapter().getPreItemCount(position));
        this.getFastAdapter().notifyAdapterItemRemoved(position);
        return this;
    }

    @Override
    public ItemAdapter<Item> removeRange(int position, int itemCount) {
        int length = this.mItems.size();
        int preItemCount = this.getFastAdapter().getPreItemCount(position);
        int saveItemCount = Math.min(itemCount, length - position + preItemCount);
        for (int i = 0; i < saveItemCount; ++i) {
            this.mItems.remove(position - preItemCount);
        }
        this.getFastAdapter().notifyAdapterItemRangeRemoved(position, saveItemCount);
        return this;
    }

    @Override
    public ItemAdapter<Item> clear() {
        int count = this.mItems.size();
        this.mItems.clear();
        this.getFastAdapter().notifyAdapterItemRangeRemoved(this.getFastAdapter().getPreItemCountByOrder(this.getOrder()), count);
        return this;
    }
}

