/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.util.ArraySet;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.AbstractAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IClickable;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.ISelectionListener;
import com.mikepenz.fastadapter.R;
import com.mikepenz.fastadapter.listeners.ClickEventHook;
import com.mikepenz.fastadapter.listeners.EventHook;
import com.mikepenz.fastadapter.listeners.LongClickEventHook;
import com.mikepenz.fastadapter.listeners.TouchEventHook;
import com.mikepenz.fastadapter.utils.AdapterUtil;
import com.mikepenz.fastadapter.utils.EventHookUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FastAdapter<Item extends IItem>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = "FastAdapter";
    protected static final String BUNDLE_SELECTIONS = "bundle_selections";
    protected static final String BUNDLE_EXPANDED = "bundle_expanded";
    private final SparseArray<IAdapter<Item>> mAdapters = new SparseArray();
    private final SparseArray<Item> mTypeInstances = new SparseArray();
    private final SparseArray<IAdapter<Item>> mAdapterSizes = new SparseArray();
    private int mGlobalSize = 0;
    private boolean mSelectWithItemUpdate = false;
    private boolean mMultiSelect = false;
    private boolean mSelectOnLongClick = false;
    private boolean mAllowDeselection = true;
    private boolean mSelectable = false;
    private boolean mOnlyOneExpandedItem = false;
    private boolean mPositionBasedStateManagement = true;
    private boolean mLegacyBindViewMode = false;
    private Set<Integer> mSelections = new ArraySet();
    private SparseIntArray mExpanded = new SparseIntArray();
    private boolean mVerbose = false;
    private List<EventHook<Item>> eventHooks;
    private OnClickListener<Item> mOnPreClickListener;
    private OnClickListener<Item> mOnClickListener;
    private OnLongClickListener<Item> mOnPreLongClickListener;
    private OnLongClickListener<Item> mOnLongClickListener;
    private OnTouchListener<Item> mOnTouchListener;
    private ISelectionListener<Item> mSelectionListener;
    private OnCreateViewHolderListener mOnCreateViewHolderListener = new OnCreateViewHolderListenerImpl();
    private OnBindViewHolderListener mOnBindViewHolderListener = new OnBindViewHolderListenerImpl();
    private ClickEventHook<Item> fastAdapterViewClickListener = new ClickEventHook<Item>(){

        @Override
        public void onClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
            if (item != null && item.isEnabled()) {
                RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                boolean consumed = false;
                if (item instanceof IClickable && ((IClickable)item).getOnPreItemClickListener() != null) {
                    consumed = ((IClickable)item).getOnPreItemClickListener().onClick(v, relativeInfo.adapter, item, pos);
                }
                if (!consumed && FastAdapter.this.mOnPreClickListener != null) {
                    consumed = FastAdapter.this.mOnPreClickListener.onClick(v, relativeInfo.adapter, item, pos);
                }
                if (!consumed && !FastAdapter.this.mSelectOnLongClick && FastAdapter.this.mSelectable) {
                    FastAdapter.this.handleSelection(v, item, pos);
                }
                if (!consumed && item instanceof IExpandable && ((IExpandable)item).isAutoExpanding() && ((IExpandable)item).getSubItems() != null) {
                    FastAdapter.this.toggleExpandable(pos);
                }
                if (!consumed && FastAdapter.this.mOnlyOneExpandedItem && item instanceof IExpandable && ((IExpandable)item).getSubItems() != null && ((IExpandable)item).getSubItems().size() > 0) {
                    int[] expandedItems = FastAdapter.this.getExpandedItems();
                    for (int i = expandedItems.length - 1; i >= 0; --i) {
                        if (expandedItems[i] == pos) continue;
                        FastAdapter.this.collapse(expandedItems[i], true);
                    }
                }
                if (!consumed && item instanceof IClickable && ((IClickable)item).getOnItemClickListener() != null) {
                    consumed = ((IClickable)item).getOnItemClickListener().onClick(v, relativeInfo.adapter, item, pos);
                }
                if (!consumed && FastAdapter.this.mOnClickListener != null) {
                    FastAdapter.this.mOnClickListener.onClick(v, relativeInfo.adapter, item, pos);
                }
            }
        }
    };
    private LongClickEventHook<Item> fastAdapterViewLongClickListener = new LongClickEventHook<Item>(){

        @Override
        public boolean onLongClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
            boolean consumed = false;
            RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
            if (relativeInfo.item != null && relativeInfo.item.isEnabled()) {
                if (FastAdapter.this.mOnPreLongClickListener != null) {
                    consumed = FastAdapter.this.mOnPreLongClickListener.onLongClick(v, relativeInfo.adapter, relativeInfo.item, pos);
                }
                if (!consumed && FastAdapter.this.mSelectOnLongClick && FastAdapter.this.mSelectable) {
                    FastAdapter.this.handleSelection(v, relativeInfo.item, pos);
                }
                if (!consumed && FastAdapter.this.mOnLongClickListener != null) {
                    consumed = FastAdapter.this.mOnLongClickListener.onLongClick(v, relativeInfo.adapter, relativeInfo.item, pos);
                }
            }
            return consumed;
        }
    };
    private TouchEventHook<Item> fastAdapterViewTouchListener = new TouchEventHook<Item>(){

        @Override
        public boolean onTouch(View v, MotionEvent event, int position, FastAdapter<Item> fastAdapter, Item item) {
            if (FastAdapter.this.mOnTouchListener != null) {
                RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(position);
                return FastAdapter.this.mOnTouchListener.onTouch(v, event, relativeInfo.adapter, relativeInfo.item, position);
            }
            return false;
        }
    };

    private static int floorIndex(SparseArray<?> sparseArray, int key) {
        int index = sparseArray.indexOfKey(key);
        if (index < 0) {
            index = ~index - 1;
        }
        return index;
    }

    public FastAdapter() {
        this.setHasStableIds(true);
    }

    public FastAdapter<Item> enableVerboseLog() {
        this.mVerbose = true;
        return this;
    }

    @Deprecated
    public FastAdapter<Item> withItemEvent(EventHook<Item> eventHook) {
        return this.withEventHook(eventHook);
    }

    public FastAdapter<Item> withEventHook(EventHook<Item> eventHook) {
        if (this.eventHooks == null) {
            this.eventHooks = new LinkedList<EventHook<Item>>();
        }
        this.eventHooks.add(eventHook);
        return this;
    }

    public FastAdapter<Item> withOnClickListener(OnClickListener<Item> onClickListener) {
        this.mOnClickListener = onClickListener;
        return this;
    }

    public FastAdapter<Item> withOnPreClickListener(OnClickListener<Item> onPreClickListener) {
        this.mOnPreClickListener = onPreClickListener;
        return this;
    }

    public FastAdapter<Item> withOnLongClickListener(OnLongClickListener<Item> onLongClickListener) {
        this.mOnLongClickListener = onLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnPreLongClickListener(OnLongClickListener<Item> onPreLongClickListener) {
        this.mOnPreLongClickListener = onPreLongClickListener;
        return this;
    }

    public FastAdapter<Item> withOnTouchListener(OnTouchListener<Item> onTouchListener) {
        this.mOnTouchListener = onTouchListener;
        return this;
    }

    public FastAdapter<Item> withOnCreateViewHolderListener(OnCreateViewHolderListener onCreateViewHolderListener) {
        this.mOnCreateViewHolderListener = onCreateViewHolderListener;
        return this;
    }

    public FastAdapter<Item> withOnBindViewHolderListener(OnBindViewHolderListener onBindViewHolderListener) {
        this.mOnBindViewHolderListener = onBindViewHolderListener;
        return this;
    }

    public FastAdapter<Item> withSelectWithItemUpdate(boolean selectWithItemUpdate) {
        this.mSelectWithItemUpdate = selectWithItemUpdate;
        return this;
    }

    public FastAdapter<Item> withMultiSelect(boolean multiSelect) {
        this.mMultiSelect = multiSelect;
        return this;
    }

    public FastAdapter<Item> withSelectOnLongClick(boolean selectOnLongClick) {
        this.mSelectOnLongClick = selectOnLongClick;
        return this;
    }

    public FastAdapter<Item> withAllowDeselection(boolean allowDeselection) {
        this.mAllowDeselection = allowDeselection;
        return this;
    }

    public FastAdapter<Item> withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return this;
    }

    public FastAdapter<Item> withPositionBasedStateManagement(boolean mPositionBasedStateManagement) {
        this.mPositionBasedStateManagement = mPositionBasedStateManagement;
        return this;
    }

    public FastAdapter<Item> withLegacyBindViewMode(boolean legacyBindViewMode) {
        this.mLegacyBindViewMode = legacyBindViewMode;
        return this;
    }

    public FastAdapter<Item> withSelectionListener(ISelectionListener<Item> selectionListener) {
        this.mSelectionListener = selectionListener;
        return this;
    }

    public boolean isSelectable() {
        return this.mSelectable;
    }

    public boolean isPositionBasedStateManagement() {
        return this.mPositionBasedStateManagement;
    }

    public FastAdapter<Item> withOnlyOneExpandedItem(boolean mOnlyOneExpandedItem) {
        this.mOnlyOneExpandedItem = mOnlyOneExpandedItem;
        return this;
    }

    public boolean isOnlyOneExpandedItem() {
        return this.mOnlyOneExpandedItem;
    }

    public FastAdapter<Item> withSavedInstanceState(Bundle savedInstanceState) {
        return this.withSavedInstanceState(savedInstanceState, "");
    }

    public FastAdapter<Item> withSavedInstanceState(Bundle savedInstanceState, String prefix) {
        block6: {
            block7: {
                int[] selections;
                int n;
                if (savedInstanceState == null) break block6;
                this.deselect();
                if (!this.mPositionBasedStateManagement) break block7;
                int[] expandedItems = savedInstanceState.getIntArray(BUNDLE_EXPANDED + prefix);
                if (expandedItems != null) {
                    int[] nArray = expandedItems;
                    int n2 = nArray.length;
                    for (n = 0; n < n2; ++n) {
                        Integer expandedItem = nArray[n];
                        this.expand(expandedItem);
                    }
                }
                if ((selections = savedInstanceState.getIntArray(BUNDLE_SELECTIONS + prefix)) == null) break block6;
                int[] nArray = selections;
                n = nArray.length;
                for (int expandedItem = 0; expandedItem < n; ++expandedItem) {
                    Integer selection = nArray[expandedItem];
                    this.select(selection);
                }
                break block6;
            }
            ArrayList expandedItems = savedInstanceState.getStringArrayList(BUNDLE_EXPANDED + prefix);
            ArrayList selectedItems = savedInstanceState.getStringArrayList(BUNDLE_SELECTIONS + prefix);
            int size = this.getItemCount();
            for (int i = 0; i < size; ++i) {
                Item item = this.getItem(i);
                String id2 = String.valueOf(item.getIdentifier());
                if (expandedItems != null && expandedItems.contains(id2)) {
                    this.expand(i);
                    size = this.getItemCount();
                }
                if (selectedItems != null && selectedItems.contains(id2)) {
                    this.select(i);
                }
                AdapterUtil.restoreSubItemSelectionStatesForAlternativeStateManagement(item, selectedItems);
            }
        }
        return this;
    }

    public <A extends AbstractAdapter<Item>> void registerAdapter(A adapter) {
        if (this.mAdapters.indexOfKey(adapter.getOrder()) < 0) {
            this.mAdapters.put(adapter.getOrder(), adapter);
            this.cacheSizes();
        }
    }

    public void registerTypeInstance(Item item) {
        if (this.mTypeInstances.indexOfKey(item.getType()) < 0) {
            this.mTypeInstances.put(item.getType(), item);
        }
    }

    public Item getTypeInstance(int type) {
        return (Item)((IItem)this.mTypeInstances.get(type));
    }

    public void clearTypeInstance() {
        this.mTypeInstances.clear();
    }

    public int getHolderAdapterPosition(RecyclerView.ViewHolder holder) {
        return holder.getAdapterPosition();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onCreateViewHolder: " + viewType));
        }
        RecyclerView.ViewHolder holder = this.mOnCreateViewHolderListener.onPreCreateViewHolder(parent, viewType);
        holder.itemView.setTag(R.id.fastadapter_item_adapter, (Object)this);
        EventHookUtil.attachToView(this.fastAdapterViewClickListener, holder, holder.itemView);
        EventHookUtil.attachToView(this.fastAdapterViewLongClickListener, holder, holder.itemView);
        EventHookUtil.attachToView(this.fastAdapterViewTouchListener, holder, holder.itemView);
        return this.mOnCreateViewHolderListener.onPostCreateViewHolder(holder);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.mLegacyBindViewMode) {
            if (this.mVerbose) {
                Log.v((String)TAG, (String)("onBindViewHolderLegacy: " + position + "/" + holder.getItemViewType()));
            }
            this.mOnBindViewHolderListener.onBindViewHolder(holder, position, Collections.EMPTY_LIST);
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onBindViewHolder: " + position + "/" + holder.getItemViewType()));
        }
        super.onBindViewHolder(holder, position, payloads);
        this.mOnBindViewHolderListener.onBindViewHolder(holder, position, payloads);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onViewRecycled: " + holder.getItemViewType()));
        }
        super.onViewRecycled(holder);
        this.mOnBindViewHolderListener.unBindViewHolder(holder, holder.getAdapterPosition());
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onViewDetachedFromWindow: " + holder.getItemViewType()));
        }
        super.onViewDetachedFromWindow(holder);
        this.mOnBindViewHolderListener.onViewDetachedFromWindow(holder, holder.getAdapterPosition());
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onViewAttachedToWindow: " + holder.getItemViewType()));
        }
        super.onViewAttachedToWindow(holder);
        this.mOnBindViewHolderListener.onViewAttachedToWindow(holder, holder.getAdapterPosition());
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)("onFailedToRecycleView: " + holder.getItemViewType()));
        }
        return this.mOnBindViewHolderListener.onFailedToRecycleView(holder, holder.getAdapterPosition()) || super.onFailedToRecycleView(holder);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)"onAttachedToRecyclerView");
        }
        super.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        if (this.mVerbose) {
            Log.v((String)TAG, (String)"onDetachedFromRecyclerView");
        }
        super.onDetachedFromRecyclerView(recyclerView);
    }

    public int getPosition(Item item) {
        if (item.getIdentifier() == -1L) {
            Log.e((String)TAG, (String)"You have to define an identifier for your item to retrieve the position via this method");
            return -1;
        }
        return this.getPosition(item.getIdentifier());
    }

    public int getPosition(long identifier) {
        int position = 0;
        int size = this.mAdapters.size();
        for (int i = 0; i < size; ++i) {
            IAdapter adapter = (IAdapter)this.mAdapters.valueAt(i);
            if (adapter.getOrder() < 0) continue;
            int relativePosition = adapter.getAdapterPosition(identifier);
            if (relativePosition != -1) {
                return position + relativePosition;
            }
            position = adapter.getAdapterItemCount();
        }
        return -1;
    }

    public Item getItem(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        int index = FastAdapter.floorIndex(this.mAdapterSizes, position);
        return ((IAdapter)this.mAdapterSizes.valueAt(index)).getAdapterItem(position - this.mAdapterSizes.keyAt(index));
    }

    public RelativeInfo<Item> getRelativeInfo(int position) {
        if (position < 0) {
            return new RelativeInfo();
        }
        RelativeInfo relativeInfo = new RelativeInfo();
        int index = FastAdapter.floorIndex(this.mAdapterSizes, position);
        if (index != -1) {
            relativeInfo.item = ((IAdapter)this.mAdapterSizes.valueAt(index)).getAdapterItem(position - this.mAdapterSizes.keyAt(index));
            relativeInfo.adapter = (IAdapter)this.mAdapterSizes.valueAt(index);
            relativeInfo.position = position;
        }
        return relativeInfo;
    }

    public IAdapter<Item> getAdapter(int position) {
        if (position < 0 || position >= this.mGlobalSize) {
            return null;
        }
        if (this.mVerbose) {
            Log.v((String)TAG, (String)"getAdapter");
        }
        return (IAdapter)this.mAdapterSizes.valueAt(FastAdapter.floorIndex(this.mAdapterSizes, position));
    }

    public int getItemViewType(int position) {
        return this.getItem(position).getType();
    }

    public long getItemId(int position) {
        return this.getItem(position).getIdentifier();
    }

    public int getItemCount() {
        return this.mGlobalSize;
    }

    public int getPreItemCountByOrder(int order) {
        if (this.mGlobalSize == 0) {
            return 0;
        }
        int size = 0;
        int adapterSize = this.mAdapters.size();
        for (int i = 0; i < adapterSize; ++i) {
            IAdapter adapter = (IAdapter)this.mAdapters.valueAt(i);
            if (adapter.getOrder() == order) {
                return size;
            }
            size += adapter.getAdapterItemCount();
        }
        return size;
    }

    public int getPreItemCount(int position) {
        if (this.mGlobalSize == 0) {
            return 0;
        }
        return this.mAdapterSizes.keyAt(FastAdapter.floorIndex(this.mAdapterSizes, position));
    }

    public int getExpandedItemsCount(int from, int position) {
        int totalAddedItems = 0;
        if (this.mPositionBasedStateManagement) {
            int size = this.mExpanded.size();
            for (int i = 0; i < size; ++i) {
                if (this.mExpanded.keyAt(i) >= from && this.mExpanded.keyAt(i) < position) {
                    totalAddedItems += this.mExpanded.get(this.mExpanded.keyAt(i));
                    continue;
                }
                if (this.mExpanded.keyAt(i) < position) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = from; i < position; ++i) {
                IExpandable tmpExpandable;
                Item tmp = this.getItem(i);
                if (!(tmp instanceof IExpandable) || (tmpExpandable = (IExpandable)tmp).getSubItems() == null || !tmpExpandable.isExpanded()) continue;
                totalAddedItems += tmpExpandable.getSubItems().size();
            }
        }
        return totalAddedItems;
    }

    public Bundle saveInstanceState(Bundle savedInstanceState) {
        return this.saveInstanceState(savedInstanceState, "");
    }

    public Bundle saveInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null) {
            if (this.mPositionBasedStateManagement) {
                int[] selections = new int[this.mSelections.size()];
                int index = 0;
                for (Integer selection : this.mSelections) {
                    selections[index] = selection;
                    ++index;
                }
                savedInstanceState.putIntArray(BUNDLE_SELECTIONS + prefix, selections);
                savedInstanceState.putIntArray(BUNDLE_EXPANDED + prefix, this.getExpandedItems());
            } else {
                ArrayList<String> selections = new ArrayList<String>();
                ArrayList<String> expandedItems = new ArrayList<String>();
                int size = this.getItemCount();
                for (int i = 0; i < size; ++i) {
                    Item item = this.getItem(i);
                    if (item instanceof IExpandable && ((IExpandable)item).isExpanded()) {
                        expandedItems.add(String.valueOf(item.getIdentifier()));
                    }
                    if (item.isSelected()) {
                        selections.add(String.valueOf(item.getIdentifier()));
                    }
                    AdapterUtil.findSubItemSelections(item, selections);
                }
                savedInstanceState.putStringArrayList(BUNDLE_SELECTIONS + prefix, selections);
                savedInstanceState.putStringArrayList(BUNDLE_EXPANDED + prefix, expandedItems);
            }
        }
        return savedInstanceState;
    }

    private void cacheSizes() {
        this.mAdapterSizes.clear();
        int size = 0;
        int adapterSize = this.mAdapters.size();
        for (int i = 0; i < adapterSize; ++i) {
            IAdapter adapter = (IAdapter)this.mAdapters.valueAt(i);
            if (adapter.getAdapterItemCount() <= 0) continue;
            this.mAdapterSizes.append(size, (Object)adapter);
            size += adapter.getAdapterItemCount();
        }
        if (size == 0 && this.mAdapters.size() > 0) {
            this.mAdapterSizes.append(0, this.mAdapters.valueAt(0));
        }
        this.mGlobalSize = size;
    }

    public Set<Integer> getSelections() {
        if (this.mPositionBasedStateManagement) {
            return this.mSelections;
        }
        ArraySet selections = new ArraySet();
        int size = this.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item item = this.getItem(i);
            if (!item.isSelected()) continue;
            selections.add(i);
        }
        return selections;
    }

    public Set<Item> getSelectedItems() {
        Set<Integer> selections = this.getSelections();
        ArraySet items = new ArraySet(selections.size());
        for (Integer position : selections) {
            items.add(this.getItem(position));
        }
        return items;
    }

    public void toggleSelection(int position) {
        if (this.mPositionBasedStateManagement) {
            if (this.mSelections.contains(position)) {
                this.deselect(position);
            } else {
                this.select(position);
            }
        } else if (this.getItem(position).isSelected()) {
            this.deselect(position);
        } else {
            this.select(position);
        }
    }

    private void handleSelection(View view, Item item, int position) {
        if (!item.isSelectable()) {
            return;
        }
        if (item.isSelected() && !this.mAllowDeselection) {
            return;
        }
        boolean selected = false;
        selected = this.mPositionBasedStateManagement ? this.mSelections.contains(position) : item.isSelected();
        if (this.mSelectWithItemUpdate || view == null) {
            if (!this.mMultiSelect) {
                this.deselect();
            }
            if (selected) {
                this.deselect(position);
            } else {
                this.select(position);
            }
        } else {
            if (!this.mMultiSelect) {
                if (this.mPositionBasedStateManagement) {
                    Iterator<Integer> entries = this.mSelections.iterator();
                    while (entries.hasNext()) {
                        Integer pos = entries.next();
                        if (pos == position) continue;
                        this.deselect(pos, entries);
                    }
                } else {
                    Set<Integer> selections = this.getSelections();
                    for (int pos : selections) {
                        if (pos == position) continue;
                        this.deselect(pos);
                    }
                }
            }
            item.withSetSelected(!selected);
            view.setSelected(!selected);
            if (this.mPositionBasedStateManagement) {
                if (selected) {
                    if (this.mSelections.contains(position)) {
                        this.mSelections.remove(position);
                    }
                } else {
                    this.mSelections.add(position);
                }
            }
            if (this.mSelectionListener != null) {
                this.mSelectionListener.onSelectionChanged(item, !selected);
            }
        }
    }

    public void select(Iterable<Integer> positions) {
        for (Integer position : positions) {
            this.select(position);
        }
    }

    public void select(int position) {
        this.select(position, false);
    }

    public void select(int position, boolean fireEvent) {
        this.select(position, fireEvent, false);
    }

    public void select(int position, boolean fireEvent, boolean considerSelectableFlag) {
        Item item = this.getItem(position);
        if (item == null) {
            return;
        }
        if (considerSelectableFlag && !item.isSelectable()) {
            return;
        }
        item.withSetSelected(true);
        if (this.mPositionBasedStateManagement) {
            this.mSelections.add(position);
        }
        this.notifyItemChanged(position);
        if (this.mSelectionListener != null) {
            this.mSelectionListener.onSelectionChanged(item, true);
        }
        if (this.mOnClickListener != null && fireEvent) {
            this.mOnClickListener.onClick(null, this.getAdapter(position), item, position);
        }
    }

    public void deselect() {
        if (this.mPositionBasedStateManagement) {
            this.deselect(this.mSelections);
        } else {
            for (IItem item : AdapterUtil.getAllItems(this)) {
                if (!item.isSelected()) continue;
                item.withSetSelected(false);
                if (this.mSelectionListener == null) continue;
                this.mSelectionListener.onSelectionChanged(item, false);
            }
            this.notifyDataSetChanged();
        }
    }

    public void select() {
        this.select(false);
    }

    public void select(boolean considerSelectableFlag) {
        if (this.mPositionBasedStateManagement) {
            int size = this.getItemCount();
            for (int i = 0; i < size; ++i) {
                this.select(i, false, considerSelectableFlag);
            }
        } else {
            for (IItem item : AdapterUtil.getAllItems(this)) {
                if (considerSelectableFlag && !item.isSelectable()) continue;
                item.withSetSelected(true);
                if (this.mSelectionListener == null) continue;
                this.mSelectionListener.onSelectionChanged(item, true);
            }
            this.notifyDataSetChanged();
        }
    }

    public void deselect(Iterable<Integer> positions) {
        Iterator<Integer> entries = positions.iterator();
        while (entries.hasNext()) {
            this.deselect(entries.next(), entries);
        }
    }

    public void deselect(int position) {
        this.deselect(position, null);
    }

    private void deselect(int position, Iterator<Integer> entries) {
        Item item = this.getItem(position);
        if (item != null) {
            item.withSetSelected(false);
        }
        if (entries == null) {
            if (this.mPositionBasedStateManagement) {
                this.mSelections.remove(position);
            }
        } else {
            entries.remove();
        }
        this.notifyItemChanged(position);
        if (this.mSelectionListener != null) {
            this.mSelectionListener.onSelectionChanged(item, false);
        }
    }

    public List<Item> deleteAllSelectedItems() {
        ArrayList<Item> deletedItems = new ArrayList<Item>();
        if (this.mPositionBasedStateManagement) {
            Set<Integer> selections = this.getSelections();
            while (selections.size() > 0) {
                Iterator<Integer> iterator = selections.iterator();
                int position = iterator.next();
                IAdapter<Item> adapter = this.getAdapter(position);
                if (adapter != null && adapter instanceof IItemAdapter) {
                    deletedItems.add(this.getItem(position));
                    ((IItemAdapter)adapter).remove(position);
                } else {
                    iterator.remove();
                }
                selections = this.getSelections();
            }
        } else {
            for (int i = this.getItemCount() - 1; i >= 0; --i) {
                RelativeInfo<Item> ri = this.getRelativeInfo(i);
                if (!ri.item.isSelected() || ri.adapter == null || !(ri.adapter instanceof IItemAdapter)) continue;
                ((IItemAdapter)ri.adapter).remove(i);
            }
        }
        return deletedItems;
    }

    public SparseIntArray getExpanded() {
        if (this.mPositionBasedStateManagement) {
            return this.mExpanded;
        }
        SparseIntArray expandedItems = new SparseIntArray();
        int size = this.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item item = this.getItem(i);
            if (!(item instanceof IExpandable) || !((IExpandable)item).isExpanded()) continue;
            expandedItems.put(i, ((IExpandable)item).getSubItems().size());
        }
        return expandedItems;
    }

    public int[] getExpandedItems() {
        int[] expandedItems;
        if (this.mPositionBasedStateManagement) {
            int length = this.mExpanded.size();
            expandedItems = new int[length];
            for (int i = 0; i < length; ++i) {
                expandedItems[i] = this.mExpanded.keyAt(i);
            }
        } else {
            ArrayList<Integer> expandedItemsList = new ArrayList<Integer>();
            int size = this.getItemCount();
            for (int i = 0; i < size; ++i) {
                Item item = this.getItem(i);
                if (!(item instanceof IExpandable) || !((IExpandable)item).isExpanded()) continue;
                expandedItemsList.add(i);
            }
            int expandedItemsListLength = expandedItemsList.size();
            expandedItems = new int[expandedItemsListLength];
            for (int i = 0; i < expandedItemsListLength; ++i) {
                expandedItems[i] = (Integer)expandedItemsList.get(i);
            }
        }
        return expandedItems;
    }

    public void toggleExpandable(int position) {
        if (this.mPositionBasedStateManagement) {
            if (this.mExpanded.indexOfKey(position) >= 0) {
                this.collapse(position);
            } else {
                this.expand(position);
            }
        } else {
            Item item = this.getItem(position);
            if (item instanceof IExpandable && ((IExpandable)item).isExpanded()) {
                this.collapse(position);
            } else {
                this.expand(position);
            }
        }
    }

    public void collapse() {
        this.collapse(true);
    }

    public void collapse(boolean notifyItemChanged) {
        int[] expandedItems = this.getExpandedItems();
        for (int i = expandedItems.length - 1; i >= 0; --i) {
            this.collapse(expandedItems[i], notifyItemChanged);
        }
    }

    public void collapse(int position) {
        this.collapse(position, false);
    }

    public void collapse(int position, boolean notifyItemChanged) {
        IExpandable expandable;
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable && (expandable = (IExpandable)item).isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            if (this.mPositionBasedStateManagement) {
                int totalAddedItems = expandable.getSubItems().size();
                int length = this.mExpanded.size();
                for (int i = 0; i < length; ++i) {
                    if (this.mExpanded.keyAt(i) <= position || this.mExpanded.keyAt(i) > position + totalAddedItems) continue;
                    totalAddedItems += this.mExpanded.get(this.mExpanded.keyAt(i));
                }
                Iterator<Integer> selectionsIterator = this.mSelections.iterator();
                while (selectionsIterator.hasNext()) {
                    Integer value = selectionsIterator.next();
                    if (value <= position || value > position + totalAddedItems) continue;
                    this.deselect(value, selectionsIterator);
                }
                for (int i = length - 1; i >= 0; --i) {
                    if (this.mExpanded.keyAt(i) <= position || this.mExpanded.keyAt(i) > position + totalAddedItems) continue;
                    totalAddedItems -= this.mExpanded.get(this.mExpanded.keyAt(i));
                    this.internalCollapse(this.mExpanded.keyAt(i), notifyItemChanged);
                }
                this.internalCollapse(expandable, position, notifyItemChanged);
            } else {
                IExpandable tmpExpandable;
                Item tmp;
                int i;
                int totalAddedItems = expandable.getSubItems().size();
                for (i = position + 1; i < position + totalAddedItems; ++i) {
                    tmp = this.getItem(i);
                    if (!(tmp instanceof IExpandable) || (tmpExpandable = (IExpandable)tmp).getSubItems() == null || !tmpExpandable.isExpanded()) continue;
                    totalAddedItems += tmpExpandable.getSubItems().size();
                }
                for (i = position + totalAddedItems - 1; i > position; --i) {
                    tmp = this.getItem(i);
                    if (!(tmp instanceof IExpandable) || !(tmpExpandable = (IExpandable)tmp).isExpanded()) continue;
                    this.collapse(i);
                    if (tmpExpandable.getSubItems() == null) continue;
                    i -= tmpExpandable.getSubItems().size();
                }
                this.internalCollapse(expandable, position, notifyItemChanged);
            }
        }
    }

    private void internalCollapse(int position, boolean notifyItemChanged) {
        IExpandable expandable;
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable && (expandable = (IExpandable)item).isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            this.internalCollapse(expandable, position, notifyItemChanged);
        }
    }

    private void internalCollapse(IExpandable expandable, int position, boolean notifyItemChanged) {
        int indexOfKey;
        IAdapter<Item> adapter = this.getAdapter(position);
        if (adapter != null && adapter instanceof IItemAdapter) {
            ((IItemAdapter)adapter).removeRange(position + 1, expandable.getSubItems().size());
        }
        expandable.withIsExpanded(false);
        if (this.mPositionBasedStateManagement && (indexOfKey = this.mExpanded.indexOfKey(position)) >= 0) {
            this.mExpanded.removeAt(indexOfKey);
        }
        if (notifyItemChanged) {
            this.notifyItemChanged(position);
        }
    }

    public void expand() {
        this.expand(false);
    }

    public void expand(boolean notifyItemChanged) {
        int length = this.getItemCount();
        for (int i = length - 1; i >= 0; --i) {
            this.expand(i);
        }
    }

    public void expand(int position) {
        this.expand(position, false);
    }

    public void expand(int position, boolean notifyItemChanged) {
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable) {
            IExpandable expandable = (IExpandable)item;
            if (this.mPositionBasedStateManagement) {
                if (this.mExpanded.indexOfKey(position) < 0 && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
                    IAdapter<Item> adapter = this.getAdapter(position);
                    if (adapter != null && adapter instanceof IItemAdapter) {
                        ((IItemAdapter)adapter).add(position + 1, expandable.getSubItems());
                    }
                    expandable.withIsExpanded(true);
                    if (notifyItemChanged) {
                        this.notifyItemChanged(position);
                    }
                    this.mExpanded.put(position, expandable.getSubItems() != null ? expandable.getSubItems().size() : 0);
                }
            } else if (!expandable.isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
                IAdapter<Item> adapter = this.getAdapter(position);
                if (adapter != null && adapter instanceof IItemAdapter) {
                    ((IItemAdapter)adapter).add(position + 1, expandable.getSubItems());
                }
                expandable.withIsExpanded(true);
                if (notifyItemChanged) {
                    this.notifyItemChanged(position);
                }
            }
        }
    }

    public void notifyAdapterDataSetChanged() {
        if (this.mPositionBasedStateManagement) {
            this.mSelections.clear();
            this.mExpanded.clear();
        }
        this.cacheSizes();
        this.notifyDataSetChanged();
        if (this.mPositionBasedStateManagement) {
            AdapterUtil.handleStates(this, 0, this.getItemCount() - 1);
        }
    }

    public void notifyAdapterItemInserted(int position) {
        this.notifyAdapterItemRangeInserted(position, 1);
    }

    public void notifyAdapterItemRangeInserted(int position, int itemCount) {
        if (this.mPositionBasedStateManagement) {
            this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, itemCount);
            this.mExpanded = AdapterUtil.adjustPosition(this.mExpanded, position, Integer.MAX_VALUE, itemCount);
        }
        this.cacheSizes();
        this.notifyItemRangeInserted(position, itemCount);
        if (this.mPositionBasedStateManagement) {
            AdapterUtil.handleStates(this, position, position + itemCount - 1);
        }
    }

    public void notifyAdapterItemRemoved(int position) {
        this.notifyAdapterItemRangeRemoved(position, 1);
    }

    public void notifyAdapterItemRangeRemoved(int position, int itemCount) {
        if (this.mPositionBasedStateManagement) {
            this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, itemCount * -1);
            this.mExpanded = AdapterUtil.adjustPosition(this.mExpanded, position, Integer.MAX_VALUE, itemCount * -1);
        }
        this.cacheSizes();
        this.notifyItemRangeRemoved(position, itemCount);
    }

    public void notifyAdapterItemMoved(int fromPosition, int toPosition) {
        this.collapse(fromPosition);
        this.collapse(toPosition);
        if (this.mPositionBasedStateManagement) {
            if (!this.mSelections.contains(fromPosition) && this.mSelections.contains(toPosition)) {
                this.mSelections.remove(toPosition);
                this.mSelections.add(fromPosition);
            } else if (this.mSelections.contains(fromPosition) && !this.mSelections.contains(toPosition)) {
                this.mSelections.remove(fromPosition);
                this.mSelections.add(toPosition);
            }
        }
        this.notifyItemMoved(fromPosition, toPosition);
    }

    public void notifyAdapterItemChanged(int position) {
        this.notifyAdapterItemChanged(position, null);
    }

    public void notifyAdapterItemChanged(int position, Object payload) {
        this.notifyAdapterItemRangeChanged(position, 1, payload);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount) {
        this.notifyAdapterItemRangeChanged(position, itemCount, null);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount, Object payload) {
        for (int i = position; i < position + itemCount; ++i) {
            if (this.mPositionBasedStateManagement) {
                if (this.mExpanded.indexOfKey(i) < 0) continue;
                this.collapse(i);
                continue;
            }
            Item item = this.getItem(position);
            if (!(item instanceof IExpandable) || !((IExpandable)item).isExpanded()) continue;
            this.collapse(position);
        }
        if (payload == null) {
            this.notifyItemRangeChanged(position, itemCount);
        } else {
            this.notifyItemRangeChanged(position, itemCount, payload);
        }
        if (this.mPositionBasedStateManagement) {
            AdapterUtil.handleStates(this, position, position + itemCount - 1);
        }
    }

    public void notifyAdapterSubItemsChanged(int position) {
        if (this.mPositionBasedStateManagement) {
            if (this.mExpanded.indexOfKey(position) > -1) {
                int previousCount = this.mExpanded.get(position);
                int itemsCount = this.notifyAdapterSubItemsChanged(position, previousCount);
                if (itemsCount == 0) {
                    this.mExpanded.delete(position);
                } else {
                    this.mExpanded.put(position, itemsCount);
                }
            }
        } else {
            Log.e((String)TAG, (String)"please use the notifyAdapterSubItemsChanged(int position, int previousCount) method instead in the PositionBasedStateManagement mode, as we are not able to calculate the previous count ");
        }
    }

    public int notifyAdapterSubItemsChanged(int position, int previousCount) {
        Item item = this.getItem(position);
        if (item != null && item instanceof IExpandable) {
            IExpandable expandable = (IExpandable)item;
            IAdapter<Item> adapter = this.getAdapter(position);
            if (adapter != null && adapter instanceof IItemAdapter) {
                ((IItemAdapter)adapter).removeRange(position + 1, previousCount);
                ((IItemAdapter)adapter).add(position + 1, expandable.getSubItems());
            }
            return expandable.getSubItems().size();
        }
        return 0;
    }

    public static class RelativeInfo<Item extends IItem> {
        public IAdapter<Item> adapter = null;
        public Item item = null;
        public int position = -1;
    }

    public class OnBindViewHolderListenerImpl
    implements OnBindViewHolderListener {
        @Override
        public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position, List<Object> payloads) {
            Object item = FastAdapter.this.getItem(position);
            if (item != null) {
                item.bindView((RecyclerView.ViewHolder)viewHolder, payloads);
                viewHolder.itemView.setTag(R.id.fastadapter_item, item);
                viewHolder.itemView.setTag(R.id.fastadapter_item_adapter, (Object)FastAdapter.this);
            }
        }

        @Override
        public void unBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
            IItem item = (IItem)viewHolder.itemView.getTag(R.id.fastadapter_item);
            if (item != null) {
                item.unbindView(viewHolder);
                viewHolder.itemView.setTag(R.id.fastadapter_item, null);
                viewHolder.itemView.setTag(R.id.fastadapter_item_adapter, null);
            } else {
                Log.e((String)FastAdapter.TAG, (String)"The bindView method of this item should set the `Tag` on its itemView (https://github.com/mikepenz/FastAdapter/blob/develop/library-core/src/main/java/com/mikepenz/fastadapter/items/AbstractItem.java#L189)");
            }
        }

        @Override
        public void onViewAttachedToWindow(RecyclerView.ViewHolder viewHolder, int position) {
            IItem item = (IItem)viewHolder.itemView.getTag(R.id.fastadapter_item);
            if (item != null) {
                try {
                    item.attachToWindow(viewHolder);
                }
                catch (AbstractMethodError e) {
                    Log.e((String)"WTF", (String)e.toString());
                }
            }
        }

        @Override
        public void onViewDetachedFromWindow(RecyclerView.ViewHolder viewHolder, int position) {
            IItem item = (IItem)viewHolder.itemView.getTag(R.id.fastadapter_item);
            if (item != null) {
                item.detachFromWindow(viewHolder);
            }
        }

        @Override
        public boolean onFailedToRecycleView(RecyclerView.ViewHolder viewHolder, int position) {
            IItem item = (IItem)viewHolder.itemView.getTag(R.id.fastadapter_item);
            return item != null && item.failedToRecycle(viewHolder);
        }
    }

    public static interface OnBindViewHolderListener {
        public void onBindViewHolder(RecyclerView.ViewHolder var1, int var2, List<Object> var3);

        public void unBindViewHolder(RecyclerView.ViewHolder var1, int var2);

        public void onViewAttachedToWindow(RecyclerView.ViewHolder var1, int var2);

        public void onViewDetachedFromWindow(RecyclerView.ViewHolder var1, int var2);

        public boolean onFailedToRecycleView(RecyclerView.ViewHolder var1, int var2);
    }

    public class OnCreateViewHolderListenerImpl
    implements OnCreateViewHolderListener {
        @Override
        public RecyclerView.ViewHolder onPreCreateViewHolder(ViewGroup parent, int viewType) {
            return FastAdapter.this.getTypeInstance(viewType).getViewHolder(parent);
        }

        @Override
        public RecyclerView.ViewHolder onPostCreateViewHolder(RecyclerView.ViewHolder viewHolder) {
            EventHookUtil.bind(viewHolder, FastAdapter.this.eventHooks);
            return viewHolder;
        }
    }

    public static interface OnCreateViewHolderListener {
        public RecyclerView.ViewHolder onPreCreateViewHolder(ViewGroup var1, int var2);

        public RecyclerView.ViewHolder onPostCreateViewHolder(RecyclerView.ViewHolder var1);
    }

    public static interface OnLongClickListener<Item extends IItem> {
        public boolean onLongClick(View var1, IAdapter<Item> var2, Item var3, int var4);
    }

    public static interface OnClickListener<Item extends IItem> {
        public boolean onClick(View var1, IAdapter<Item> var2, Item var3, int var4);
    }

    public static interface OnTouchListener<Item extends IItem> {
        public boolean onTouch(View var1, MotionEvent var2, IAdapter<Item> var3, Item var4, int var5);
    }
}

