/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.items;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IClickable;
import com.mikepenz.fastadapter.IItem;
import java.util.Collections;
import java.util.List;

public abstract class AbstractItem<Item extends IItem & IClickable, VH extends RecyclerView.ViewHolder>
implements IItem<Item, VH>,
IClickable<Item> {
    protected long mIdentifier = -1L;
    protected Object mTag;
    protected boolean mEnabled = true;
    protected boolean mSelected = false;
    protected boolean mSelectable = true;
    protected FastAdapter.OnClickListener<Item> mOnItemPreClickListener;
    protected FastAdapter.OnClickListener<Item> mOnItemClickListener;

    @Override
    public Item withIdentifier(long identifier) {
        this.mIdentifier = identifier;
        return (Item)this;
    }

    @Override
    public long getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public Item withTag(Object object) {
        this.mTag = object;
        return (Item)this;
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    @Override
    public Item withEnabled(boolean enabled) {
        this.mEnabled = enabled;
        return (Item)this;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public Item withSetSelected(boolean selected) {
        this.mSelected = selected;
        return (Item)this;
    }

    @Override
    public boolean isSelected() {
        return this.mSelected;
    }

    @Override
    public Item withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return (Item)this;
    }

    @Override
    public boolean isSelectable() {
        return this.mSelectable;
    }

    @Override
    public Item withOnItemPreClickListener(FastAdapter.OnClickListener<Item> onItemPreClickListener) {
        this.mOnItemPreClickListener = onItemPreClickListener;
        return (Item)this;
    }

    @Override
    public FastAdapter.OnClickListener<Item> getOnPreItemClickListener() {
        return this.mOnItemPreClickListener;
    }

    @Override
    public Item withOnItemClickListener(FastAdapter.OnClickListener<Item> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
        return (Item)this;
    }

    @Override
    public FastAdapter.OnClickListener<Item> getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    @Override
    @CallSuper
    public void bindView(VH holder, List<Object> payloads) {
        ((RecyclerView.ViewHolder)holder).itemView.setSelected(this.isSelected());
        ((RecyclerView.ViewHolder)holder).itemView.setTag((Object)this);
    }

    @Override
    public void unbindView(VH holder) {
    }

    @Override
    public void attachToWindow(VH holder) {
    }

    @Override
    public void detachFromWindow(VH holder) {
    }

    @Override
    public boolean failedToRecycle(VH holder) {
        return false;
    }

    public View createView(Context ctx, @Nullable ViewGroup parent) {
        return LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), parent, false);
    }

    @Override
    public View generateView(Context ctx) {
        VH viewHolder = this.getViewHolder(this.createView(ctx, null));
        this.bindView(viewHolder, Collections.EMPTY_LIST);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public View generateView(Context ctx, ViewGroup parent) {
        VH viewHolder = this.getViewHolder(this.createView(ctx, parent));
        this.bindView(viewHolder, Collections.EMPTY_LIST);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public VH getViewHolder(ViewGroup parent) {
        return this.getViewHolder(this.createView(parent.getContext(), parent));
    }

    public abstract VH getViewHolder(View var1);

    @Override
    public boolean equals(int id) {
        return (long)id == this.mIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractItem that = (AbstractItem)o;
        return this.mIdentifier == that.mIdentifier;
    }

    public int hashCode() {
        return Long.valueOf(this.mIdentifier).hashCode();
    }
}

