/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.helpers;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.listeners.ClickEventHook;
import com.mikepenz.fastadapter.listeners.CustomEventHook;
import com.mikepenz.fastadapter.listeners.EventHook;
import com.mikepenz.fastadapter.listeners.LongClickEventHook;
import com.mikepenz.fastadapter.listeners.TouchEventHook;
import java.util.LinkedList;
import java.util.List;

public class ClickListenerHelper<Item extends IItem> {
    private FastAdapter<Item> mFastAdapter;
    private List<EventHook> eventHooks = new LinkedList<EventHook>();

    public ClickListenerHelper(FastAdapter<Item> fastAdapter) {
        this.mFastAdapter = fastAdapter;
    }

    public ClickListenerHelper(FastAdapter<Item> fastAdapter, List<EventHook> eventHooks) {
        this.mFastAdapter = fastAdapter;
        this.eventHooks = eventHooks;
    }

    public List<EventHook> getEventHooks() {
        return this.eventHooks;
    }

    public ClickListenerHelper<Item> setEventHooks(List<EventHook> eventHooks) {
        this.eventHooks = eventHooks;
        return this;
    }

    public ClickListenerHelper<Item> addEventHook(EventHook eventHook) {
        this.eventHooks.add(eventHook);
        return this;
    }

    public void bind(final @NonNull RecyclerView.ViewHolder viewHolder) {
        for (final EventHook event : this.eventHooks) {
            View view = event.onBind(viewHolder);
            if (view == null) continue;
            if (event instanceof ClickEventHook) {
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int pos = ClickListenerHelper.this.mFastAdapter.getHolderAdapterPosition(viewHolder);
                        if (pos != -1) {
                            ((ClickEventHook)event).onClick(v, pos, ClickListenerHelper.this.mFastAdapter, ClickListenerHelper.this.mFastAdapter.getItem(pos));
                        }
                    }
                });
                continue;
            }
            if (event instanceof LongClickEventHook) {
                view.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        int pos = ClickListenerHelper.this.mFastAdapter.getHolderAdapterPosition(viewHolder);
                        if (pos != -1) {
                            return ((LongClickEventHook)event).onLongClick(v, pos, ClickListenerHelper.this.mFastAdapter, ClickListenerHelper.this.mFastAdapter.getItem(pos));
                        }
                        return false;
                    }
                });
                continue;
            }
            if (event instanceof TouchEventHook) {
                view.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent e) {
                        int pos = ClickListenerHelper.this.mFastAdapter.getHolderAdapterPosition(viewHolder);
                        if (pos != -1) {
                            return ((TouchEventHook)event).onTouch(v, e, pos, ClickListenerHelper.this.mFastAdapter, ClickListenerHelper.this.mFastAdapter.getItem(pos));
                        }
                        return false;
                    }
                });
                continue;
            }
            if (!(event instanceof CustomEventHook)) continue;
            ((CustomEventHook)event).onEvent(this.mFastAdapter, viewHolder, view);
        }
    }
}

