/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import com.mikepenz.fastadapter.IGenericItem;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.utils.DiffCallback;
import com.mikepenz.fastadapter.utils.Function;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GenericItemAdapter<Model, Item extends IGenericItem<? extends Model, ?, ?>>
extends ItemAdapter<Item> {
    private final Function<Model, Item> mItemFactory;

    public GenericItemAdapter(Class<? extends Item> itemClass, Class<? extends Model> modelClass) {
        this(new ReflectionBasedItemFactory<Model, Item>(modelClass, itemClass));
    }

    public GenericItemAdapter(Function<Model, Item> itemFactory) {
        this.mItemFactory = itemFactory;
    }

    public List<Model> getModels() {
        ArrayList models = new ArrayList();
        for (IGenericItem item : this.getAdapterItems()) {
            models.add(item.getModel());
        }
        return models;
    }

    public GenericItemAdapter<Model, Item> setModel(List<Model> models) {
        super.set((List)this.toItems(models));
        return this;
    }

    public GenericItemAdapter<Model, Item> setNewModel(List<Model> models) {
        super.setNewList((List)this.toItems(models));
        return this;
    }

    @SafeVarargs
    public final GenericItemAdapter<Model, Item> addModel(Model ... models) {
        this.addModel(Arrays.asList(models));
        return this;
    }

    public GenericItemAdapter<Model, Item> addModel(List<Model> models) {
        super.add((List)this.toItems(models));
        return this;
    }

    @SafeVarargs
    public final GenericItemAdapter<Model, Item> addModel(int position, Model ... models) {
        this.addModel(position, Arrays.asList(models));
        return this;
    }

    public GenericItemAdapter<Model, Item> addModel(int position, List<Model> models) {
        super.add(position, (List)this.toItems(models));
        return this;
    }

    public GenericItemAdapter<Model, Item> setModel(List<Model> models, DiffCallback<Item> callback, boolean detectMove) {
        this.set(this.toItems(models), callback, detectMove);
        return this;
    }

    public GenericItemAdapter<Model, Item> setModel(int position, Model model) {
        super.set(position, (IItem)this.toItem(model));
        return this;
    }

    public GenericItemAdapter<Model, Item> clearModel() {
        super.clear();
        return this;
    }

    public GenericItemAdapter<Model, Item> moveModel(int fromPosition, int toPosition) {
        super.move(fromPosition, toPosition);
        return this;
    }

    public GenericItemAdapter<Model, Item> removeModelRange(int position, int itemCount) {
        super.removeRange(position, itemCount);
        return this;
    }

    public GenericItemAdapter<Model, Item> removeModel(int position) {
        super.remove(position);
        return this;
    }

    protected List<Item> toItems(List<Model> models) {
        if (models == null) {
            return Collections.emptyList();
        }
        ArrayList<Item> items = new ArrayList<Item>(models.size());
        for (Model model : models) {
            items.add(this.toItem(model));
        }
        return items;
    }

    protected Item toItem(Model model) {
        return (Item)((IGenericItem)this.mItemFactory.apply(model));
    }

    protected static class ReflectionBasedItemFactory<Model, Item>
    implements Function<Model, Item> {
        private final Class<? extends Model> modelClass;
        private final Class<? extends Item> itemClass;

        public ReflectionBasedItemFactory(Class<? extends Model> modelClass, Class<? extends Item> itemClass) {
            this.modelClass = modelClass;
            this.itemClass = itemClass;
        }

        @Override
        public Item apply(Model model) {
            try {
                Constructor<Item> constructor = this.itemClass.getDeclaredConstructor(this.modelClass);
                constructor.setAccessible(true);
                return constructor.newInstance(model);
            }
            catch (Exception e) {
                throw new RuntimeException("Please provide a constructor that takes a model as an argument");
            }
        }
    }
}

