/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import android.util.SparseIntArray;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AdapterUtil {
    public static void handleStates(FastAdapter fastAdapter, int startPosition, int endPosition) {
        for (int i = endPosition; i >= startPosition; --i) {
            Object updateItem = fastAdapter.getItem(i);
            if (updateItem == null) continue;
            if (updateItem.isSelected()) {
                fastAdapter.getSelections().add(i);
            } else if (fastAdapter.getSelections().contains(i)) {
                fastAdapter.getSelections().remove(i);
            }
            if (!(updateItem instanceof IExpandable) || !((IExpandable)updateItem).isExpanded() || fastAdapter.getExpanded().indexOfKey(i) >= 0) continue;
            fastAdapter.expand(i);
        }
    }

    public static SortedSet<Integer> adjustPosition(Set<Integer> positions, int startPosition, int endPosition, int adjustBy) {
        TreeSet<Integer> newPositions = new TreeSet<Integer>();
        for (Integer entry : positions) {
            int position = entry;
            if (position < startPosition || position > endPosition) {
                newPositions.add(position);
                continue;
            }
            if (adjustBy > 0) {
                newPositions.add(position + adjustBy);
                continue;
            }
            if (adjustBy >= 0 || position > startPosition + adjustBy && position <= startPosition) continue;
            newPositions.add(position + adjustBy);
        }
        return newPositions;
    }

    public static SparseIntArray adjustPosition(SparseIntArray positions, int startPosition, int endPosition, int adjustBy) {
        SparseIntArray newPositions = new SparseIntArray();
        int length = positions.size();
        for (int i = 0; i < length; ++i) {
            int position = positions.keyAt(i);
            if (position < startPosition || position > endPosition) {
                newPositions.put(position, positions.valueAt(i));
                continue;
            }
            if (adjustBy > 0) {
                newPositions.put(position + adjustBy, positions.valueAt(i));
                continue;
            }
            if (adjustBy >= 0 || position > startPosition + adjustBy && position <= startPosition) continue;
            newPositions.put(position + adjustBy, positions.valueAt(i));
        }
        return newPositions;
    }

    public static void restoreSubItemSelectionStatesForAlternativeStateManagement(IItem item, List<String> selectedItems) {
        if (item instanceof IExpandable && !((IExpandable)((Object)item)).isExpanded() && ((IExpandable)((Object)item)).getSubItems() != null) {
            List subItems = ((IExpandable)((Object)item)).getSubItems();
            for (IItem subItem : subItems) {
                String id = String.valueOf(subItem.getIdentifier());
                if (selectedItems != null && selectedItems.contains(id)) {
                    subItem.withSetSelected(true);
                }
                AdapterUtil.restoreSubItemSelectionStatesForAlternativeStateManagement(subItem, selectedItems);
            }
        }
    }

    public static void findSubItemSelections(IItem item, List<String> selections) {
        if (item instanceof IExpandable && !((IExpandable)((Object)item)).isExpanded() && ((IExpandable)((Object)item)).getSubItems() != null) {
            List subItems = ((IExpandable)((Object)item)).getSubItems();
            for (IItem subItem : subItems) {
                String id = String.valueOf(subItem.getIdentifier());
                if (subItem.isSelected()) {
                    selections.add(id);
                }
                AdapterUtil.findSubItemSelections(subItem, selections);
            }
        }
    }

    public static List<IItem> getAllItems(FastAdapter fastAdapter) {
        ArrayList<IItem> items = new ArrayList<IItem>();
        int length = fastAdapter.getItemCount();
        for (int i = 0; i < length; ++i) {
            Object item = fastAdapter.getItem(i);
            items.add((IItem)item);
            AdapterUtil.addAllSubItems(item, items);
        }
        return items;
    }

    public static void addAllSubItems(IItem item, List<IItem> items) {
        if (item instanceof IExpandable && !((IExpandable)((Object)item)).isExpanded() && ((IExpandable)((Object)item)).getSubItems() != null) {
            List subItems = ((IExpandable)((Object)item)).getSubItems();
            for (IItem subItem : subItems) {
                items.add(subItem);
                AdapterUtil.addAllSubItems(subItem, items);
            }
        }
    }
}

