/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.items;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IClickable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.utils.ViewHolderFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.List;

public abstract class AbstractItem<Item extends AbstractItem<?, ?>, VH extends RecyclerView.ViewHolder>
implements IItem<Item, VH>,
IClickable<Item> {
    protected long mIdentifier = -1L;
    protected Object mTag;
    protected boolean mEnabled = true;
    protected boolean mSelected = false;
    protected boolean mSelectable = true;
    protected FastAdapter.OnClickListener<Item> mOnItemPreClickListener;
    protected FastAdapter.OnClickListener<Item> mOnItemClickListener;
    protected ViewHolderFactory<? extends VH> mFactory;

    @Override
    public Item withIdentifier(long identifier) {
        this.mIdentifier = identifier;
        return (Item)this;
    }

    @Override
    public long getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public Item withTag(Object object) {
        this.mTag = object;
        return (Item)this;
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    @Override
    public Item withEnabled(boolean enabled) {
        this.mEnabled = enabled;
        return (Item)this;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public Item withSetSelected(boolean selected) {
        this.mSelected = selected;
        return (Item)this;
    }

    @Override
    public boolean isSelected() {
        return this.mSelected;
    }

    @Override
    public Item withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return (Item)this;
    }

    @Override
    public boolean isSelectable() {
        return this.mSelectable;
    }

    @Override
    public Item withOnItemPreClickListener(FastAdapter.OnClickListener<Item> onItemPreClickListener) {
        this.mOnItemPreClickListener = onItemPreClickListener;
        return (Item)this;
    }

    @Override
    public FastAdapter.OnClickListener<Item> getOnPreItemClickListener() {
        return this.mOnItemPreClickListener;
    }

    @Override
    public Item withOnItemClickListener(FastAdapter.OnClickListener<Item> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
        return (Item)this;
    }

    @Override
    public FastAdapter.OnClickListener<Item> getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    @Override
    @CallSuper
    public void bindView(VH holder, List payloads) {
        ((RecyclerView.ViewHolder)holder).itemView.setSelected(this.isSelected());
        ((RecyclerView.ViewHolder)holder).itemView.setTag((Object)this);
    }

    @Override
    public View generateView(Context ctx) {
        VH viewHolder = this.getViewHolder(LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), null, false));
        this.bindView(viewHolder, Collections.EMPTY_LIST);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public View generateView(Context ctx, ViewGroup parent) {
        VH viewHolder = this.getViewHolder(LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), parent, false));
        this.bindView(viewHolder, Collections.EMPTY_LIST);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public VH getViewHolder(ViewGroup parent) {
        return this.getViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutRes(), parent, false));
    }

    public Item withFactory(ViewHolderFactory<? extends VH> factory) {
        this.mFactory = factory;
        return (Item)this;
    }

    public ViewHolderFactory<? extends VH> getFactory() {
        if (this.mFactory == null) {
            try {
                this.mFactory = new ReflectionBasedViewHolderFactory<VH>(this.viewHolderType());
            }
            catch (Exception e) {
                throw new RuntimeException("please set a ViewHolderFactory");
            }
        }
        return this.mFactory;
    }

    protected Class<? extends VH> viewHolderType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
    }

    public VH getViewHolder(View v) {
        return this.getFactory().create(v);
    }

    @Override
    public boolean equals(int id) {
        return (long)id == this.mIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractItem that = (AbstractItem)o;
        return this.mIdentifier == that.mIdentifier;
    }

    public int hashCode() {
        return Long.valueOf(this.mIdentifier).hashCode();
    }

    protected static class ReflectionBasedViewHolderFactory<VH extends RecyclerView.ViewHolder>
    implements ViewHolderFactory<VH> {
        private final Class<? extends VH> clazz;

        public ReflectionBasedViewHolderFactory(Class<? extends VH> clazz) {
            this.clazz = clazz;
        }

        @Override
        public VH create(View v) {
            try {
                try {
                    Constructor<VH> constructor = this.clazz.getDeclaredConstructor(View.class);
                    constructor.setAccessible(true);
                    return (VH)((RecyclerView.ViewHolder)constructor.newInstance(v));
                }
                catch (NoSuchMethodException e) {
                    return (VH)((RecyclerView.ViewHolder)this.clazz.newInstance());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("You have to provide a ViewHolder with a constructor which takes a view!");
            }
        }
    }
}

