/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import android.widget.Filter;
import com.mikepenz.fastadapter.AbstractAdapter;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.utils.IdDistributor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ItemAdapter<Item extends IItem>
extends AbstractAdapter<Item>
implements IItemAdapter<Item> {
    private List<Item> mItems = new ArrayList<Item>();
    private boolean mUseIdDistributor = true;
    private Filter mItemFilter = new ItemFilter();
    private IItemAdapter.Predicate<Item> mFilterPredicate;
    protected ItemFilterListener mItemFilterListener;
    protected Comparator<Item> mComparator;

    public ItemAdapter withUseIdDistributor(boolean useIdDistributor) {
        this.mUseIdDistributor = useIdDistributor;
        return this;
    }

    public boolean isUseIdDistributor() {
        return this.mUseIdDistributor;
    }

    public ItemAdapter<Item> withItemFilter(Filter itemFilter) {
        this.mItemFilter = itemFilter;
        return this;
    }

    public Filter getItemFilter() {
        return this.mItemFilter;
    }

    public ItemAdapter<Item> withFilterPredicate(IItemAdapter.Predicate<Item> filterPredicate) {
        this.mFilterPredicate = filterPredicate;
        return this;
    }

    public void filter(CharSequence constraint) {
        this.mItemFilter.filter(constraint);
    }

    public ItemAdapter<Item> withItemFilterListener(ItemFilterListener listener) {
        this.mItemFilterListener = listener;
        return this;
    }

    public ItemAdapter<Item> withComparator(Comparator<Item> comparator) {
        return this.withComparator(comparator, true);
    }

    public ItemAdapter<Item> withComparator(Comparator<Item> comparator, boolean sortNow) {
        this.mComparator = comparator;
        if (this.mItems != null && this.mComparator != null && sortNow) {
            Collections.sort(this.mItems, this.mComparator);
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    public Comparator<Item> getComparator() {
        return this.mComparator;
    }

    @Override
    public int getOrder() {
        return 500;
    }

    @Override
    public int getAdapterItemCount() {
        return this.mItems.size();
    }

    @Override
    public List<Item> getAdapterItems() {
        return this.mItems;
    }

    @Override
    public int getAdapterPosition(Item item) {
        int length = this.mItems.size();
        for (int i = 0; i < length; ++i) {
            if (((IItem)this.mItems.get(i)).getIdentifier() != item.getIdentifier()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getGlobalPosition(int position) {
        return position + this.getFastAdapter().getPreItemCountByOrder(this.getOrder());
    }

    @Override
    public Item getAdapterItem(int position) {
        return (Item)((IItem)this.mItems.get(position));
    }

    @Override
    public <T> T setSubItems(IExpandable<T, Item> collapsible, List<Item> subItems) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(subItems);
        }
        return collapsible.withSubItems(subItems);
    }

    @Override
    public ItemAdapter<Item> set(List<Item> items) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        this.getFastAdapter().collapse(false);
        int newItemsCount = items.size();
        int previousItemsCount = this.mItems.size();
        int itemsBeforeThisAdapter = this.getFastAdapter().getPreItemCountByOrder(this.getOrder());
        if (items != this.mItems) {
            if (!this.mItems.isEmpty()) {
                this.mItems.clear();
            }
            this.mItems.addAll(items);
        }
        this.mapPossibleTypes(items);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        if (newItemsCount > previousItemsCount) {
            if (previousItemsCount > 0) {
                this.getFastAdapter().notifyAdapterItemRangeChanged(itemsBeforeThisAdapter, previousItemsCount);
            }
            this.getFastAdapter().notifyAdapterItemRangeInserted(itemsBeforeThisAdapter + previousItemsCount, newItemsCount - previousItemsCount);
        } else if (newItemsCount > 0 && newItemsCount < previousItemsCount) {
            this.getFastAdapter().notifyAdapterItemRangeChanged(itemsBeforeThisAdapter, newItemsCount);
            this.getFastAdapter().notifyAdapterItemRangeRemoved(itemsBeforeThisAdapter + newItemsCount, previousItemsCount - newItemsCount);
        } else if (newItemsCount == 0) {
            this.getFastAdapter().notifyAdapterItemRangeRemoved(itemsBeforeThisAdapter, previousItemsCount);
        } else {
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    @Override
    public ItemAdapter<Item> setNewList(List<Item> items) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        this.mItems = new ArrayList<Item>(items);
        this.mapPossibleTypes(this.mItems);
        if (this.mComparator != null) {
            Collections.sort(this.mItems, this.mComparator);
        }
        this.getFastAdapter().notifyAdapterDataSetChanged();
        return this;
    }

    @Override
    @SafeVarargs
    public final ItemAdapter<Item> add(Item ... items) {
        return this.add((List)Arrays.asList(items));
    }

    @Override
    public ItemAdapter<Item> add(List<Item> items) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        int countBefore = this.mItems.size();
        this.mItems.addAll(items);
        this.mapPossibleTypes(items);
        if (this.mComparator == null) {
            this.getFastAdapter().notifyAdapterItemRangeInserted(this.getFastAdapter().getPreItemCountByOrder(this.getOrder()) + countBefore, items.size());
        } else {
            Collections.sort(this.mItems, this.mComparator);
            this.getFastAdapter().notifyAdapterDataSetChanged();
        }
        return this;
    }

    @Override
    @SafeVarargs
    public final ItemAdapter<Item> add(int position, Item ... items) {
        return this.add(position, (List)Arrays.asList(items));
    }

    @Override
    public ItemAdapter<Item> add(int position, List<Item> items) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        if (items != null) {
            this.mItems.addAll(position - this.getFastAdapter().getPreItemCountByOrder(this.getOrder()), items);
            this.mapPossibleTypes(items);
            this.getFastAdapter().notifyAdapterItemRangeInserted(position, items.size());
        }
        return this;
    }

    @Override
    public ItemAdapter<Item> set(int position, Item item) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkId(item);
        }
        this.mItems.set(position - this.getFastAdapter().getPreItemCount(position), item);
        this.mapPossibleType(item);
        this.getFastAdapter().notifyAdapterItemChanged(position);
        return this;
    }

    public ItemAdapter<Item> move(int fromPosition, int toPosition) {
        int preItemCount = this.getFastAdapter().getPreItemCount(fromPosition);
        IItem item = (IItem)this.mItems.get(fromPosition - preItemCount);
        this.mItems.remove(fromPosition - preItemCount);
        this.mItems.add(toPosition - preItemCount, item);
        this.getFastAdapter().notifyAdapterItemMoved(fromPosition, toPosition);
        return this;
    }

    @Override
    public ItemAdapter<Item> remove(int position) {
        this.mItems.remove(position - this.getFastAdapter().getPreItemCount(position));
        this.getFastAdapter().notifyAdapterItemRemoved(position);
        return this;
    }

    @Override
    public ItemAdapter<Item> removeRange(int position, int itemCount) {
        int length = this.mItems.size();
        int preItemCount = this.getFastAdapter().getPreItemCount(position);
        int saveItemCount = Math.min(itemCount, length - position + preItemCount);
        for (int i = 0; i < saveItemCount; ++i) {
            this.mItems.remove(position - preItemCount);
        }
        this.getFastAdapter().notifyAdapterItemRangeRemoved(position, saveItemCount);
        return this;
    }

    @Override
    public ItemAdapter<Item> clear() {
        int count = this.mItems.size();
        this.mItems.clear();
        this.getFastAdapter().notifyAdapterItemRangeRemoved(this.getFastAdapter().getPreItemCountByOrder(this.getOrder()), count);
        return this;
    }

    public class ItemFilter
    extends Filter {
        private List<Item> mOriginalItems;
        private CharSequence mConstraint;

        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            if (ItemAdapter.this.getFastAdapter().isPositionBasedStateManagement()) {
                ItemAdapter.this.getFastAdapter().deselect();
            }
            ItemAdapter.this.getFastAdapter().collapse(false);
            this.mConstraint = constraint;
            if (this.mOriginalItems == null) {
                this.mOriginalItems = new ArrayList(ItemAdapter.this.mItems);
            }
            Filter.FilterResults results = new Filter.FilterResults();
            if (constraint == null || constraint.length() == 0) {
                results.values = this.mOriginalItems;
                results.count = this.mOriginalItems.size();
                this.mOriginalItems = null;
            } else {
                List<IItem> filteredItems = new ArrayList();
                if (ItemAdapter.this.mFilterPredicate != null) {
                    for (IItem item : this.mOriginalItems) {
                        if (ItemAdapter.this.mFilterPredicate.filter(item, constraint)) continue;
                        filteredItems.add(item);
                    }
                } else {
                    filteredItems = ItemAdapter.this.mItems;
                }
                results.values = filteredItems;
                results.count = filteredItems.size();
            }
            return results;
        }

        public CharSequence getConstraint() {
            return this.mConstraint;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            if (results.values != null) {
                ItemAdapter.this.set((List)results.values);
            }
            if (ItemAdapter.this.mItemFilterListener != null) {
                ItemAdapter.this.mItemFilterListener.itemsFiltered();
            }
        }

        public Set<Integer> getSelections() {
            if (this.mOriginalItems != null) {
                HashSet<Integer> selections = new HashSet<Integer>();
                int length = this.mOriginalItems.size();
                int adapterOffset = ItemAdapter.this.getFastAdapter().getPreItemCountByOrder(ItemAdapter.this.getOrder());
                for (int i = 0; i < length; ++i) {
                    IItem item = (IItem)this.mOriginalItems.get(i);
                    if (!item.isSelected()) continue;
                    selections.add(i + adapterOffset);
                }
                return selections;
            }
            return ItemAdapter.this.getFastAdapter().getSelections();
        }

        public Set<Item> getSelectedItems() {
            if (this.mOriginalItems != null) {
                HashSet<IItem> selections = new HashSet<IItem>();
                int length = this.mOriginalItems.size();
                for (int i = 0; i < length; ++i) {
                    IItem item = (IItem)this.mOriginalItems.get(i);
                    if (!item.isSelected()) continue;
                    selections.add(item);
                }
                return selections;
            }
            return ItemAdapter.this.getFastAdapter().getSelectedItems();
        }
    }

    public static interface ItemFilterListener {
        public void itemsFiltered();
    }
}

