/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.IItem;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWrapAdapter<Item extends IItem>
extends RecyclerView.Adapter {
    private List<Item> mItems = new ArrayList<Item>();
    private RecyclerView.Adapter mAdapter;

    public AbstractWrapAdapter(List<Item> items) {
        this.mItems = items;
    }

    public List<Item> getItems() {
        return this.mItems;
    }

    public void setItems(List<Item> items) {
        this.mItems = items;
    }

    public AbstractWrapAdapter wrap(RecyclerView.Adapter adapter) {
        this.mAdapter = adapter;
        return this;
    }

    public abstract boolean shouldInsertItemAtPosition(int var1);

    public abstract int itemInsertedBeforeCount(int var1);

    public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        super.registerAdapterDataObserver(observer);
        if (this.mAdapter != null) {
            this.mAdapter.registerAdapterDataObserver(observer);
        }
    }

    public void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        super.unregisterAdapterDataObserver(observer);
        if (this.mAdapter != null) {
            this.mAdapter.unregisterAdapterDataObserver(observer);
        }
    }

    public int getItemViewType(int position) {
        if (this.shouldInsertItemAtPosition(position)) {
            return this.getItem(position).getType();
        }
        return this.mAdapter.getItemViewType(position - this.itemInsertedBeforeCount(position));
    }

    public long getItemId(int position) {
        if (this.shouldInsertItemAtPosition(position)) {
            return this.getItem(position).getIdentifier();
        }
        return this.mAdapter.getItemId(position - this.itemInsertedBeforeCount(position));
    }

    public RecyclerView.Adapter getAdapter() {
        return this.mAdapter;
    }

    public Item getItem(int position) {
        if (this.shouldInsertItemAtPosition(position)) {
            return (Item)((IItem)this.mItems.get(this.itemInsertedBeforeCount(position - 1)));
        }
        return null;
    }

    public int getItemCount() {
        int itemCount = this.mAdapter.getItemCount();
        return itemCount + this.itemInsertedBeforeCount(itemCount);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        for (IItem item : this.mItems) {
            if (item.getType() != viewType) continue;
            return item.getViewHolder(parent);
        }
        return this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.shouldInsertItemAtPosition(position)) {
            this.getItem(position).bindView((RecyclerView.ViewHolder)holder);
        } else {
            this.mAdapter.onBindViewHolder(holder, position - this.itemInsertedBeforeCount(position));
        }
    }

    public void setHasStableIds(boolean hasStableIds) {
        this.mAdapter.setHasStableIds(hasStableIds);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        this.mAdapter.onViewRecycled(holder);
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        return this.mAdapter.onFailedToRecycleView(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        this.mAdapter.onViewDetachedFromWindow(holder);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        this.mAdapter.onViewAttachedToWindow(holder);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.mAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.mAdapter.onDetachedFromRecyclerView(recyclerView);
    }
}

