/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import android.util.SparseIntArray;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IExpandable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AdapterUtil {
    public static void handleStates(FastAdapter fastAdapter, int startPosition, int endPosition) {
        for (int i = endPosition; i >= startPosition; --i) {
            Object updateItem = fastAdapter.getItem(i);
            if (updateItem.isSelected()) {
                fastAdapter.getSelections().add(i);
            } else if (fastAdapter.getSelections().contains(i)) {
                fastAdapter.getSelections().remove(i);
            }
            if (!(updateItem instanceof IExpandable) || !((IExpandable)updateItem).isExpanded() || fastAdapter.getExpanded().indexOfKey(i) >= 0) continue;
            fastAdapter.expand(i);
        }
    }

    public static SortedSet<Integer> adjustPosition(Set<Integer> positions, int startPosition, int endPosition, int adjustBy) {
        TreeSet<Integer> newPositions = new TreeSet<Integer>();
        for (Integer entry : positions) {
            int position = entry;
            if (position < startPosition || position > endPosition) {
                newPositions.add(position);
                continue;
            }
            if (adjustBy > 0) {
                newPositions.add(position + adjustBy);
                continue;
            }
            if (adjustBy >= 0 || position > startPosition + adjustBy && position <= startPosition) continue;
            newPositions.add(position + adjustBy);
        }
        return newPositions;
    }

    public static SparseIntArray adjustPosition(SparseIntArray positions, int startPosition, int endPosition, int adjustBy) {
        SparseIntArray newPositions = new SparseIntArray();
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.keyAt(i);
            if (position < startPosition || position > endPosition) {
                newPositions.put(position, positions.valueAt(i));
                continue;
            }
            if (adjustBy > 0) {
                newPositions.put(position + adjustBy, positions.valueAt(i));
                continue;
            }
            if (adjustBy >= 0 || position > startPosition + adjustBy && position <= startPosition) continue;
            newPositions.put(position + adjustBy, positions.valueAt(i));
        }
        return newPositions;
    }
}

