/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import android.widget.Filter;
import com.mikepenz.fastadapter.AbstractAdapter;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.utils.IdDistributor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ItemAdapter<Item extends IItem>
extends AbstractAdapter<Item>
implements IItemAdapter<Item> {
    private List<Item> mItems = new ArrayList<Item>();
    private boolean mUseIdDistributor = true;
    private ItemFilter mItemFilter = new ItemFilter();
    private IItemAdapter.Predicate<Item> mFilterPredicate;

    public ItemAdapter withUseIdDistributor(boolean useIdDistributor) {
        this.mUseIdDistributor = useIdDistributor;
        return this;
    }

    public ItemFilter getItemFilter() {
        return this.mItemFilter;
    }

    public ItemAdapter<Item> withFilterPredicate(IItemAdapter.Predicate<Item> filterPredicate) {
        this.mFilterPredicate = filterPredicate;
        return this;
    }

    public void filter(CharSequence constraint) {
        this.mItemFilter.filter(constraint);
    }

    @Override
    public int getOrder() {
        return 500;
    }

    @Override
    public int getAdapterItemCount() {
        return this.mItems.size();
    }

    @Override
    public List<Item> getAdapterItems() {
        return this.mItems;
    }

    @Override
    public int getAdapterPosition(Item item) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (((IItem)this.mItems.get(i)).getIdentifier() != item.getIdentifier()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getGlobalPosition(int position) {
        return position + this.getFastAdapter().getItemCount(this.getOrder());
    }

    @Override
    public Item getAdapterItem(int position) {
        return (Item)((IItem)this.mItems.get(position));
    }

    @Override
    public <T> T setSubItems(IExpandable<T, Item> collapsible, List<Item> subItems) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(subItems);
        }
        return collapsible.withSubItems(subItems);
    }

    @Override
    public void set(List<Item> items) {
        if (!this.mItems.isEmpty()) {
            this.clear();
        }
        this.add((Item)items);
    }

    @Override
    public void add(Item ... items) {
        if (items != null) {
            if (this.mUseIdDistributor) {
                IdDistributor.checkIds(items);
            }
            Collections.addAll(this.mItems, items);
            this.mapPossibleTypes(Arrays.asList(items));
            this.getFastAdapter().notifyAdapterItemRangeInserted(this.getFastAdapter().getItemCount(this.getOrder()), items.length);
        }
    }

    @Override
    public void add(List<Item> items) {
        if (items != null) {
            if (this.mUseIdDistributor) {
                IdDistributor.checkIds(items);
            }
            this.mItems.addAll(items);
            this.mapPossibleTypes(items);
            this.getFastAdapter().notifyAdapterItemRangeInserted(this.getFastAdapter().getItemCount(this.getOrder()), items.size());
        }
    }

    @Override
    public void add(int position, Item ... items) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        if (items != null) {
            this.mItems.addAll(position - this.getFastAdapter().getItemCount(this.getOrder()), Arrays.asList(items));
            this.mapPossibleTypes(Arrays.asList(items));
            this.getFastAdapter().notifyAdapterItemRangeInserted(position, items.length);
        }
    }

    @Override
    public void add(int position, List<Item> items) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkIds(items);
        }
        if (items != null) {
            this.mItems.addAll(position - this.getFastAdapter().getItemCount(this.getOrder()), items);
            this.mapPossibleTypes(items);
            this.getFastAdapter().notifyAdapterItemRangeInserted(position, items.size());
        }
    }

    @Override
    public void set(int position, Item item) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkId(item);
        }
        this.mItems.set(position - this.getFastAdapter().getItemCount(this.getOrder()), item);
        this.mapPossibleType(item);
        this.getFastAdapter().notifyAdapterItemChanged(position);
    }

    @Override
    public void add(Item item) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkId(item);
        }
        this.mItems.add(item);
        this.mapPossibleType(item);
        this.getFastAdapter().notifyAdapterItemInserted(this.getFastAdapter().getItemCount(this.getOrder()) + this.mItems.size());
    }

    @Override
    public void add(int position, Item item) {
        if (this.mUseIdDistributor) {
            IdDistributor.checkId(item);
        }
        this.mItems.add(position - this.getFastAdapter().getItemCount(this.getOrder()), item);
        this.mapPossibleType(item);
        this.getFastAdapter().notifyAdapterItemInserted(position);
    }

    @Override
    public void remove(int position) {
        this.mItems.remove(position - this.getFastAdapter().getItemCount(this.getOrder()));
        this.getFastAdapter().notifyAdapterItemRemoved(position);
    }

    @Override
    public void removeRange(int position, int itemCount) {
        int length = this.mItems.size();
        int saveItemCount = Math.min(itemCount, length - position + this.getFastAdapter().getItemCount(this.getOrder()));
        for (int i = 0; i < saveItemCount; ++i) {
            this.mItems.remove(position - this.getFastAdapter().getItemCount(this.getOrder()));
        }
        this.getFastAdapter().notifyAdapterItemRangeRemoved(position, saveItemCount);
    }

    @Override
    public void clear() {
        int count = this.mItems.size();
        this.mItems.clear();
        this.getFastAdapter().notifyAdapterItemRangeRemoved(this.getFastAdapter().getItemCount(this.getOrder()), count);
    }

    public List<Item> animateTo(List<Item> models) {
        this.applyAndAnimateRemovals(this.mItems, models);
        this.applyAndAnimateAdditions(this.mItems, models);
        this.applyAndAnimateMovedItems(this.mItems, models);
        return this.mItems;
    }

    private void applyAndAnimateRemovals(List<Item> from, List<Item> newModels) {
        for (int i = from.size() - 1; i >= 0; --i) {
            IItem model = (IItem)from.get(i);
            if (newModels.contains(model)) continue;
            this.remove(i + this.getFastAdapter().getItemCount(this.getOrder()));
        }
    }

    private void applyAndAnimateAdditions(List<Item> from, List<Item> newModels) {
        int count = newModels.size();
        for (int i = 0; i < count; ++i) {
            IItem model = (IItem)newModels.get(i);
            if (from.contains(model)) continue;
            this.add(i + this.getFastAdapter().getItemCount(this.getOrder()), (Item)model);
        }
    }

    private void applyAndAnimateMovedItems(List<Item> from, List<Item> newModels) {
        for (int toPosition = newModels.size() - 1; toPosition >= 0; --toPosition) {
            IItem model = (IItem)newModels.get(toPosition);
            int fromPosition = from.indexOf(model);
            if (fromPosition < 0 || fromPosition == toPosition) continue;
            IItem m = (IItem)from.remove(fromPosition);
            from.add(toPosition, m);
            this.getFastAdapter().notifyAdapterItemMoved(fromPosition, toPosition);
        }
    }

    public class ItemFilter
    extends Filter {
        private List<Item> mOriginalItems;

        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            if (this.mOriginalItems == null) {
                this.mOriginalItems = new ArrayList(ItemAdapter.this.mItems);
            }
            Filter.FilterResults results = new Filter.FilterResults();
            if (constraint == null || constraint.length() == 0) {
                results.values = this.mOriginalItems;
                results.count = this.mOriginalItems.size();
            } else {
                List<IItem> filteredItems = new ArrayList();
                if (ItemAdapter.this.mFilterPredicate != null) {
                    for (IItem item : this.mOriginalItems) {
                        if (ItemAdapter.this.mFilterPredicate.filter(item, constraint)) continue;
                        filteredItems.add(item);
                    }
                } else {
                    filteredItems = ItemAdapter.this.mItems;
                }
                results.values = filteredItems;
                results.count = filteredItems.size();
            }
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            ItemAdapter.this.animateTo((List)results.values);
        }
    }
}

