/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.helpers;

import android.support.design.widget.Snackbar;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import java.util.ArrayList;
import java.util.Set;

public class UndoHelper<Item extends IItem> {
    private static final int ACTION_REMOVE = 2;
    private FastAdapter<Item> mAdapter;
    private UndoListener mUndoListener;
    private History mHistory = null;

    public UndoHelper(FastAdapter adapter, UndoListener undoListener) {
        this.mAdapter = adapter;
        this.mUndoListener = undoListener;
    }

    public Snackbar remove(View view, String text, String actionText, int duration, Set<Integer> positions) {
        if (this.mHistory != null) {
            this.notifyCommit();
        }
        History history = new History();
        history.positions = positions;
        history.action = 2;
        for (int position : positions) {
            history.items.add(this.mAdapter.getRelativeInfo(position));
        }
        this.mHistory = history;
        Snackbar snackbar = Snackbar.make((View)view, (CharSequence)text, (int)duration).setCallback(new Snackbar.Callback(){

            public void onDismissed(Snackbar snackbar, int event) {
                super.onDismissed(snackbar, event);
                switch (event) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        UndoHelper.this.notifyCommit();
                    }
                }
            }

            public void onShown(Snackbar snackbar) {
                super.onShown(snackbar);
                UndoHelper.this.doChange();
            }
        }).setAction((CharSequence)actionText, new View.OnClickListener(){

            public void onClick(View v) {
                UndoHelper.this.undoChange();
            }
        });
        snackbar.show();
        return snackbar;
    }

    private void notifyCommit() {
        if (this.mHistory != null && this.mHistory.action == 2) {
            this.mUndoListener.commitRemove(this.mHistory.positions, this.mHistory.items);
            this.mHistory = null;
        }
    }

    private void doChange() {
        if (this.mHistory != null && this.mHistory.action == 2) {
            Integer[] positions = new Integer[this.mHistory.positions.size()];
            this.mHistory.positions.toArray(positions);
            for (int i = positions.length - 1; i >= 0; --i) {
                FastAdapter.RelativeInfo relativeInfo = this.mHistory.items.get(i);
                if (!(relativeInfo.adapter instanceof IItemAdapter)) continue;
                ((IItemAdapter)relativeInfo.adapter).remove(positions[i]);
            }
        }
    }

    private void undoChange() {
        if (this.mHistory != null && this.mHistory.action == 2) {
            int count = 0;
            for (Integer position : this.mHistory.positions) {
                FastAdapter.RelativeInfo relativeInfo = this.mHistory.items.get(count);
                if (relativeInfo.adapter instanceof IItemAdapter) {
                    IItemAdapter adapter = (IItemAdapter)relativeInfo.adapter;
                    adapter.add((int)position, relativeInfo.item);
                    if (relativeInfo.item.isSelected()) {
                        this.mAdapter.select(position);
                    }
                }
                ++count;
            }
        }
        this.mHistory = null;
    }

    private class History {
        public int action;
        public Set<Integer> positions;
        public ArrayList<FastAdapter.RelativeInfo<Item>> items = new ArrayList();

        private History() {
        }
    }

    public static interface UndoListener<Item extends IItem> {
        public void commitRemove(Set<Integer> var1, ArrayList<FastAdapter.RelativeInfo<Item>> var2);
    }
}

