/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.helpers;

import android.support.design.widget.Snackbar;
import android.view.View;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import java.util.ArrayList;

public class UndoHelper<Item extends IItem> {
    private static final int ACTION_REMOVE = 2;
    private IItemAdapter<Item> mItemAdapter;
    private UndoListener mUndoListener;
    private History mHistory = null;

    public UndoHelper(IItemAdapter itemAdapter, UndoListener undoListener) {
        this.mItemAdapter = itemAdapter;
        this.mUndoListener = undoListener;
    }

    public Snackbar remove(View view, String text, String actionText, int duration, int position, int itemCount) {
        if (this.mHistory != null) {
            this.notifyCommit();
        }
        History history = new History();
        history.position = position;
        history.action = 2;
        for (int i = position; i < position + itemCount; ++i) {
            history.items.add(this.mItemAdapter.getAdapterItem(i));
        }
        this.mHistory = history;
        Snackbar snackbar = Snackbar.make((View)view, (CharSequence)text, (int)duration).setCallback(new Snackbar.Callback(){

            public void onDismissed(Snackbar snackbar, int event) {
                super.onDismissed(snackbar, event);
                switch (event) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        UndoHelper.this.notifyCommit();
                    }
                }
            }

            public void onShown(Snackbar snackbar) {
                super.onShown(snackbar);
                UndoHelper.this.doChange();
            }
        }).setAction((CharSequence)actionText, new View.OnClickListener(){

            public void onClick(View v) {
                UndoHelper.this.undoChange();
            }
        });
        snackbar.show();
        return snackbar;
    }

    private void notifyCommit() {
        if (this.mHistory != null && this.mHistory.action == 2) {
            this.mUndoListener.commitRemove(this.mHistory.position, this.mHistory.items);
            this.mHistory = null;
        }
    }

    private void doChange() {
        if (this.mHistory != null && this.mHistory.action == 2) {
            if (this.mHistory.items.size() == 1) {
                this.mItemAdapter.remove(this.mHistory.position);
            } else {
                this.mItemAdapter.removeItemRange(this.mHistory.position, this.mHistory.items.size());
            }
        }
    }

    private void undoChange() {
        if (this.mHistory != null && this.mHistory.action == 2) {
            if (this.mHistory.items.size() == 1) {
                this.mItemAdapter.add(this.mHistory.position, (IItem)this.mHistory.items.get(0));
            } else {
                this.mItemAdapter.add(this.mHistory.position, this.mHistory.items);
            }
        }
        this.mHistory = null;
    }

    private class History {
        public int action;
        public int position;
        public ArrayList<Item> items = new ArrayList();

        private History() {
        }
    }

    public static interface UndoListener {
        public void commitRemove(int var1, ArrayList<? extends IItem> var2);
    }
}

