/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.items;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.utils.ViewHolderFactory;
import java.lang.reflect.ParameterizedType;

public abstract class AbstractItem<T, VH extends RecyclerView.ViewHolder>
implements IItem<T> {
    protected int mIdentifier = -1;
    protected Object mTag;
    protected boolean mEnabled = true;
    protected boolean mSelected = false;
    protected boolean mSelectable = true;

    @Override
    public T withIdentifier(int identifier) {
        this.mIdentifier = identifier;
        return (T)this;
    }

    @Override
    public int getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public T withTag(Object object) {
        this.mTag = object;
        return (T)this;
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    @Override
    public T withEnabled(boolean enabled) {
        this.mEnabled = enabled;
        return (T)this;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public T withSetSelected(boolean selected) {
        this.mSelected = selected;
        return (T)this;
    }

    @Override
    public boolean isSelected() {
        return this.mSelected;
    }

    @Override
    public T withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return (T)this;
    }

    @Override
    public boolean isSelectable() {
        return this.mSelectable;
    }

    @Override
    public View generateView(Context ctx) {
        VH viewHolder = this.getViewHolder(LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), null, false));
        this.bindView((RecyclerView.ViewHolder)viewHolder);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public View generateView(Context ctx, ViewGroup parent) {
        VH viewHolder = this.getViewHolder(LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), parent, false));
        this.bindView((RecyclerView.ViewHolder)viewHolder);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public RecyclerView.ViewHolder getViewHolder(ViewGroup parent) {
        return this.getViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutRes(), parent, false));
    }

    public ViewHolderFactory getFactory() {
        return null;
    }

    public VH getViewHolder(View v) {
        ViewHolderFactory viewHolderFactory = this.getFactory();
        if (viewHolderFactory != null) {
            return (VH)viewHolderFactory.create(v);
        }
        try {
            return (VH)((RecyclerView.ViewHolder)((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1]).getDeclaredConstructor(View.class).newInstance(v));
        }
        catch (Exception e) {
            throw new RuntimeException("something really bad happened. if this happens more often, head over to GitHub and read how to switch to the ViewHolderFactory");
        }
    }

    @Override
    public boolean equals(Integer id) {
        return id != null && id == this.mIdentifier;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractItem that = (AbstractItem)o;
        return this.mIdentifier == that.mIdentifier;
    }

    public int hashCode() {
        return this.mIdentifier;
    }
}

