/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter;

import android.os.Bundle;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.AbstractAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.ICollapsible;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.utils.AdapterUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class FastAdapter<Item extends IItem>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected static final String BUNDLE_SELECTIONS = "bundle_selections";
    protected static final String BUNDLE_COLLAPSIBLE = "bundle_collapsible";
    private ArrayMap<Integer, IAdapter> mAdapters = new ArrayMap();
    private ArrayMap<Integer, Item> mTypeInstances = new ArrayMap();
    private boolean mMultiSelect = false;
    private boolean mMultiSelectOnLongClick = true;
    private SortedSet<Integer> mSelections = new TreeSet<Integer>();
    private SparseIntArray mCollapsibleOpened = new SparseIntArray();
    private OnClickListener mOnClickListener;
    private OnLongClickListener mOnLongClickListener;
    private OnTouchListener mOnTouchListener;

    public FastAdapter() {
        this.setHasStableIds(true);
    }

    public FastAdapter withOnClickListener(OnClickListener mOnClickListener) {
        this.mOnClickListener = mOnClickListener;
        return this;
    }

    public FastAdapter withOnLongClickListener(OnLongClickListener mOnLongClickListener) {
        this.mOnLongClickListener = mOnLongClickListener;
        return this;
    }

    public FastAdapter withOnTouchListener(OnTouchListener mOnTouchListener) {
        this.mOnTouchListener = mOnTouchListener;
        return this;
    }

    public FastAdapter withMultiSelect(boolean multiSelect) {
        this.mMultiSelect = multiSelect;
        return this;
    }

    public FastAdapter withMultiSelectOnLongClick(boolean multiSelectOnLongClick) {
        this.mMultiSelectOnLongClick = multiSelectOnLongClick;
        return this;
    }

    public FastAdapter withSavedInstanceState(Bundle savedInstanceState) {
        return this.withSavedInstanceState(savedInstanceState, "");
    }

    public FastAdapter withSavedInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null) {
            int[] selections;
            int n;
            this.deselect();
            int[] collapsibles = savedInstanceState.getIntArray(BUNDLE_COLLAPSIBLE + prefix);
            if (collapsibles != null) {
                int[] nArray = collapsibles;
                int n2 = nArray.length;
                for (n = 0; n < n2; ++n) {
                    Integer collapsible = nArray[n];
                    this.open(collapsible);
                }
            }
            if ((selections = savedInstanceState.getIntArray(BUNDLE_SELECTIONS + prefix)) != null) {
                int[] nArray = selections;
                n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer selection = nArray[i];
                    this.select(selection);
                }
            }
        }
        return this;
    }

    public <A extends AbstractAdapter> void registerAdapter(A adapter) {
        if (!this.mAdapters.containsKey((Object)adapter.getOrder())) {
            this.mAdapters.put((Object)adapter.getOrder(), adapter);
        }
    }

    public void registerTypeInstance(Item item) {
        if (!this.mTypeInstances.containsKey((Object)item.getType())) {
            this.mTypeInstances.put((Object)item.getType(), item);
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        final RecyclerView.ViewHolder holder = ((IItem)this.mTypeInstances.get((Object)viewType)).getViewHolder(parent);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int pos = holder.getAdapterPosition();
                if (pos != -1) {
                    boolean consumed = false;
                    RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                    if (relativeInfo.item != null && ((IItem)relativeInfo.item).isEnabled()) {
                        if (FastAdapter.this.mOnClickListener != null) {
                            consumed = FastAdapter.this.mOnClickListener.onClick(v, relativeInfo.adapter, (IItem)relativeInfo.item, pos);
                        }
                        if (!(consumed || FastAdapter.this.mMultiSelect && FastAdapter.this.mMultiSelectOnLongClick && FastAdapter.this.mMultiSelect)) {
                            FastAdapter.this.handleSelection((IItem)relativeInfo.item, pos);
                        }
                    }
                }
            }
        });
        holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                int pos = holder.getAdapterPosition();
                if (pos != -1) {
                    boolean consumed = false;
                    RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                    if (relativeInfo.item != null && ((IItem)relativeInfo.item).isEnabled()) {
                        if (FastAdapter.this.mOnLongClickListener != null) {
                            consumed = FastAdapter.this.mOnLongClickListener.onLongClick(v, relativeInfo.adapter, (IItem)relativeInfo.item, pos);
                        }
                        if (!consumed && FastAdapter.this.mMultiSelect && FastAdapter.this.mMultiSelectOnLongClick) {
                            FastAdapter.this.handleSelection((IItem)relativeInfo.item, pos);
                        }
                    }
                    return consumed;
                }
                return false;
            }
        });
        holder.itemView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int pos;
                if (FastAdapter.this.mOnTouchListener != null && (pos = holder.getAdapterPosition()) != -1) {
                    RelativeInfo relativeInfo = FastAdapter.this.getRelativeInfo(pos);
                    return FastAdapter.this.mOnTouchListener.onTouch(v, event, relativeInfo.adapter, (IItem)relativeInfo.item, pos);
                }
                return false;
            }
        });
        return holder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        this.getItem(position).bindView(holder);
    }

    public int getPosition(Item item) {
        if (item.getIdentifier() == -1) {
            Log.e((String)"FastAdapter", (String)"You have to define an identifier for your item to retrieve the position via this method");
            return -1;
        }
        int position = 0;
        int length = this.mAdapters.size();
        for (int i = 0; i < length; ++i) {
            IAdapter adapter = (IAdapter)this.mAdapters.valueAt(i);
            if (adapter.getOrder() < 0) continue;
            int relativePosition = adapter.getAdapterPosition(item);
            if (relativePosition != -1) {
                return position + relativePosition;
            }
            position = adapter.getAdapterItemCount();
        }
        return -1;
    }

    public Item getItem(int position) {
        return (Item)((IItem)this.getRelativeInfo((int)position).item);
    }

    public RelativeInfo<Item> getRelativeInfo(int position) {
        if (position < 0) {
            return new RelativeInfo();
        }
        RelativeInfo relativeInfo = new RelativeInfo();
        IAdapter adapter = this.getAdapter(position);
        if (adapter != null) {
            relativeInfo.item = adapter.getAdapterItem(position - this.getItemCount(adapter.getOrder()));
            relativeInfo.adapter = adapter;
        }
        return relativeInfo;
    }

    public IAdapter getAdapter(int position) {
        int currentCount = 0;
        int length = this.mAdapters.size();
        for (int i = 0; i < length; ++i) {
            IAdapter adapter = (IAdapter)this.mAdapters.valueAt(i);
            if (adapter.getOrder() < 0) continue;
            if (currentCount <= position && currentCount + adapter.getAdapterItemCount() > position) {
                return adapter;
            }
            currentCount += adapter.getAdapterItemCount();
        }
        return null;
    }

    public int getItemViewType(int position) {
        return this.getItem(position).getType();
    }

    public long getItemId(int position) {
        return this.getItem(position).getIdentifier();
    }

    public int getItemCount() {
        int size = 0;
        int length = this.mAdapters.size();
        for (int i = 0; i < length; ++i) {
            IAdapter adapter = (IAdapter)this.mAdapters.valueAt(i);
            if (adapter.getOrder() < 0) continue;
            size += adapter.getAdapterItemCount();
        }
        return size;
    }

    public int getItemCount(int order) {
        int size = 0;
        int length = this.mAdapters.size();
        for (int i = 0; i < length; ++i) {
            IAdapter adapter = (IAdapter)this.mAdapters.valueAt(i);
            if (adapter.getOrder() < 0) continue;
            if (adapter.getOrder() < order) {
                size = adapter.getAdapterItemCount();
                continue;
            }
            return size;
        }
        return size;
    }

    public Bundle saveInstanceState(Bundle savedInstanceState) {
        return this.saveInstanceState(savedInstanceState, "");
    }

    public Bundle saveInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null) {
            int[] selections = new int[this.mSelections.size()];
            int index = 0;
            for (Integer selection : this.mSelections) {
                selections[index] = selection;
                ++index;
            }
            savedInstanceState.putIntArray(BUNDLE_SELECTIONS + prefix, selections);
            savedInstanceState.putIntArray(BUNDLE_COLLAPSIBLE + prefix, this.getOpenedCollapsibleItems());
        }
        return savedInstanceState;
    }

    public Set<Integer> getSelections() {
        return this.mSelections;
    }

    public void toggleSelection(int position) {
        if (this.mSelections.contains(position)) {
            this.deselect(position);
        } else {
            this.select(position);
        }
    }

    private void handleSelection(Item item, int position) {
        if (!item.isSelectable()) {
            return;
        }
        if (!this.mMultiSelect) {
            Iterator<Integer> entries = this.mSelections.iterator();
            while (entries.hasNext()) {
                this.deselect((Integer)entries.next(), entries);
            }
        }
        if (this.mSelections.contains(position)) {
            this.deselect(position);
        } else {
            this.select(position);
        }
    }

    public void select(int position) {
        this.select(position, false);
    }

    public void select(int position, boolean fireEvent) {
        Item item = this.getItem(position);
        if (item != null) {
            item.withSetSelected(true);
            this.mSelections.add(position);
        }
        this.notifyItemChanged(position);
        if (this.mOnClickListener != null && fireEvent) {
            this.mOnClickListener.onClick(null, this.getAdapter(position), (IItem)item, position);
        }
    }

    public void deselect(int position) {
        this.deselect(position, null);
    }

    private void deselect(int position, Iterator<Integer> entries) {
        Item item = this.getItem(position);
        if (item != null) {
            item.withSetSelected(false);
        }
        if (entries == null) {
            if (this.mSelections.contains(position)) {
                this.mSelections.remove(position);
            }
        } else {
            entries.remove();
        }
        this.notifyItemChanged(position);
    }

    public void deselect() {
        Iterator<Integer> entries = this.mSelections.iterator();
        while (entries.hasNext()) {
            this.deselect((Integer)entries.next(), entries);
        }
    }

    public List<Item> deleteAllSelectedItems() {
        LinkedList<Item> deletedItems = new LinkedList<Item>();
        Set<Integer> selections = this.getSelections();
        while (selections.size() > 0) {
            Iterator<Integer> iterator = selections.iterator();
            int position = iterator.next();
            IAdapter adapter = this.getAdapter(position);
            if (adapter != null && adapter instanceof IItemAdapter) {
                deletedItems.add(this.getItem(position));
                ((IItemAdapter)adapter).remove(position);
            } else {
                iterator.remove();
            }
            selections = this.getSelections();
        }
        return deletedItems;
    }

    public int[] getOpenedCollapsibleItems() {
        int[] collapsibleItems = new int[this.mCollapsibleOpened.size()];
        int length = this.mCollapsibleOpened.size();
        for (int i = 0; i < length; ++i) {
            collapsibleItems[i] = this.mCollapsibleOpened.keyAt(i);
        }
        return collapsibleItems;
    }

    public void toggleCollapsible(int position) {
        if (this.mCollapsibleOpened.indexOfKey(position) >= 0) {
            this.collapse(position);
        } else {
            this.open(position);
        }
    }

    public void collapse(int position) {
        ICollapsible collapsible;
        Item item = this.getItem(position);
        if (item != null && item instanceof ICollapsible && !(collapsible = (ICollapsible)item).isCollapsed() && collapsible.getSubItems() != null && collapsible.getSubItems().size() > 0) {
            int totalAddedItems = collapsible.getSubItems().size();
            int length = this.mCollapsibleOpened.size();
            for (int i = 0; i < length; ++i) {
                if (this.mCollapsibleOpened.keyAt(i) <= position || this.mCollapsibleOpened.keyAt(i) > position + totalAddedItems) continue;
                totalAddedItems += this.mCollapsibleOpened.get(this.mCollapsibleOpened.keyAt(i));
            }
            for (Integer value : this.mSelections) {
                if (value <= position || value > position + totalAddedItems) continue;
                this.deselect(value);
            }
            for (int i = length - 1; i >= 0; --i) {
                if (this.mCollapsibleOpened.keyAt(i) <= position || this.mCollapsibleOpened.keyAt(i) > position + totalAddedItems) continue;
                totalAddedItems -= this.mCollapsibleOpened.get(this.mCollapsibleOpened.keyAt(i));
                this.internalCollapse(this.mCollapsibleOpened.keyAt(i));
            }
            this.internalCollapse(collapsible, position);
        }
    }

    private void internalCollapse(int position) {
        ICollapsible collapsible;
        Item item = this.getItem(position);
        if (item != null && item instanceof ICollapsible && !(collapsible = (ICollapsible)item).isCollapsed() && collapsible.getSubItems() != null && collapsible.getSubItems().size() > 0) {
            this.internalCollapse(collapsible, position);
        }
    }

    private void internalCollapse(ICollapsible collapsible, int position) {
        IAdapter adapter = this.getAdapter(position);
        if (adapter != null && adapter instanceof IItemAdapter) {
            ((IItemAdapter)adapter).removeItemRange(position + 1, collapsible.getSubItems().size());
        }
        collapsible.withCollapsed(true);
        int indexOfKey = this.mCollapsibleOpened.indexOfKey(position);
        if (indexOfKey >= 0) {
            this.mCollapsibleOpened.removeAt(indexOfKey);
        }
    }

    public void open(int position) {
        ICollapsible collapsible;
        Item item = this.getItem(position);
        if (item != null && item instanceof ICollapsible && (collapsible = (ICollapsible)item).isCollapsed() && collapsible.getSubItems() != null && collapsible.getSubItems().size() > 0) {
            IAdapter adapter = this.getAdapter(position);
            if (adapter != null && adapter instanceof IItemAdapter) {
                ((IItemAdapter)adapter).add(position + 1, collapsible.getSubItems());
            }
            collapsible.withCollapsed(false);
            this.mCollapsibleOpened.put(position, collapsible.getSubItems() != null ? collapsible.getSubItems().size() : 0);
        }
    }

    public void notifyAdapterItemInserted(int position) {
        this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, 1);
        this.mCollapsibleOpened = AdapterUtil.adjustPosition(this.mCollapsibleOpened, position, Integer.MAX_VALUE, 1);
        this.notifyItemInserted(position);
    }

    public void notifyAdapterItemRangeInserted(int position, int itemCount) {
        this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, itemCount);
        this.mCollapsibleOpened = AdapterUtil.adjustPosition(this.mCollapsibleOpened, position, Integer.MAX_VALUE, itemCount);
        this.notifyItemRangeInserted(position, itemCount);
    }

    public void notifyAdapterItemRemoved(int position) {
        this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, -1);
        this.mCollapsibleOpened = AdapterUtil.adjustPosition(this.mCollapsibleOpened, position, Integer.MAX_VALUE, -1);
        this.notifyItemRemoved(position);
    }

    public void notifyAdapterItemRangeRemoved(int position, int itemCount) {
        this.mSelections = AdapterUtil.adjustPosition(this.mSelections, position, Integer.MAX_VALUE, itemCount * -1);
        this.mCollapsibleOpened = AdapterUtil.adjustPosition(this.mCollapsibleOpened, position, Integer.MAX_VALUE, itemCount * -1);
        this.notifyItemRangeRemoved(position, itemCount);
    }

    public void notifyAdapterItemMoved(int fromPosition, int toPosition) {
        if (this.mSelections.contains(fromPosition)) {
            this.mSelections.remove(fromPosition);
            this.mSelections.add(toPosition);
        }
        if (fromPosition < toPosition) {
            this.mSelections = AdapterUtil.adjustPosition(this.mSelections, fromPosition, toPosition, -1);
            this.mCollapsibleOpened = AdapterUtil.adjustPosition(this.mCollapsibleOpened, fromPosition, toPosition, -1);
        } else {
            this.mSelections = AdapterUtil.adjustPosition(this.mSelections, toPosition, fromPosition, 1);
            this.mCollapsibleOpened = AdapterUtil.adjustPosition(this.mCollapsibleOpened, toPosition, fromPosition, 1);
        }
        this.notifyItemMoved(fromPosition, toPosition);
    }

    public void notifyAdapterItemChanged(int position) {
        this.notifyAdapterItemChanged(position, null);
    }

    public void notifyAdapterItemChanged(int position, Object payload) {
        Item updateItem = this.getItem(position);
        if (updateItem.isSelected()) {
            this.mSelections.add(position);
        } else if (this.mSelections.contains(position)) {
            this.mSelections.remove(position);
        }
        if (payload == null) {
            this.notifyItemChanged(position);
        } else {
            this.notifyItemChanged(position, payload);
        }
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount) {
        this.notifyAdapterItemRangeChanged(position, itemCount, null);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount, Object payload) {
        for (int i = position; i < position + itemCount; ++i) {
            Item updateItem = this.getItem(position);
            if (updateItem.isSelected()) {
                this.mSelections.add(position);
                continue;
            }
            if (!this.mSelections.contains(position)) continue;
            this.mSelections.remove(position);
        }
        if (payload == null) {
            this.notifyItemRangeChanged(position, itemCount);
        } else {
            this.notifyItemRangeChanged(position, itemCount, payload);
        }
    }

    public static class RelativeInfo<Item> {
        public IAdapter adapter = null;
        public Item item = null;
    }

    public static interface OnLongClickListener {
        public boolean onLongClick(View var1, IAdapter var2, IItem var3, int var4);
    }

    public static interface OnClickListener {
        public boolean onClick(View var1, IAdapter var2, IItem var3, int var4);
    }

    public static interface OnTouchListener {
        public boolean onTouch(View var1, MotionEvent var2, IAdapter var3, IItem var4, int var5);
    }
}

