/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.swipe;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.swipe.ExtensionsKt;
import com.mikepenz.fastadapter.swipe.IDrawerSwipeableViewHolder;
import com.mikepenz.fastadapter.swipe.ISwipeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u000201B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J@\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\bH\u0017J \u0010&\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aH\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\rJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\rJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00030\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0003`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback;", "Landroidx/recyclerview/widget/ItemTouchHelper$SimpleCallback;", "swipeDirs", "", "itemSwipeCallback", "Lcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback$ItemSwipeCallback;", "(ILcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback$ItemSwipeCallback;)V", "isSwiping", "", "()Z", "setSwiping", "(Z)V", "sensitivityFactor", "", "surfaceThreshold", "swipeWidthLeftDp", "swipeWidthRightDp", "swipedStates", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "touchTransmitterSet", "getSwipeDirs", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "getSwipeEscapeVelocity", "defaultValue", "getSwipeThreshold", "onChildDraw", "", "c", "Landroid/graphics/Canvas;", "dX", "dY", "actionState", "isCurrentlyActive", "onMove", "target", "onSwiped", "direction", "withSensitivity", "f", "withSurfaceThreshold", "withSwipeLeft", "widthDp", "withSwipeRight", "ItemSwipeCallback", "RecyclerTouchTransmitter", "fastadapter-extensions-swipe"})
public final class SimpleSwipeDrawerCallback
extends ItemTouchHelper.SimpleCallback {
    private final int swipeDirs;
    @Nullable
    private final ItemSwipeCallback itemSwipeCallback;
    private float sensitivityFactor;
    private float surfaceThreshold;
    private int swipeWidthLeftDp;
    private int swipeWidthRightDp;
    private boolean touchTransmitterSet;
    @NotNull
    private final HashMap<Long, Integer> swipedStates;
    private boolean isSwiping;

    @JvmOverloads
    public SimpleSwipeDrawerCallback(int swipeDirs, @Nullable ItemSwipeCallback itemSwipeCallback) {
        super(0, swipeDirs);
        this.swipeDirs = swipeDirs;
        this.itemSwipeCallback = itemSwipeCallback;
        this.sensitivityFactor = 1.0f;
        this.surfaceThreshold = 0.5f;
        this.swipeWidthLeftDp = 20;
        this.swipeWidthRightDp = 20;
        this.swipedStates = new HashMap();
    }

    public /* synthetic */ SimpleSwipeDrawerCallback(int n, ItemSwipeCallback itemSwipeCallback, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        if ((n2 & 2) != 0) {
            itemSwipeCallback = null;
        }
        this(n, itemSwipeCallback);
    }

    public final boolean isSwiping() {
        return this.isSwiping;
    }

    public final void setSwiping(boolean bl) {
        this.isSwiping = bl;
    }

    @NotNull
    public final SimpleSwipeDrawerCallback withSwipeLeft(int widthDp) {
        this.swipeWidthLeftDp = widthDp;
        this.setDefaultSwipeDirs(this.swipeDirs | 4);
        return this;
    }

    @NotNull
    public final SimpleSwipeDrawerCallback withSwipeRight(int widthDp) {
        this.swipeWidthRightDp = widthDp;
        this.setDefaultSwipeDirs(this.swipeDirs | 8);
        return this;
    }

    @NotNull
    public final SimpleSwipeDrawerCallback withSensitivity(float f) {
        this.sensitivityFactor = f;
        return this;
    }

    @NotNull
    public final SimpleSwipeDrawerCallback withSurfaceThreshold(float f) {
        this.surfaceThreshold = f;
        return this;
    }

    public int getSwipeDirs(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        IItem item = FastAdapter.Companion.getHolderAdapterItem(viewHolder);
        return item instanceof ISwipeable ? (((ISwipeable)item).isSwipeable() ? ExtensionsKt.getSwipeDirs((ISwipeable)item, super.getSwipeDirs(recyclerView, viewHolder)) : 0) : super.getSwipeDirs(recyclerView, viewHolder);
    }

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int direction) {
        block4: {
            long id;
            int position;
            block5: {
                Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
                position = viewHolder.getBindingAdapterPosition();
                id = viewHolder.getItemId();
                if (position == -1) break block4;
                if (!this.swipedStates.containsKey(id)) break block5;
                Integer n = this.swipedStates.get(id);
                int n2 = direction;
                if (n != null && n == n2) break block4;
            }
            ItemSwipeCallback itemSwipeCallback = this.itemSwipeCallback;
            if (itemSwipeCallback != null) {
                itemSwipeCallback.itemSwiped(position, direction);
            }
            Long l = id;
            Integer n = direction;
            ((Map)this.swipedStates).put(l, n);
            this.isSwiping = false;
        }
    }

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, @NotNull RecyclerView.ViewHolder target) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return false;
    }

    public float getSwipeEscapeVelocity(float defaultValue) {
        return defaultValue * this.sensitivityFactor;
    }

    public float getSwipeThreshold(@NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        return this.swipedStates.containsKey(viewHolder.getItemId()) ? 1.0f - this.surfaceThreshold : this.surfaceThreshold;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void onChildDraw(@NotNull Canvas c, @NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        int position;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        View view = viewHolder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"viewHolder.itemView");
        View itemView = view;
        if (!this.touchTransmitterSet) {
            recyclerView.setOnTouchListener((View.OnTouchListener)new RecyclerTouchTransmitter());
            this.touchTransmitterSet = true;
        }
        if ((position = viewHolder.getBindingAdapterPosition()) == -1) {
            return;
        }
        if (actionState == 1) {
            boolean isLeftArea = dX < 0.0f;
            float dXPercent = dX / (float)recyclerView.getWidth();
            if (0.0f == dX && this.swipedStates.containsKey(viewHolder.getItemId())) {
                ItemSwipeCallback itemSwipeCallback = this.itemSwipeCallback;
                if (itemSwipeCallback != null) {
                    itemSwipeCallback.itemUnswiped(viewHolder.getBindingAdapterPosition());
                }
                this.swipedStates.remove(viewHolder.getItemId());
            }
            this.isSwiping = Math.abs(dXPercent) > 0.0f && Math.abs(dXPercent) < 1.0f;
            View swipeableView = itemView;
            if (viewHolder instanceof IDrawerSwipeableViewHolder) {
                swipeableView = ((IDrawerSwipeableViewHolder)viewHolder).getSwipeableView();
            }
            float swipeWidthPc = recyclerView.getContext().getResources().getDisplayMetrics().density * (float)(isLeftArea ? this.swipeWidthLeftDp : this.swipeWidthRightDp);
            swipeableView.setTranslationX(dXPercent * swipeWidthPc);
        } else {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
    }

    @JvmOverloads
    public SimpleSwipeDrawerCallback(int swipeDirs) {
        this(swipeDirs, null, 2, null);
    }

    @JvmOverloads
    public SimpleSwipeDrawerCallback() {
        this(0, null, 3, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback$ItemSwipeCallback;", "", "itemSwiped", "", "position", "", "direction", "itemUnswiped", "fastadapter-extensions-swipe"})
    public static interface ItemSwipeCallback {
        public void itemSwiped(int var1, int var2);

        public void itemUnswiped(int var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback$RecyclerTouchTransmitter;", "Landroid/view/View$OnTouchListener;", "(Lcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback;)V", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onTouch", "", "v", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "getFirstVisibleViewByCoordinates", "Landroid/view/ViewGroup;", "x", "", "y", "fastadapter-extensions-swipe"})
    @SuppressLint(value={"ClickableViewAccessibility"})
    public final class RecyclerTouchTransmitter
    implements View.OnTouchListener {
        @Nullable
        private RecyclerView recyclerView;

        public boolean onTouch(@Nullable View v, @NotNull MotionEvent event) {
            View childView;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (SimpleSwipeDrawerCallback.this.isSwiping() || v == null || !(v instanceof ViewGroup)) {
                return false;
            }
            if (v instanceof RecyclerView) {
                this.recyclerView = (RecyclerView)v;
            }
            if ((childView = this.getFirstVisibleViewByCoordinates((ViewGroup)v, event.getX(), event.getY())) != null) {
                switch (event.getActionMasked()) {
                    case 0: {
                        return childView.onTouchEvent(event);
                    }
                    case 1: {
                        return childView.onTouchEvent(event);
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final View getFirstVisibleViewByCoordinates(ViewGroup $this$getFirstVisibleViewByCoordinates, float x, float y) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object viewHolder;
            if (Intrinsics.areEqual((Object)$this$getFirstVisibleViewByCoordinates.getParent(), (Object)this.recyclerView)) {
                RecyclerView recyclerView = this.recyclerView;
                viewHolder = recyclerView != null ? recyclerView.getChildViewHolder((View)$this$getFirstVisibleViewByCoordinates) : null;
                Object object = viewHolder;
                if (!((Map)SimpleSwipeDrawerCallback.this.swipedStates).containsKey(object != null ? Long.valueOf(object.getItemId()) : null)) {
                    return null;
                }
            }
            viewHolder = (Iterable)RangesKt.downTo((int)($this$getFirstVisibleViewByCoordinates.getChildCount() - 1), (int)0);
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add($this$getFirstVisibleViewByCoordinates.getChildAt((int)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                View it = (View)element$iv;
                boolean bl = false;
                Rect bounds = new Rect();
                it.getHitRect(bounds);
                if (!bounds.contains((int)x, (int)y) || it.getVisibility() != 0) continue;
                return it instanceof ViewGroup ? this.getFirstVisibleViewByCoordinates((ViewGroup)it, x - (float)bounds.left, y - (float)bounds.top) : it;
            }
            return null;
        }
    }
}

