/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.swipe;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.swipe.IDrawerSwipeableViewHolder;
import com.mikepenz.fastadapter.swipe.ISwipeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0002()B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J@\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J \u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014H\u0016J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\bJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback;", "Landroidx/recyclerview/widget/ItemTouchHelper$SimpleCallback;", "swipeDirs", "", "itemSwipeCallback", "Lcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback$ItemSwipeCallback;", "(ILcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback$ItemSwipeCallback;)V", "sensitivityFactor", "", "swipeWidthLeftDp", "swipeWidthRightDp", "swipedStates", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "touchTransmitterSet", "", "getSwipeDirs", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "getSwipeEscapeVelocity", "defaultValue", "onChildDraw", "", "c", "Landroid/graphics/Canvas;", "dX", "dY", "actionState", "isCurrentlyActive", "onMove", "target", "onSwiped", "direction", "withSensitivity", "f", "withSwipeLeft", "widthDp", "withSwipeRight", "ItemSwipeCallback", "RecyclerTouchTransmitter", "fastadapter-extensions-swipe"})
public final class SimpleSwipeDrawerCallback
extends ItemTouchHelper.SimpleCallback {
    private float sensitivityFactor;
    private int swipeWidthLeftDp;
    private int swipeWidthRightDp;
    private boolean touchTransmitterSet;
    private final HashMap<Integer, Integer> swipedStates;
    private final int swipeDirs;
    private final ItemSwipeCallback itemSwipeCallback;

    @NotNull
    public final SimpleSwipeDrawerCallback withSwipeLeft(int widthDp) {
        this.swipeWidthLeftDp = widthDp;
        this.setDefaultSwipeDirs(this.swipeDirs | 4);
        return this;
    }

    @NotNull
    public final SimpleSwipeDrawerCallback withSwipeRight(int widthDp) {
        this.swipeWidthRightDp = widthDp;
        this.setDefaultSwipeDirs(this.swipeDirs | 8);
        return this;
    }

    @NotNull
    public final SimpleSwipeDrawerCallback withSensitivity(float f) {
        this.sensitivityFactor = f;
        return this;
    }

    public int getSwipeDirs(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        IItem item = FastAdapter.Companion.getHolderAdapterItem(viewHolder);
        return item instanceof ISwipeable ? (((ISwipeable)item).isSwipeable() ? super.getSwipeDirs(recyclerView, viewHolder) : 0) : super.getSwipeDirs(recyclerView, viewHolder);
    }

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int direction) {
        block4: {
            int position;
            block5: {
                Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
                position = viewHolder.getAdapterPosition();
                if (position == -1) break block4;
                if (!this.swipedStates.containsKey(position)) break block5;
                Integer n = this.swipedStates.get(position);
                if (n != null && n == direction) break block4;
            }
            ItemSwipeCallback itemSwipeCallback = this.itemSwipeCallback;
            if (itemSwipeCallback != null) {
                itemSwipeCallback.itemSwiped(position, direction);
            }
            ((Map)this.swipedStates).put(position, direction);
        }
    }

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, @NotNull RecyclerView.ViewHolder target) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return false;
    }

    public float getSwipeEscapeVelocity(float defaultValue) {
        return defaultValue * this.sensitivityFactor;
    }

    public void onChildDraw(@NotNull Canvas c, @NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        int position;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        View view = viewHolder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"viewHolder.itemView");
        View itemView = view;
        if (!this.touchTransmitterSet) {
            recyclerView.setOnTouchListener((View.OnTouchListener)new RecyclerTouchTransmitter());
            this.touchTransmitterSet = true;
        }
        if ((position = viewHolder.getAdapterPosition()) == -1) {
            return;
        }
        if (actionState == 1) {
            boolean isLeftArea;
            boolean bl = isLeftArea = dX < 0.0f;
            if (0.0f == dX && this.swipedStates.containsKey(position)) {
                ItemSwipeCallback itemSwipeCallback = this.itemSwipeCallback;
                if (itemSwipeCallback != null) {
                    itemSwipeCallback.itemUnswiped(viewHolder.getAdapterPosition());
                }
                this.swipedStates.remove(position);
            }
            Context context = recyclerView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"recyclerView.context");
            Resources resources = context.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"recyclerView.context.resources");
            float swipeWidthPc = resources.getDisplayMetrics().density / (float)itemView.getWidth();
            swipeWidthPc *= (float)(isLeftArea ? this.swipeWidthLeftDp : this.swipeWidthRightDp);
            View swipeableView = itemView;
            if (viewHolder instanceof IDrawerSwipeableViewHolder) {
                swipeableView = ((IDrawerSwipeableViewHolder)viewHolder).getSwipeableView();
            }
            swipeableView.setTranslationX(dX * swipeWidthPc);
        } else {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
    }

    @JvmOverloads
    public SimpleSwipeDrawerCallback(int swipeDirs, @Nullable ItemSwipeCallback itemSwipeCallback) {
        super(0, swipeDirs);
        this.swipeDirs = swipeDirs;
        this.itemSwipeCallback = itemSwipeCallback;
        this.sensitivityFactor = 1.0f;
        this.swipeWidthLeftDp = 20;
        this.swipeWidthRightDp = 20;
        this.swipedStates = new HashMap();
    }

    public /* synthetic */ SimpleSwipeDrawerCallback(int n, ItemSwipeCallback itemSwipeCallback, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        if ((n2 & 2) != 0) {
            itemSwipeCallback = null;
        }
        this(n, itemSwipeCallback);
    }

    @JvmOverloads
    public SimpleSwipeDrawerCallback(int swipeDirs) {
        this(swipeDirs, null, 2, null);
    }

    @JvmOverloads
    public SimpleSwipeDrawerCallback() {
        this(0, null, 3, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback$ItemSwipeCallback;", "", "itemSwiped", "", "position", "", "direction", "itemUnswiped", "fastadapter-extensions-swipe"})
    public static interface ItemSwipeCallback {
        public void itemSwiped(int var1, int var2);

        public void itemUnswiped(int var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/mikepenz/fastadapter/swipe/SimpleSwipeDrawerCallback$RecyclerTouchTransmitter;", "Landroid/view/View$OnTouchListener;", "()V", "onTouch", "", "v", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "getFirstVisibleViewByCoordinates", "Landroid/view/ViewGroup;", "x", "", "y", "fastadapter-extensions-swipe"})
    public static final class RecyclerTouchTransmitter
    implements View.OnTouchListener {
        public boolean onTouch(@Nullable View v, @NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (v == null || !(v instanceof ViewGroup)) {
                return false;
            }
            View childView = this.getFirstVisibleViewByCoordinates((ViewGroup)v, event.getX(), event.getY());
            if (childView != null) {
                switch (event.getActionMasked()) {
                    case 0: {
                        childView.onTouchEvent(event);
                        break;
                    }
                    case 1: {
                        childView.onTouchEvent(event);
                        break;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final View getFirstVisibleViewByCoordinates(ViewGroup $this$getFirstVisibleViewByCoordinates, float x, float y) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)RangesKt.downTo((int)($this$getFirstVisibleViewByCoordinates.getChildCount() - 1), (int)0);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                View view = $this$getFirstVisibleViewByCoordinates.getChildAt((int)it);
                collection.add(view);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                View it = (View)element$iv;
                boolean bl = false;
                Rect bounds = new Rect();
                it.getHitRect(bounds);
                if (!bounds.contains((int)x, (int)y)) continue;
                View view = it;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"it");
                if (view.getVisibility() != 0) continue;
                return it instanceof ViewGroup ? this.getFirstVisibleViewByCoordinates((ViewGroup)it, x - (float)bounds.left, y - (float)bounds.top) : it;
            }
            return null;
        }
    }
}

