/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.swipe;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.swipe.ISwipeable;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001.B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020\u00002\b\b\u0001\u0010#\u001a\u00020\u0007J\u0010\u0010$\u001a\u00020\u00002\b\b\u0001\u0010#\u001a\u00020\u0007J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/mikepenz/fastadapter/swipe/SimpleSwipeCallback;", "Landroidx/recyclerview/widget/ItemTouchHelper$SimpleCallback;", "itemSwipeCallback", "Lcom/mikepenz/fastadapter/swipe/SimpleSwipeCallback$ItemSwipeCallback;", "leaveBehindDrawableLeft", "Landroid/graphics/drawable/Drawable;", "swipeDirs", "", "bgColorLeft", "(Lcom/mikepenz/fastadapter/swipe/SimpleSwipeCallback$ItemSwipeCallback;Landroid/graphics/drawable/Drawable;II)V", "bgColorRight", "bgPaint", "Landroid/graphics/Paint;", "horizontalMargin", "leaveBehindDrawableRight", "getSwipeDirs", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "onChildDraw", "", "c", "Landroid/graphics/Canvas;", "dX", "", "dY", "actionState", "isCurrentlyActive", "", "onMove", "target", "onSwiped", "direction", "withBackgroundSwipeLeft", "bgColor", "withBackgroundSwipeRight", "withHorizontalMarginDp", "ctx", "Landroid/content/Context;", "dp", "withHorizontalMarginPx", "px", "withLeaveBehindSwipeLeft", "d", "withLeaveBehindSwipeRight", "ItemSwipeCallback", "fastadapter-extensions-swipe"})
public final class SimpleSwipeCallback
extends ItemTouchHelper.SimpleCallback {
    private int bgColorRight;
    private Drawable leaveBehindDrawableRight;
    private Paint bgPaint;
    private int horizontalMargin;
    private final ItemSwipeCallback itemSwipeCallback;
    private Drawable leaveBehindDrawableLeft;
    private final int swipeDirs;
    private int bgColorLeft;

    @NotNull
    public final SimpleSwipeCallback withLeaveBehindSwipeLeft(@NotNull Drawable d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        this.leaveBehindDrawableLeft = d;
        this.setDefaultSwipeDirs(this.swipeDirs | 4);
        return this;
    }

    @NotNull
    public final SimpleSwipeCallback withLeaveBehindSwipeRight(@NotNull Drawable d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        this.leaveBehindDrawableRight = d;
        this.setDefaultSwipeDirs(this.swipeDirs | 8);
        return this;
    }

    @NotNull
    public final SimpleSwipeCallback withHorizontalMarginDp(@NotNull Context ctx, int dp) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Resources resources = ctx.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"ctx.resources");
        return this.withHorizontalMarginPx((int)(resources.getDisplayMetrics().density * (float)dp));
    }

    @NotNull
    public final SimpleSwipeCallback withHorizontalMarginPx(int px) {
        this.horizontalMargin = px;
        return this;
    }

    @NotNull
    public final SimpleSwipeCallback withBackgroundSwipeLeft(@ColorInt int bgColor) {
        this.bgColorLeft = bgColor;
        this.setDefaultSwipeDirs(this.swipeDirs | 4);
        return this;
    }

    @NotNull
    public final SimpleSwipeCallback withBackgroundSwipeRight(@ColorInt int bgColor) {
        this.bgColorRight = bgColor;
        this.setDefaultSwipeDirs(this.swipeDirs | 8);
        return this;
    }

    public int getSwipeDirs(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        IItem item = FastAdapter.Companion.getHolderAdapterItem(viewHolder);
        return item instanceof ISwipeable ? (((ISwipeable)item).isSwipeable() ? super.getSwipeDirs(recyclerView, viewHolder) : 0) : super.getSwipeDirs(recyclerView, viewHolder);
    }

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int direction) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        View view = viewHolder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"viewHolder.itemView");
        view.setTranslationX(0.0f);
        View view2 = viewHolder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"viewHolder.itemView");
        view2.setTranslationY(0.0f);
        int position = viewHolder.getAdapterPosition();
        if (position != -1) {
            this.itemSwipeCallback.itemSwiped(position, direction);
        }
    }

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, @NotNull RecyclerView.ViewHolder target) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return false;
    }

    public void onChildDraw(@NotNull Canvas c, @NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        View view = viewHolder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"viewHolder.itemView");
        View itemView = view;
        if (viewHolder.getAdapterPosition() == -1) {
            return;
        }
        boolean bl = false;
        float f = Math.abs(dX);
        bl = false;
        float f2 = Math.abs(dY);
        if (f > f2) {
            Drawable drawable;
            boolean isLeft;
            boolean bl2 = isLeft = dX < 0.0f;
            if (this.bgPaint == null) {
                this.bgPaint = new Paint();
                if (this.horizontalMargin == Integer.MAX_VALUE) {
                    Context context = recyclerView.getContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"recyclerView.context");
                    this.withHorizontalMarginDp(context, 16);
                }
            }
            Paint paint = this.bgPaint;
            if (paint == null) {
                return;
            }
            Paint bgPaint = paint;
            bgPaint.setColor(isLeft ? this.bgColorLeft : this.bgColorRight);
            if (bgPaint.getColor() != 0) {
                int left = isLeft ? itemView.getRight() + (int)dX : itemView.getLeft();
                int right = isLeft ? itemView.getRight() : itemView.getLeft() + (int)dX;
                c.drawRect((float)left, (float)itemView.getTop(), (float)right, (float)itemView.getBottom(), bgPaint);
            }
            Drawable drawable2 = drawable = isLeft ? this.leaveBehindDrawableLeft : this.leaveBehindDrawableRight;
            if (drawable != null) {
                int itemHeight = itemView.getBottom() - itemView.getTop();
                int intrinsicWidth = drawable.getIntrinsicWidth();
                int intrinsicHeight = drawable.getIntrinsicHeight();
                int left = 0;
                int right = 0;
                if (isLeft) {
                    left = itemView.getRight() - this.horizontalMargin - intrinsicWidth;
                    right = itemView.getRight() - this.horizontalMargin;
                } else {
                    left = itemView.getLeft() + this.horizontalMargin;
                    right = itemView.getLeft() + this.horizontalMargin + intrinsicWidth;
                }
                int top = itemView.getTop() + (itemHeight - intrinsicHeight) / 2;
                int bottom = top + intrinsicHeight;
                drawable.setBounds(left, top, right, bottom);
                drawable.draw(c);
            }
        }
        super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
    }

    @JvmOverloads
    public SimpleSwipeCallback(@NotNull ItemSwipeCallback itemSwipeCallback, @Nullable Drawable leaveBehindDrawableLeft, int swipeDirs, @ColorInt int bgColorLeft) {
        Intrinsics.checkParameterIsNotNull((Object)itemSwipeCallback, (String)"itemSwipeCallback");
        super(0, swipeDirs);
        this.itemSwipeCallback = itemSwipeCallback;
        this.leaveBehindDrawableLeft = leaveBehindDrawableLeft;
        this.swipeDirs = swipeDirs;
        this.bgColorLeft = bgColorLeft;
        this.horizontalMargin = Integer.MAX_VALUE;
    }

    public /* synthetic */ SimpleSwipeCallback(ItemSwipeCallback itemSwipeCallback, Drawable drawable, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 4;
        }
        if ((n3 & 8) != 0) {
            n2 = -65536;
        }
        this(itemSwipeCallback, drawable, n, n2);
    }

    @JvmOverloads
    public SimpleSwipeCallback(@NotNull ItemSwipeCallback itemSwipeCallback, @Nullable Drawable leaveBehindDrawableLeft, int swipeDirs) {
        this(itemSwipeCallback, leaveBehindDrawableLeft, swipeDirs, 0, 8, null);
    }

    @JvmOverloads
    public SimpleSwipeCallback(@NotNull ItemSwipeCallback itemSwipeCallback, @Nullable Drawable leaveBehindDrawableLeft) {
        this(itemSwipeCallback, leaveBehindDrawableLeft, 0, 0, 12, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/mikepenz/fastadapter/swipe/SimpleSwipeCallback$ItemSwipeCallback;", "", "itemSwiped", "", "position", "", "direction", "fastadapter-extensions-swipe"})
    public static interface ItemSwipeCallback {
        public void itemSwiped(int var1, int var2);
    }
}

