/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.IParentItem;
import com.mikepenz.fastadapter.ISubItem;
import com.mikepenz.fastadapter.expandable.ExpandableExtension;
import com.mikepenz.fastadapter.select.SelectExtension;
import com.mikepenz.fastadapter.select.SelectExtensionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0007J \u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J>\u0010\u0003\u001a\u00020\u00042\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0018\u00010\bH\u0003J7\u0010\u000f\u001a\u00020\u0004\"\u0014\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\t*\u0006\u0012\u0002\b\u00030\u00112\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u0002H\u0010H\u0007\u00a2\u0006\u0002\u0010\u0014J=\u0010\u000f\u001a\u00020\u0004\"\u0014\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\t*\u0006\u0012\u0002\b\u00030\u00112\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00162\u0006\u0010\u0013\u001a\u0002H\u0010H\u0007\u00a2\u0006\u0002\u0010\u0017JP\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00122\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0007JL\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00122\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0007J4\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r2\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0007J*\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r2\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J>\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0007JJ\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r2\u0012\u0010\f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0018\u00010\bH\u0003J3\u0010%\u001a\u0004\u0018\u0001H\u0010\"\u0014\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\u0011*\u0006\u0012\u0002\b\u00030\t2\f\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0003\u00a2\u0006\u0002\u0010'Jg\u0010(\u001a\u00020)\"\u0014\b\u0000\u0010**\u0006\u0012\u0002\b\u00030\t*\u0006\u0012\u0002\b\u00030\u00112\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00122\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0013\u001a\u0002H*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010.JT\u0010(\u001a\u00020)\"\u0014\b\u0000\u0010**\u0006\u0012\u0002\b\u00030\t*\u0006\u0012\u0002\b\u00030\u00112\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00122\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\b\b\u0002\u0010-\u001a\u00020\u000bH\u0007JK\u0010/\u001a\u00020)\"\u0014\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\t*\u0006\u0012\u0002\b\u00030\u0011\"\u000e\b\u0001\u00100*\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0005\u001a\u0002H02\u0006\u0010\u0013\u001a\u0002H\u00102\u0006\u00101\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u00102JU\u0010/\u001a\u00020)\"\f\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\t\"\u000e\b\u0001\u00100*\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0005\u001a\u0002H02\u0006\u0010\u0013\u001a\u0002H\u00102\u0006\u00101\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u00104\u00a8\u00066"}, d2={"Lcom/mikepenz/fastadapter/utils/SubItemUtil;", "", "()V", "countItems", "", "adapter", "Lcom/mikepenz/fastadapter/IItemAdapter;", "predicate", "Lcom/mikepenz/fastadapter/utils/SubItemUtil$IPredicate;", "Lcom/mikepenz/fastadapter/IItem;", "countHeaders", "", "items", "", "subItemsOnly", "countSelectedSubItems", "T", "Lcom/mikepenz/fastadapter/IExpandable;", "Lcom/mikepenz/fastadapter/FastAdapter;", "header", "(Lcom/mikepenz/fastadapter/FastAdapter;Lcom/mikepenz/fastadapter/IItem;)I", "selections", "", "(Ljava/util/Set;Lcom/mikepenz/fastadapter/IItem;)I", "delete", "fastAdapter", "expandableExtension", "Lcom/mikepenz/fastadapter/expandable/ExpandableExtension;", "identifiersToDelete", "", "", "notifyParent", "deleteEmptyHeaders", "deleteSelected", "selectExtension", "Lcom/mikepenz/fastadapter/select/SelectExtension;", "getAllItems", "getParent", "item", "(Lcom/mikepenz/fastadapter/IItem;)Lcom/mikepenz/fastadapter/IExpandable;", "notifyItemsChanged", "", "Item", "identifiers", "checkSubItems", "restoreExpandedState", "(Lcom/mikepenz/fastadapter/FastAdapter;Lcom/mikepenz/fastadapter/expandable/ExpandableExtension;Lcom/mikepenz/fastadapter/IItem;Ljava/util/Set;ZZ)V", "selectAllSubItems", "Adapter", "select", "(Lcom/mikepenz/fastadapter/FastAdapter;Lcom/mikepenz/fastadapter/IItem;Z)V", "payload", "(Lcom/mikepenz/fastadapter/FastAdapter;Lcom/mikepenz/fastadapter/IItem;ZZLjava/lang/Object;)V", "IPredicate", "fastadapter-extensions-expandable"})
public final class SubItemUtil {
    @NotNull
    public static final SubItemUtil INSTANCE = new SubItemUtil();

    private SubItemUtil() {
    }

    @JvmStatic
    public static final int countItems(@NotNull IItemAdapter<?, ?> adapter, @NotNull IPredicate<IItem<?>> predicate) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return SubItemUtil.countItems(adapter.getAdapterItems(), true, false, predicate);
    }

    @JvmStatic
    public static final int countItems(@NotNull IItemAdapter<?, ?> adapter, boolean countHeaders) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        return SubItemUtil.countItems(adapter.getAdapterItems(), countHeaders, false, null);
    }

    @JvmStatic
    private static final int countItems(List<? extends IItem<?>> items, boolean countHeaders, boolean subItemsOnly, IPredicate<IItem<?>> predicate) {
        return SubItemUtil.getAllItems(items, countHeaders, subItemsOnly, predicate).size();
    }

    @JvmStatic
    @NotNull
    public static final List<IItem<?>> getAllItems(@NotNull IItemAdapter<?, ?> adapter, @NotNull IPredicate<IItem<?>> predicate) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return SubItemUtil.getAllItems(adapter.getAdapterItems(), true, false, predicate);
    }

    @JvmStatic
    @NotNull
    public static final List<IItem<?>> getAllItems(@NotNull IItemAdapter<?, ?> adapter, boolean countHeaders) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        return SubItemUtil.getAllItems(adapter.getAdapterItems(), countHeaders, false, null);
    }

    @JvmStatic
    @NotNull
    public static final List<IItem<?>> getAllItems(@NotNull List<? extends IItem<?>> items, boolean countHeaders, @NotNull IPredicate<IItem<?>> predicate) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return SubItemUtil.getAllItems(items, countHeaders, false, predicate);
    }

    @JvmStatic
    private static final List<IItem<?>> getAllItems(List<? extends IItem<?>> items, boolean countHeaders, boolean subItemsOnly, IPredicate<IItem<?>> predicate) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (items == null || items.isEmpty()) {
            return res;
        }
        int itemCount = items.size();
        IItem<?> item = null;
        List subItems = null;
        for (int i = 0; i < itemCount; ++i) {
            item = items.get(i);
            if (item instanceof IExpandable) {
                subItems = ((IExpandable)item).getSubItems();
                if (predicate == null) {
                    if (countHeaders) {
                        res.add(item);
                    }
                    if (!((Collection)subItems).isEmpty()) {
                        res.addAll(subItems);
                    }
                    res.addAll((Collection)SubItemUtil.getAllItems(subItems, countHeaders, true, predicate));
                    continue;
                }
                if (countHeaders && predicate.apply(item)) {
                    res.add(item);
                }
                int n = subItems.size();
                for (int j = 0; j < n; ++j) {
                    ISubItem it = (ISubItem)subItems.get(j);
                    boolean bl = false;
                    if (!predicate.apply((IItem<?>)it)) continue;
                    res.add(it);
                }
                continue;
            }
            if (subItemsOnly) continue;
            if (SubItemUtil.getParent(item) != null) continue;
            IPredicate<IItem<?>> iPredicate = predicate;
            if (iPredicate != null ? !iPredicate.apply(item) : false) continue;
            res.add(item);
        }
        return res;
    }

    @JvmStatic
    public static final <T extends IItem<?> & IExpandable<?>> int countSelectedSubItems(@NotNull FastAdapter<?> adapter, @NotNull T header) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        SelectExtension extension = (SelectExtension)adapter.getExtension(SelectExtension.class);
        if (extension != null) {
            Set selections = extension.getSelectedItems();
            return SubItemUtil.countSelectedSubItems(selections, header);
        }
        return 0;
    }

    @JvmStatic
    public static final <T extends IItem<?> & IExpandable<?>> int countSelectedSubItems(@NotNull Set<? extends IItem<?>> selections, @NotNull T header) {
        Intrinsics.checkNotNullParameter(selections, (String)"selections");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        int count = 0;
        List subItems = ((IExpandable<?>)header).getSubItems();
        int n = subItems.size();
        for (int i = 0; i < n; ++i) {
            if (selections.contains(subItems.get(i))) {
                ++count;
            }
            if (!(subItems.get(i) instanceof IExpandable)) continue;
            Object e = subItems.get(i);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type T of com.mikepenz.fastadapter.utils.SubItemUtil.countSelectedSubItems");
            count += SubItemUtil.countSelectedSubItems(selections, (IItem)e);
        }
        return count;
    }

    @JvmStatic
    public static final <T extends IItem<?> & IExpandable<?>, Adapter extends FastAdapter<T>> void selectAllSubItems(@NotNull Adapter adapter, @NotNull T header, boolean select) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        SubItemUtil.selectAllSubItems(adapter, header, select, false, null);
    }

    @JvmStatic
    public static final <T extends IItem<?>, Adapter extends FastAdapter<T>> void selectAllSubItems(@NotNull Adapter adapter, @NotNull T header, boolean select, boolean notifyParent, @Nullable Object payload) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        if (header instanceof IExpandable) {
            List subItems = ((IExpandable)header).getSubItems();
            int position = adapter.getPosition(header);
            if (((IExpandable)header).isExpanded()) {
                int n = subItems.size();
                for (int i = 0; i < n; ++i) {
                    SelectExtension extension;
                    Object e = subItems.get(i);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.mikepenz.fastadapter.IItem<*>");
                    if (((IItem)e).isSelectable() && (extension = SelectExtensionKt.getSelectExtension(adapter)) != null) {
                        if (select) {
                            SelectExtension.select$default((SelectExtension)extension, (int)(position + i + 1), (boolean)false, (boolean)false, (int)6, null);
                        } else {
                            SelectExtension.deselect$default((SelectExtension)extension, (int)(position + i + 1), null, (int)2, null);
                        }
                    }
                    if (!(subItems.get(i) instanceof IExpandable)) continue;
                    SubItemUtil.selectAllSubItems(adapter, header, select, notifyParent, payload);
                }
            } else {
                int n = subItems.size();
                for (int i = 0; i < n; ++i) {
                    Object e = subItems.get(i);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.mikepenz.fastadapter.IItem<*>");
                    if (((IItem)e).isSelectable()) {
                        Object e2 = subItems.get(i);
                        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type com.mikepenz.fastadapter.IItem<*>");
                        ((IItem)e2).setSelected(select);
                    }
                    if (!(subItems.get(i) instanceof IExpandable)) continue;
                    SubItemUtil.selectAllSubItems(adapter, header, select, notifyParent, payload);
                }
            }
            if (notifyParent && position >= 0) {
                adapter.notifyItemChanged(position, payload);
            }
        }
    }

    @JvmStatic
    private static final <T extends IExpandable<?> & IItem<?>> T getParent(IItem<?> item) {
        IExpandable iExpandable = item instanceof IExpandable ? (IExpandable)item : null;
        IParentItem iParentItem = iExpandable != null ? iExpandable.getParent() : null;
        return (T)(iParentItem instanceof IExpandable ? (IExpandable)iParentItem : null);
    }

    @JvmStatic
    @NotNull
    public static final List<IItem<?>> deleteSelected(@NotNull FastAdapter<IItem<?>> fastAdapter, @NotNull SelectExtension<?> selectExtension, @NotNull ExpandableExtension<?> expandableExtension, boolean notifyParent, boolean deleteEmptyHeaders) {
        Intrinsics.checkNotNullParameter(fastAdapter, (String)"fastAdapter");
        Intrinsics.checkNotNullParameter(selectExtension, (String)"selectExtension");
        Intrinsics.checkNotNullParameter(expandableExtension, (String)"expandableExtension");
        ArrayList<IItem> deleted = new ArrayList<IItem>();
        LinkedList selectedItems = new LinkedList(selectExtension.getSelectedItems());
        IItem item = null;
        IItem parent = null;
        int pos = 0;
        int parentPos = 0;
        boolean expanded2 = false;
        ListIterator<IItem> listIterator = selectedItems.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"selectedItems.listIterator()");
        ListIterator<IItem> it = listIterator;
        while (it.hasNext()) {
            Object e = it.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"it.next()");
            item = (IItem)e;
            pos = fastAdapter.getPosition(item);
            parent = (IItem)SubItemUtil.getParent(item);
            if (parent != null) {
                parentPos = fastAdapter.getPosition(parent);
                List subItems = ((IExpandable)parent).getSubItems();
                TypeIntrinsics.asMutableCollection((Object)subItems).remove(item);
                if (parentPos != -1 && ((IExpandable)parent).isExpanded()) {
                    expandableExtension.notifyAdapterSubItemsChanged(parentPos, subItems.size() + 1);
                }
                if (parentPos != -1 && notifyParent) {
                    expanded2 = ((IExpandable)parent).isExpanded();
                    FastAdapter.notifyAdapterItemChanged$default(fastAdapter, (int)parentPos, null, (int)2, null);
                    if (expanded2) {
                        ExpandableExtension.expand$default(expandableExtension, parentPos, false, 2, null);
                    }
                }
                deleted.add(item);
                if (!deleteEmptyHeaders || !subItems.isEmpty()) continue;
                it.add(parent);
                it.previous();
                continue;
            }
            if (pos == -1) continue;
            IAdapter adapter = fastAdapter.getAdapter(pos);
            if (adapter instanceof IItemAdapter) {
                ((IItemAdapter)adapter).remove(pos);
            }
            deleted.add(item);
        }
        return deleted;
    }

    @JvmStatic
    @NotNull
    public static final List<IItem<?>> delete(@NotNull FastAdapter<IItem<?>> fastAdapter, @NotNull ExpandableExtension<?> expandableExtension, @Nullable Collection<Long> identifiersToDelete, boolean notifyParent, boolean deleteEmptyHeaders) {
        Intrinsics.checkNotNullParameter(fastAdapter, (String)"fastAdapter");
        Intrinsics.checkNotNullParameter(expandableExtension, (String)"expandableExtension");
        ArrayList<IItem> deleted = new ArrayList<IItem>();
        if (identifiersToDelete == null || identifiersToDelete.isEmpty()) {
            return deleted;
        }
        LinkedList<Long> identifiers = new LinkedList<Long>(identifiersToDelete);
        IItem item = null;
        IItem parent = null;
        int pos = 0;
        int parentPos = 0;
        boolean expanded2 = false;
        long identifier = 0L;
        ListIterator<Long> listIterator = identifiers.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"identifiers.listIterator()");
        ListIterator<Long> it = listIterator;
        while (it.hasNext()) {
            Object e = it.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"it.next()");
            identifier = ((Number)e).longValue();
            pos = fastAdapter.getPosition(identifier);
            if (fastAdapter.getItem(pos) == null) continue;
            parent = (IItem)SubItemUtil.getParent(item);
            if (parent != null) {
                parentPos = fastAdapter.getPosition(parent);
                List subItems = ((IExpandable)parent).getSubItems();
                if (parentPos != -1 && ((IExpandable)parent).isExpanded()) {
                    expandableExtension.notifyAdapterSubItemsChanged(parentPos, subItems.size() + 1);
                }
                if (parentPos != -1 && notifyParent) {
                    expanded2 = ((IExpandable)parent).isExpanded();
                    FastAdapter.notifyAdapterItemChanged$default(fastAdapter, (int)parentPos, null, (int)2, null);
                    if (expanded2) {
                        ExpandableExtension.expand$default(expandableExtension, parentPos, false, 2, null);
                    }
                }
                deleted.add(item);
                if (!deleteEmptyHeaders || !subItems.isEmpty()) continue;
                it.add(parent.getIdentifier());
                it.previous();
                continue;
            }
            if (pos == -1) continue;
            IAdapter adapter = fastAdapter.getAdapter(pos);
            boolean success = false;
            if (adapter instanceof IItemAdapter) {
                success = true;
                fastAdapter.notifyAdapterItemRemoved(pos);
            }
            deleted.add(item);
        }
        return deleted;
    }

    @JvmStatic
    @JvmOverloads
    public static final <Item extends IItem<?> & IExpandable<?>> void notifyItemsChanged(@NotNull FastAdapter<IItem<?>> adapter, @NotNull ExpandableExtension<?> expandableExtension, @NotNull Set<Long> identifiers, boolean restoreExpandedState) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(expandableExtension, (String)"expandableExtension");
        Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
        IItem item = null;
        int n = adapter.getItemCount();
        for (int i = 0; i < n; ++i) {
            item = adapter.getItem(i);
            if (item instanceof IExpandable) {
                SubItemUtil.notifyItemsChanged(adapter, expandableExtension, item, identifiers, true, restoreExpandedState);
                continue;
            }
            IItem iItem = item;
            if (!CollectionsKt.contains((Iterable)identifiers, (Object)(iItem != null ? Long.valueOf(iItem.getIdentifier()) : null))) continue;
            FastAdapter.notifyAdapterItemChanged$default(adapter, (int)i, null, (int)2, null);
        }
    }

    public static /* synthetic */ void notifyItemsChanged$default(FastAdapter fastAdapter, ExpandableExtension expandableExtension, Set set, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        SubItemUtil.notifyItemsChanged(fastAdapter, expandableExtension, set, bl);
    }

    @JvmStatic
    public static final <Item extends IItem<?> & IExpandable<?>> void notifyItemsChanged(@NotNull FastAdapter<IItem<?>> adapter, @NotNull ExpandableExtension<?> expandableExtension, @NotNull Item header, @NotNull Set<Long> identifiers, boolean checkSubItems, boolean restoreExpandedState) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(expandableExtension, (String)"expandableExtension");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
        List subItems = ((IExpandable<?>)header).getSubItems();
        int subItemsCount = subItems.size();
        int position = adapter.getPosition(header);
        boolean expanded2 = ((IExpandable<?>)header).isExpanded();
        if (identifiers.contains(((IExpandable<?>)header).getIdentifier())) {
            FastAdapter.notifyAdapterItemChanged$default(adapter, (int)position, null, (int)2, null);
        }
        IItem item = null;
        if (((IExpandable<?>)header).isExpanded()) {
            for (int i = 0; i < subItemsCount; ++i) {
                item = (IItem)subItems.get(i);
                if (identifiers.contains(item.getIdentifier())) {
                    FastAdapter.notifyAdapterItemChanged$default(adapter, (int)(position + i + 1), null, (int)2, null);
                }
                if (!checkSubItems || !(item instanceof IExpandable)) continue;
                SubItemUtil.notifyItemsChanged(adapter, expandableExtension, item, identifiers, true, restoreExpandedState);
            }
        }
        if (restoreExpandedState && expanded2) {
            ExpandableExtension.expand$default(expandableExtension, position, false, 2, null);
        }
    }

    @JvmStatic
    @JvmOverloads
    public static final <Item extends IItem<?> & IExpandable<?>> void notifyItemsChanged(@NotNull FastAdapter<IItem<?>> adapter, @NotNull ExpandableExtension<?> expandableExtension, @NotNull Set<Long> identifiers) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(expandableExtension, (String)"expandableExtension");
        Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
        SubItemUtil.notifyItemsChanged$default(adapter, expandableExtension, identifiers, false, 8, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mikepenz/fastadapter/utils/SubItemUtil$IPredicate;", "T", "", "apply", "", "data", "(Ljava/lang/Object;)Z", "fastadapter-extensions-expandable"})
    public static interface IPredicate<T> {
        public boolean apply(T var1);
    }
}

