package com.mikepenz.fastadapter.expandable.items

import androidx.recyclerview.widget.RecyclerView
import com.mikepenz.fastadapter.*
import com.mikepenz.fastadapter.items.AbstractItem

abstract class AbstractExpandableItem<VH : RecyclerView.ViewHolder> :
        AbstractItem<VH>(),
        IItem<VH>,
        IExpandable<VH> {
    override var isExpanded: Boolean = false
    override var parent: IParentItem<*>? = null

    override var subItems: MutableList<ISubItem<*>> = MutableSubItemList(this)
        set(value) {
            field = value
            for (item in value) {
                item.parent = this
            }
        }

    override val isAutoExpanding: Boolean = true
    override var isSelectable: Boolean
        get() = subItems.isNullOrEmpty()
        set(_) {}
}
