/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import java.util.ArrayList;
import java.util.List;

public class AdapterUtil {
    public static <Item extends IItem<? extends RecyclerView.ViewHolder> & IExpandable<?, ?, ?>> void restoreSubItemSelectionStatesForAlternativeStateManagement(Item item, List<String> selectedItems) {
        if (item instanceof IExpandable && !((IExpandable<?, ?, ?>)item).isExpanded() && ((IExpandable<?, ?, ?>)item).getSubItems() != null) {
            List subItems = ((IExpandable<?, ?, ?>)item).getSubItems();
            int size = subItems.size();
            for (int i = 0; i < size; ++i) {
                IItem subItem = (IItem)subItems.get(i);
                String id = String.valueOf(subItem.getIdentifier());
                if (selectedItems != null && selectedItems.contains(id)) {
                    subItem.setSelected(true);
                }
                AdapterUtil.restoreSubItemSelectionStatesForAlternativeStateManagement(subItem, selectedItems);
            }
        }
    }

    public static <Item extends IItem<? extends RecyclerView.ViewHolder> & IExpandable<?, ?, ?>> void findSubItemSelections(Item item, List<String> selections) {
        if (item instanceof IExpandable && !((IExpandable<?, ?, ?>)item).isExpanded() && ((IExpandable<?, ?, ?>)item).getSubItems() != null) {
            List subItems = ((IExpandable<?, ?, ?>)item).getSubItems();
            int size = subItems.size();
            for (int i = 0; i < size; ++i) {
                IItem subItem = (IItem)subItems.get(i);
                String id = String.valueOf(subItem.getIdentifier());
                if (subItem.isSelected()) {
                    selections.add(id);
                }
                AdapterUtil.findSubItemSelections(subItem, selections);
            }
        }
    }

    public static <Item extends IItem<? extends RecyclerView.ViewHolder> & IExpandable<?, ?, ?>> List<Item> getAllItems(FastAdapter<Item> fastAdapter) {
        int size = fastAdapter.getItemCount();
        ArrayList<IItem> items = new ArrayList<IItem>(size);
        for (int i = 0; i < size; ++i) {
            IItem item = fastAdapter.getItem(i);
            items.add(item);
            AdapterUtil.addAllSubItems(item, items);
        }
        return items;
    }

    public static <Item extends IItem<? extends RecyclerView.ViewHolder> & IExpandable<?, ?, ?>> void addAllSubItems(Item item, List<Item> items) {
        if (item instanceof IExpandable && !((IExpandable<?, ?, ?>)item).isExpanded() && ((IExpandable<?, ?, ?>)item).getSubItems() != null) {
            List subItems = ((IExpandable<?, ?, ?>)item).getSubItems();
            int size = subItems.size();
            for (int i = 0; i < size; ++i) {
                IItem subItem = (IItem)subItems.get(i);
                items.add(subItem);
                AdapterUtil.addAllSubItems(subItem, items);
            }
        }
    }
}

