/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.expandable.items;

import android.support.v7.widget.RecyclerView;
import com.mikepenz.fastadapter.IClickable;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.ISubItem;
import com.mikepenz.fastadapter.items.AbstractItem;
import java.util.List;

public abstract class AbstractExpandableItem<Parent extends IItem & IExpandable & IClickable, VH extends RecyclerView.ViewHolder, SubItem extends IItem & ISubItem>
extends AbstractItem<Parent, VH>
implements IExpandable<AbstractExpandableItem, SubItem>,
ISubItem<AbstractExpandableItem, Parent> {
    private List<SubItem> mSubItems;
    private Parent mParent;
    private boolean mExpanded = false;

    @Override
    public boolean isExpanded() {
        return this.mExpanded;
    }

    @Override
    public AbstractExpandableItem<Parent, VH, SubItem> withIsExpanded(boolean expanded) {
        this.mExpanded = expanded;
        return this;
    }

    @Override
    public List<SubItem> getSubItems() {
        return this.mSubItems;
    }

    @Override
    public boolean isAutoExpanding() {
        return true;
    }

    @Override
    public AbstractExpandableItem<Parent, VH, SubItem> withSubItems(List<SubItem> subItems) {
        this.mSubItems = subItems;
        for (IItem subItem : subItems) {
            ((ISubItem)subItem).withParent(this);
        }
        return this;
    }

    @Override
    public Parent getParent() {
        return this.mParent;
    }

    @Override
    public AbstractExpandableItem<Parent, VH, SubItem> withParent(Parent parent) {
        this.mParent = parent;
        return this;
    }

    public boolean isSelectable() {
        return this.getSubItems() == null;
    }
}

