/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.expandable;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IAdapterExtension;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.ISubItem;
import com.mikepenz.fastadapter.select.SelectExtension;
import com.mikepenz.fastadapter.utils.AdapterUtil;
import java.util.ArrayList;
import java.util.List;

public class ExpandableExtension<Item extends IItem>
implements IAdapterExtension<Item> {
    protected static final String BUNDLE_EXPANDED = "bundle_expanded";
    protected static final String BUNDLE_EXPANDED_SELECTIONS = "bundle_expanded_selections";
    private FastAdapter<Item> mFastAdapter;
    private boolean mOnlyOneExpandedItem = false;
    private SparseIntArray mExpanded = new SparseIntArray();

    public ExpandableExtension<Item> init(FastAdapter<Item> fastAdapter) {
        this.mFastAdapter = fastAdapter;
        return this;
    }

    public ExpandableExtension<Item> withOnlyOneExpandedItem(boolean mOnlyOneExpandedItem) {
        this.mOnlyOneExpandedItem = mOnlyOneExpandedItem;
        return this;
    }

    public boolean isOnlyOneExpandedItem() {
        return this.mOnlyOneExpandedItem;
    }

    public void withSavedInstanceState(@Nullable Bundle savedInstanceState, String prefix) {
        if (savedInstanceState == null) {
            return;
        }
        ArrayList expandedItems = savedInstanceState.getStringArrayList(BUNDLE_EXPANDED + prefix);
        ArrayList selectedItems = savedInstanceState.getStringArrayList(BUNDLE_EXPANDED_SELECTIONS + prefix);
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            IItem item = this.mFastAdapter.getItem(i);
            String id = String.valueOf(item.getIdentifier());
            if (expandedItems != null && expandedItems.contains(id)) {
                this.expand(i);
                size = this.mFastAdapter.getItemCount();
            }
            AdapterUtil.restoreSubItemSelectionStatesForAlternativeStateManagement(item, selectedItems);
        }
    }

    public void saveInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState == null) {
            return;
        }
        ArrayList<String> selections = new ArrayList<String>();
        ArrayList<String> expandedItems = new ArrayList<String>();
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            IItem item = this.mFastAdapter.getItem(i);
            if (item instanceof IExpandable && ((IExpandable)item).isExpanded()) {
                expandedItems.add(String.valueOf(item.getIdentifier()));
            }
            if (item.isSelected()) {
                selections.add(String.valueOf(item.getIdentifier()));
            }
            AdapterUtil.findSubItemSelections(item, selections);
        }
        savedInstanceState.putStringArrayList(BUNDLE_EXPANDED + prefix, expandedItems);
        savedInstanceState.putStringArrayList(BUNDLE_EXPANDED_SELECTIONS + prefix, selections);
    }

    public boolean onClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
        boolean consumed = false;
        if (!consumed && item instanceof IExpandable && ((IExpandable)item).isAutoExpanding() && ((IExpandable)item).getSubItems() != null) {
            this.toggleExpandable(pos);
        }
        if (!consumed && this.mOnlyOneExpandedItem && item instanceof IExpandable && ((IExpandable)item).getSubItems() != null && ((IExpandable)item).getSubItems().size() > 0) {
            int[] expandedItems = this.getExpandedItemsSameLevel(pos);
            for (int i = expandedItems.length - 1; i >= 0; --i) {
                if (expandedItems[i] == pos) continue;
                this.collapse(expandedItems[i], true);
            }
        }
        return consumed;
    }

    public boolean onLongClick(View v, int pos, FastAdapter<Item> fastAdapter, Item item) {
        return false;
    }

    public boolean onTouch(View v, MotionEvent event, int position, FastAdapter<Item> fastAdapter, Item item) {
        return false;
    }

    public void notifyAdapterDataSetChanged() {
    }

    public void notifyAdapterItemRangeInserted(int position, int itemCount) {
    }

    public void notifyAdapterItemRangeRemoved(int position, int itemCount) {
    }

    public void notifyAdapterItemMoved(int fromPosition, int toPosition) {
        this.collapse(fromPosition);
        this.collapse(toPosition);
    }

    public void notifyAdapterItemRangeChanged(int position, int itemCount, Object payload) {
        for (int i = position; i < position + itemCount; ++i) {
            IItem item = this.mFastAdapter.getItem(position);
            if (!(item instanceof IExpandable) || !((IExpandable)item).isExpanded()) continue;
            this.collapse(position);
        }
    }

    public void set(List<Item> items, boolean resetFilter) {
        this.collapse(false);
    }

    public void performFiltering(CharSequence constraint) {
        this.collapse(false);
    }

    public int notifyAdapterSubItemsChanged(int position, int previousCount) {
        IItem item = this.mFastAdapter.getItem(position);
        if (item != null && item instanceof IExpandable) {
            IExpandable expandable = (IExpandable)item;
            IAdapter adapter = this.mFastAdapter.getAdapter(position);
            if (adapter != null && adapter instanceof IItemAdapter) {
                ((IItemAdapter)adapter).removeRange(position + 1, previousCount);
                ((IItemAdapter)adapter).add(position + 1, expandable.getSubItems());
            }
            return expandable.getSubItems().size();
        }
        return 0;
    }

    public SparseIntArray getExpanded() {
        SparseIntArray expandedItems = new SparseIntArray();
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            IItem item = this.mFastAdapter.getItem(i);
            if (!(item instanceof IExpandable) || !((IExpandable)item).isExpanded()) continue;
            expandedItems.put(i, ((IExpandable)item).getSubItems().size());
        }
        return expandedItems;
    }

    public int[] getExpandedItems() {
        ArrayList<Integer> expandedItemsList = new ArrayList<Integer>();
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            IItem item = this.mFastAdapter.getItem(i);
            if (!(item instanceof IExpandable) || !((IExpandable)item).isExpanded()) continue;
            expandedItemsList.add(i);
        }
        int expandedItemsListLength = expandedItemsList.size();
        int[] expandedItems = new int[expandedItemsListLength];
        for (int i = 0; i < expandedItemsListLength; ++i) {
            expandedItems[i] = (Integer)expandedItemsList.get(i);
        }
        return expandedItems;
    }

    public int[] getExpandedItemsSameLevel(int position) {
        IItem item = this.mFastAdapter.getItem(position);
        if (!(item instanceof ISubItem)) {
            return this.getExpandedItemsRootLevel(position);
        }
        Object parent = ((ISubItem)item).getParent();
        if (!(parent instanceof IExpandable)) {
            return this.getExpandedItemsRootLevel(position);
        }
        ArrayList<Integer> expandedItemsList = new ArrayList<Integer>();
        for (Object subItem : ((IExpandable)parent).getSubItems()) {
            if (!(subItem instanceof IExpandable) || !((IExpandable)subItem).isExpanded() || subItem == item) continue;
            expandedItemsList.add(this.mFastAdapter.getPosition((IItem)subItem));
        }
        int expandedItemsListLength = expandedItemsList.size();
        int[] expandedItems = new int[expandedItemsListLength];
        for (int i = 0; i < expandedItemsListLength; ++i) {
            expandedItems[i] = (Integer)expandedItemsList.get(i);
        }
        return expandedItems;
    }

    public int[] getExpandedItemsRootLevel(int position) {
        ArrayList<Integer> expandedItemsList = new ArrayList<Integer>();
        IItem item = this.mFastAdapter.getItem(position);
        int size = this.mFastAdapter.getItemCount();
        for (int i = 0; i < size; ++i) {
            Object parent;
            IItem currItem = this.mFastAdapter.getItem(i);
            if (!(currItem instanceof ISubItem) || !((parent = ((ISubItem)currItem).getParent()) instanceof IExpandable) || !((IExpandable)parent).isExpanded()) continue;
            i += ((IExpandable)parent).getSubItems().size();
            if (parent == item) continue;
            expandedItemsList.add(this.mFastAdapter.getPosition(parent));
        }
        int expandedItemsListLength = expandedItemsList.size();
        int[] expandedItems = new int[expandedItemsListLength];
        for (int i = 0; i < expandedItemsListLength; ++i) {
            expandedItems[i] = (Integer)expandedItemsList.get(i);
        }
        return expandedItems;
    }

    public void toggleExpandable(int position) {
        IItem item = this.mFastAdapter.getItem(position);
        if (item instanceof IExpandable && ((IExpandable)item).isExpanded()) {
            this.collapse(position);
        } else {
            this.expand(position);
        }
    }

    public void collapse() {
        this.collapse(true);
    }

    public void collapse(boolean notifyItemChanged) {
        int[] expandedItems = this.getExpandedItems();
        for (int i = expandedItems.length - 1; i >= 0; --i) {
            this.collapse(expandedItems[i], notifyItemChanged);
        }
    }

    public void collapse(int position) {
        this.collapse(position, false);
    }

    public void collapse(int position, boolean notifyItemChanged) {
        IExpandable expandable;
        IItem item = this.mFastAdapter.getItem(position);
        if (item != null && item instanceof IExpandable && (expandable = (IExpandable)item).isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            IExpandable tmpExpandable;
            IItem tmp;
            int i;
            int totalAddedItems = expandable.getSubItems().size();
            for (i = position + 1; i <= position + totalAddedItems; ++i) {
                tmp = this.mFastAdapter.getItem(i);
                if (!(tmp instanceof IExpandable) || (tmpExpandable = (IExpandable)tmp).getSubItems() == null || !tmpExpandable.isExpanded()) continue;
                totalAddedItems += tmpExpandable.getSubItems().size();
            }
            for (i = position + totalAddedItems - 1; i > position; --i) {
                tmp = this.mFastAdapter.getItem(i);
                if (!(tmp instanceof IExpandable) || !(tmpExpandable = (IExpandable)tmp).isExpanded()) continue;
                this.collapse(i);
                if (tmpExpandable.getSubItems() == null) continue;
                i -= tmpExpandable.getSubItems().size();
            }
            this.internalCollapse(expandable, position, notifyItemChanged);
        }
    }

    private void internalCollapse(IExpandable expandable, int position, boolean notifyItemChanged) {
        IAdapter adapter = this.mFastAdapter.getAdapter(position);
        if (adapter != null && adapter instanceof IItemAdapter) {
            ((IItemAdapter)adapter).removeRange(position + 1, expandable.getSubItems().size());
        }
        expandable.withIsExpanded(false);
        if (notifyItemChanged) {
            this.mFastAdapter.notifyItemChanged(position);
        }
    }

    public void expand() {
        this.expand(false);
    }

    public void expand(boolean notifyItemChanged) {
        int length = this.mFastAdapter.getItemCount();
        for (int i = length - 1; i >= 0; --i) {
            this.expand(i, notifyItemChanged);
        }
    }

    public void expand(int position) {
        this.expand(position, false);
    }

    public void expand(int position, boolean notifyItemChanged) {
        IExpandable expandable;
        IItem item = this.mFastAdapter.getItem(position);
        if (item != null && item instanceof IExpandable && !(expandable = (IExpandable)item).isExpanded() && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            IAdapter adapter = this.mFastAdapter.getAdapter(position);
            if (adapter != null && adapter instanceof IItemAdapter) {
                ((IItemAdapter)adapter).addInternal(position + 1, expandable.getSubItems());
            }
            expandable.withIsExpanded(true);
            if (notifyItemChanged) {
                this.mFastAdapter.notifyItemChanged(position);
            }
        }
    }

    public int getExpandedItemsCount(int from, int position) {
        int totalAddedItems = 0;
        for (int i = from; i < position; ++i) {
            IExpandable tmpExpandable;
            IItem tmp = this.mFastAdapter.getItem(i);
            if (!(tmp instanceof IExpandable) || (tmpExpandable = (IExpandable)tmp).getSubItems() == null || !tmpExpandable.isExpanded()) continue;
            totalAddedItems += tmpExpandable.getSubItems().size();
        }
        return totalAddedItems;
    }

    public void deselect() {
        SelectExtension selectExtension = this.mFastAdapter.getSelectExtension();
        if (selectExtension == null) {
            return;
        }
        for (IItem item : AdapterUtil.getAllItems(this.mFastAdapter)) {
            selectExtension.deselect(item);
        }
        this.mFastAdapter.notifyDataSetChanged();
    }

    public void select(boolean considerSelectableFlag) {
        SelectExtension selectExtension = this.mFastAdapter.getSelectExtension();
        if (selectExtension == null) {
            return;
        }
        for (IItem item : AdapterUtil.getAllItems(this.mFastAdapter)) {
            selectExtension.select(item, considerSelectableFlag);
        }
        this.mFastAdapter.notifyDataSetChanged();
    }
}

