/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.commons.utils;

import android.support.annotation.Nullable;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.ModelAdapter;
import com.mikepenz.fastadapter.commons.adapters.FastItemAdapter;
import com.mikepenz.fastadapter.commons.utils.DiffCallback;
import com.mikepenz.fastadapter.commons.utils.DiffCallbackImpl;
import com.mikepenz.fastadapter.utils.ComparableItemListImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FastAdapterDiffUtil {
    public static <A extends ModelAdapter<Model, Item>, Model, Item extends IItem> DiffUtil.DiffResult calculateDiff(A adapter, List<Item> items, DiffCallback<Item> callback, boolean detectMoves) {
        if (adapter.isUseIdDistributor()) {
            adapter.getIdDistributor().checkIds(items);
        }
        if (adapter.getItemList() instanceof ComparableItemListImpl) {
            Collections.sort(items, ((ComparableItemListImpl)adapter.getItemList()).getComparator());
        }
        adapter.mapPossibleTypes(items);
        List adapterItems = adapter.getAdapterItems();
        ArrayList oldItems = new ArrayList(adapterItems);
        DiffUtil.DiffResult result = DiffUtil.calculateDiff(new FastAdapterCallback(oldItems, items, callback), (boolean)detectMoves);
        if (items != adapterItems) {
            if (!adapterItems.isEmpty()) {
                adapterItems.clear();
            }
            adapterItems.addAll(items);
        }
        return result;
    }

    public static <A extends ModelAdapter<Model, Item>, Model, Item extends IItem> A set(A adapter, DiffUtil.DiffResult result) {
        result.dispatchUpdatesTo(new FastAdapterListUpdateCallback(adapter));
        return adapter;
    }

    public static <A extends ModelAdapter<Model, Item>, Model, Item extends IItem> DiffUtil.DiffResult calculateDiff(A adapter, List<Item> items, DiffCallback<Item> callback) {
        return FastAdapterDiffUtil.calculateDiff(adapter, items, callback, true);
    }

    public static <A extends ModelAdapter<Model, Item>, Model, Item extends IItem> DiffUtil.DiffResult calculateDiff(A adapter, List<Item> items, boolean detectMoves) {
        return FastAdapterDiffUtil.calculateDiff(adapter, items, new DiffCallbackImpl(), detectMoves);
    }

    public static <A extends ModelAdapter<Model, Item>, Model, Item extends IItem> DiffUtil.DiffResult calculateDiff(A adapter, List<Item> items) {
        return FastAdapterDiffUtil.calculateDiff(adapter, items, new DiffCallbackImpl(), true);
    }

    public static <A extends ModelAdapter<Model, Item>, Model, Item extends IItem> A set(A adapter, List<Item> items, DiffCallback<Item> callback, boolean detectMoves) {
        DiffUtil.DiffResult result = FastAdapterDiffUtil.calculateDiff(adapter, items, callback, detectMoves);
        return FastAdapterDiffUtil.set(adapter, result);
    }

    public static <A extends ModelAdapter<Model, Item>, Model, Item extends IItem> A set(A adapter, List<Item> items, DiffCallback<Item> callback) {
        return FastAdapterDiffUtil.set(adapter, items, callback, true);
    }

    public static <A extends ModelAdapter<Model, Item>, Model, Item extends IItem> A set(A adapter, List<Item> items, boolean detectMoves) {
        return FastAdapterDiffUtil.set(adapter, items, new DiffCallbackImpl(), detectMoves);
    }

    public static <A extends ModelAdapter<Model, Item>, Model, Item extends IItem> A set(A adapter, List<Item> items) {
        return FastAdapterDiffUtil.set(adapter, items, new DiffCallbackImpl());
    }

    public static <A extends FastItemAdapter<Item>, Item extends IItem> DiffUtil.DiffResult calculateDiff(A adapter, List<Item> items, DiffCallback<Item> callback) {
        return FastAdapterDiffUtil.calculateDiff(adapter.getItemAdapter(), items, callback);
    }

    public static <A extends FastItemAdapter<Item>, Item extends IItem> DiffUtil.DiffResult calculateDiff(A adapter, List<Item> items, boolean detectMoves) {
        return FastAdapterDiffUtil.calculateDiff(adapter.getItemAdapter(), items, detectMoves);
    }

    public static <A extends FastItemAdapter<Item>, Item extends IItem> DiffUtil.DiffResult calculateDiff(A adapter, List<Item> items) {
        return FastAdapterDiffUtil.calculateDiff(adapter.getItemAdapter(), items);
    }

    public static <A extends FastItemAdapter<Item>, Item extends IItem> A set(A adapter, List<Item> items, DiffCallback<Item> callback, boolean detectMoves) {
        FastAdapterDiffUtil.set(adapter.getItemAdapter(), items, callback, detectMoves);
        return adapter;
    }

    public static <A extends FastItemAdapter<Item>, Item extends IItem> A set(A adapter, List<Item> items, DiffCallback<Item> callback) {
        FastAdapterDiffUtil.set(adapter.getItemAdapter(), items, callback);
        return adapter;
    }

    public static <A extends FastItemAdapter<Item>, Item extends IItem> A set(A adapter, List<Item> items, boolean detectMoves) {
        FastAdapterDiffUtil.set(adapter.getItemAdapter(), items, detectMoves);
        return adapter;
    }

    public static <A extends FastItemAdapter<Item>, Item extends IItem> A set(A adapter, List<Item> items) {
        return FastAdapterDiffUtil.set(adapter, items, new DiffCallbackImpl());
    }

    public static <A extends FastItemAdapter<Item>, Item extends IItem> A set(A adapter, DiffUtil.DiffResult result) {
        FastAdapterDiffUtil.set(adapter.getItemAdapter(), result);
        return adapter;
    }

    private static final class FastAdapterListUpdateCallback<A extends ModelAdapter<Model, Item>, Model, Item extends IItem>
    implements ListUpdateCallback {
        private final A adapter;

        FastAdapterListUpdateCallback(A adapter) {
            this.adapter = adapter;
        }

        public void onInserted(int position, int count) {
            this.adapter.getFastAdapter().notifyAdapterItemRangeInserted(this.adapter.getFastAdapter().getPreItemCountByOrder(this.adapter.getOrder()) + position, count);
        }

        public void onRemoved(int position, int count) {
            this.adapter.getFastAdapter().notifyAdapterItemRangeRemoved(this.adapter.getFastAdapter().getPreItemCountByOrder(this.adapter.getOrder()) + position, count);
        }

        public void onMoved(int fromPosition, int toPosition) {
            this.adapter.getFastAdapter().notifyAdapterItemMoved(this.adapter.getFastAdapter().getPreItemCountByOrder(this.adapter.getOrder()) + fromPosition, toPosition);
        }

        public void onChanged(int position, int count, Object payload) {
            this.adapter.getFastAdapter().notifyAdapterItemRangeChanged(this.adapter.getFastAdapter().getPreItemCountByOrder(this.adapter.getOrder()) + position, count, payload);
        }
    }

    private static final class FastAdapterCallback<Item extends IItem>
    extends DiffUtil.Callback {
        private final List<Item> oldItems;
        private final List<Item> newItems;
        private final DiffCallback<Item> callback;

        FastAdapterCallback(List<Item> oldItems, List<Item> newItems, DiffCallback<Item> callback) {
            this.oldItems = oldItems;
            this.newItems = newItems;
            this.callback = callback;
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            return this.callback.areItemsTheSame(this.oldItems.get(oldItemPosition), this.newItems.get(newItemPosition));
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            return this.callback.areContentsTheSame(this.oldItems.get(oldItemPosition), this.newItems.get(newItemPosition));
        }

        @Nullable
        public Object getChangePayload(int oldItemPosition, int newItemPosition) {
            Object result = this.callback.getChangePayload(this.oldItems.get(oldItemPosition), oldItemPosition, this.newItems.get(newItemPosition), newItemPosition);
            return result == null ? super.getChangePayload(oldItemPosition, newItemPosition) : result;
        }
    }
}

