/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.commons.utils;

import android.support.annotation.Nullable;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.commons.utils.DiffCallback;
import com.mikepenz.fastadapter.utils.IdDistributor;
import java.util.Collections;
import java.util.List;

public class FastAdapterDiffUtil {
    public static <A extends ItemAdapter<Item>, Item extends IItem> A set(final A adapter, final List<Item> items, final DiffCallback<Item> callback, boolean detectMoves) {
        if (adapter.isUseIdDistributor()) {
            IdDistributor.checkIds(items);
        }
        adapter.getFastAdapter().collapse(false);
        if (adapter.getComparator() != null) {
            Collections.sort(items, adapter.getComparator());
        }
        adapter.mapPossibleTypes(items);
        final List oldItems = adapter.getAdapterItems();
        DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback(){

            public int getOldListSize() {
                return oldItems.size();
            }

            public int getNewListSize() {
                return items.size();
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                return callback.areItemsTheSame(oldItems.get(oldItemPosition), items.get(newItemPosition));
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                return callback.areContentsTheSame(oldItems.get(oldItemPosition), items.get(newItemPosition));
            }

            @Nullable
            public Object getChangePayload(int oldItemPosition, int newItemPosition) {
                Object result = callback.getChangePayload(oldItems.get(oldItemPosition), oldItemPosition, items.get(newItemPosition), newItemPosition);
                return result == null ? super.getChangePayload(oldItemPosition, newItemPosition) : result;
            }
        }, (boolean)detectMoves);
        if (items != oldItems) {
            if (!oldItems.isEmpty()) {
                oldItems.clear();
            }
            oldItems.addAll(items);
        }
        result.dispatchUpdatesTo(new ListUpdateCallback(){

            public void onInserted(int position, int count) {
                adapter.getFastAdapter().notifyAdapterItemRangeInserted(adapter.getFastAdapter().getPreItemCountByOrder(adapter.getOrder()) + position, count);
            }

            public void onRemoved(int position, int count) {
                adapter.getFastAdapter().notifyAdapterItemRangeRemoved(adapter.getFastAdapter().getPreItemCountByOrder(adapter.getOrder()) + position, count);
            }

            public void onMoved(int fromPosition, int toPosition) {
                adapter.getFastAdapter().notifyAdapterItemMoved(adapter.getFastAdapter().getPreItemCountByOrder(adapter.getOrder()) + fromPosition, toPosition);
            }

            public void onChanged(int position, int count, Object payload) {
                adapter.getFastAdapter().notifyAdapterItemRangeChanged(adapter.getFastAdapter().getPreItemCountByOrder(adapter.getOrder()) + position, count, payload);
            }
        });
        return adapter;
    }
}

